" Vim syntax file
" Language: DROID patches
" Maintainer: Der Man mit der Maschine
" Latest Revision: Blue 7

if exists("b:current_syntax")
    finish
endif
let b:current_syntax = "droid"

syntax case ignore

" Define colors for the various parts of the patch
hi ioregister ctermfg=green guifg=green
hi inputParameter ctermfg=cyan
hi outputParameter ctermfg=red term=bold
hi circuitHeader ctermfg=magenta term=bold
hi def link wordError Error
hi cable ctermfg=yellow guifg=yellow
hi number ctermfg=blue term=bold
hi quotestring ctermfg=blue term=bold
hi comment ctermfg=grey guifg=grey

syn match error "." contained

syn match number /\(on\|off\|-\?\([0-9]\|[1-9][0-9]*\)\(\.[0-9]\+\)\?[V%]\?\)/ contained

syn match quotestring /"[^"]*"/ contained
syn match ioregister "[ion][1-8]" contained
syn match ioregister "r[1-9]" contained
syn match ioregister "r[1234][0-9]" contained
syn match ioregister "r5[0-6]" contained
syn match ioregister "g[1-9]" contained
syn match ioregister "g1[012]" contained
syn match ioregister "g[1-4]\.[1-8]" contained
syn match ioregister "x1" contained
syn match ioregister "[rlb]\(1[0-6]\|[1-9]\)\.\([1-2][0-9]\|3[0-2]\|[1-9]\)" contained
syn match ioregister "[ps]\(1[0-6]\|[1-9]\)\.\(10\|[1-9]\)" contained
syn match ioregister "[e]\(1[0-6]\|[1-9]\)\.\([1-4]\)" contained

syn match cable "_[a-z][a-z0-9_]*" contained

syn match punct "=" contained
syn match punct "\*" contained
syn match punct "+" contained
syn match punct "-" contained
syn match punct " " contained

syn match comment "#.*$" contained
syn match comment "#.*$"


" Controllers
syn match p2b8Header /\[p2b8\]/
hi def link p2b8Header circuitHeader
syn match p4b2Header /\[p4b2\]/
hi def link p4b2Header circuitHeader
syn match p8s8Header /\[p8s8\]/
hi def link p8s8Header circuitHeader
syn match b32Header /\[b32\]/
hi def link b32Header circuitHeader
syn match p10Header /\[p10\]/
hi def link p10Header circuitHeader
syn match s10Header /\[s10\]/
hi def link s10Header circuitHeader
syn match m4Header /\[m4\]/
hi def link e4Header circuitHeader
syn match e4Header /\[e4\]/
hi def link db8eHeader circuitHeader
syn match db8eHeader /\[db8e\]/
hi def link m4Header circuitHeader
syn match x7Header /\[x7\]/
hi def link x7Header circuitHeader

syn sync minlines=1000


" adc
syn match adcOutputParameter "^\s*b1" contained
syn match adcOutputParameter "^\s*b10" contained
syn match adcOutputParameter "^\s*b11" contained
syn match adcOutputParameter "^\s*b12" contained
syn match adcOutputParameter "^\s*b2" contained
syn match adcOutputParameter "^\s*b3" contained
syn match adcOutputParameter "^\s*b4" contained
syn match adcOutputParameter "^\s*b5" contained
syn match adcOutputParameter "^\s*b6" contained
syn match adcOutputParameter "^\s*b7" contained
syn match adcOutputParameter "^\s*b8" contained
syn match adcOutputParameter "^\s*b9" contained
syn match adcOutputParameter "^\s*bit" contained
syn match adcOutputParameter "^\s*bit1" contained
syn match adcOutputParameter "^\s*bit10" contained
syn match adcOutputParameter "^\s*bit11" contained
syn match adcOutputParameter "^\s*bit12" contained
syn match adcOutputParameter "^\s*bit2" contained
syn match adcOutputParameter "^\s*bit3" contained
syn match adcOutputParameter "^\s*bit4" contained
syn match adcOutputParameter "^\s*bit5" contained
syn match adcOutputParameter "^\s*bit6" contained
syn match adcOutputParameter "^\s*bit7" contained
syn match adcOutputParameter "^\s*bit8" contained
syn match adcOutputParameter "^\s*bit9" contained
syn match adcInputParameter "^\s*i" contained
syn match adcInputParameter "^\s*input" contained
syn match adcInputParameter "^\s*m" contained
syn match adcInputParameter "^\s*maximum" contained
syn match adcInputParameter "^\s*minimum" contained
syn match adcInputParameter "^\s*x" contained
syn match adcHeader /\[adc\]/ contained
syn region adcCircuit start=/\[adc\]/ end=/\[/me=s-1 transparent contains=adcHeader,adcInputParameter,adcOutputParameter,ioregister,number,cable,quotestring,comment
hi def link adcHeader circuitHeader
hi def link adcInputParameter inputParameter
hi def link adcOutputParameter outputParameter


" algoquencer
syn match algoquencerInputParameter "^\s*a" contained
syn match algoquencerInputParameter "^\s*ab" contained
syn match algoquencerInputParameter "^\s*aba" contained
syn match algoquencerOutputParameter "^\s*ac" contained
syn match algoquencerOutputParameter "^\s*accent" contained
syn match algoquencerInputParameter "^\s*accentbutton" contained
syn match algoquencerInputParameter "^\s*accenthigh" contained
syn match algoquencerInputParameter "^\s*accentlow" contained
syn match algoquencerInputParameter "^\s*activity" contained
syn match algoquencerInputParameter "^\s*ah" contained
syn match algoquencerInputParameter "^\s*al" contained
syn match algoquencerInputParameter "^\s*alb" contained
syn match algoquencerInputParameter "^\s*alternatebars" contained
syn match algoquencerInputParameter "^\s*alternatebutton" contained
syn match algoquencerInputParameter "^\s*alternaterepeats" contained
syn match algoquencerInputParameter "^\s*arp" contained
syn match algoquencerInputParameter "^\s*b1" contained
syn match algoquencerInputParameter "^\s*b10" contained
syn match algoquencerInputParameter "^\s*b11" contained
syn match algoquencerInputParameter "^\s*b12" contained
syn match algoquencerInputParameter "^\s*b13" contained
syn match algoquencerInputParameter "^\s*b14" contained
syn match algoquencerInputParameter "^\s*b15" contained
syn match algoquencerInputParameter "^\s*b16" contained
syn match algoquencerInputParameter "^\s*b2" contained
syn match algoquencerInputParameter "^\s*b3" contained
syn match algoquencerInputParameter "^\s*b4" contained
syn match algoquencerInputParameter "^\s*b5" contained
syn match algoquencerInputParameter "^\s*b6" contained
syn match algoquencerInputParameter "^\s*b7" contained
syn match algoquencerInputParameter "^\s*b8" contained
syn match algoquencerInputParameter "^\s*b9" contained
syn match algoquencerOutputParameter "^\s*barled" contained
syn match algoquencerOutputParameter "^\s*barled1" contained
syn match algoquencerOutputParameter "^\s*barled2" contained
syn match algoquencerOutputParameter "^\s*barled3" contained
syn match algoquencerOutputParameter "^\s*barled4" contained
syn match algoquencerOutputParameter "^\s*bl1" contained
syn match algoquencerOutputParameter "^\s*bl2" contained
syn match algoquencerOutputParameter "^\s*bl3" contained
syn match algoquencerOutputParameter "^\s*bl4" contained
syn match algoquencerOutputParameter "^\s*br" contained
syn match algoquencerOutputParameter "^\s*branch" contained
syn match algoquencerInputParameter "^\s*branches" contained
syn match algoquencerInputParameter "^\s*bs" contained
syn match algoquencerInputParameter "^\s*button" contained
syn match algoquencerInputParameter "^\s*button1" contained
syn match algoquencerInputParameter "^\s*button10" contained
syn match algoquencerInputParameter "^\s*button11" contained
syn match algoquencerInputParameter "^\s*button12" contained
syn match algoquencerInputParameter "^\s*button13" contained
syn match algoquencerInputParameter "^\s*button14" contained
syn match algoquencerInputParameter "^\s*button15" contained
syn match algoquencerInputParameter "^\s*button16" contained
syn match algoquencerInputParameter "^\s*button2" contained
syn match algoquencerInputParameter "^\s*button3" contained
syn match algoquencerInputParameter "^\s*button4" contained
syn match algoquencerInputParameter "^\s*button5" contained
syn match algoquencerInputParameter "^\s*button6" contained
syn match algoquencerInputParameter "^\s*button7" contained
syn match algoquencerInputParameter "^\s*button8" contained
syn match algoquencerInputParameter "^\s*button9" contained
syn match algoquencerInputParameter "^\s*c" contained
syn match algoquencerInputParameter "^\s*ca" contained
syn match algoquencerInputParameter "^\s*cl" contained
syn match algoquencerInputParameter "^\s*clear" contained
syn match algoquencerInputParameter "^\s*clearall" contained
syn match algoquencerInputParameter "^\s*clearpage" contained
syn match algoquencerInputParameter "^\s*clock" contained
syn match algoquencerInputParameter "^\s*cp" contained
syn match algoquencerInputParameter "^\s*d" contained
syn match algoquencerInputParameter "^\s*dejavu" contained
syn match algoquencerInputParameter "^\s*di" contained
syn match algoquencerInputParameter "^\s*display" contained
syn match algoquencerInputParameter "^\s*distribution" contained
syn match algoquencerInputParameter "^\s*dontsave" contained
syn match algoquencerInputParameter "^\s*dos" contained
syn match algoquencerInputParameter "^\s*dy" contained
syn match algoquencerInputParameter "^\s*f" contained
syn match algoquencerInputParameter "^\s*fillorder" contained
syn match algoquencerInputParameter "^\s*fills" contained
syn match algoquencerOutputParameter "^\s*fillsled" contained
syn match algoquencerOutputParameter "^\s*fl" contained
syn match algoquencerInputParameter "^\s*fo" contained
syn match algoquencerOutputParameter "^\s*g" contained
syn match algoquencerOutputParameter "^\s*gate" contained
syn match algoquencerInputParameter "^\s*gatelength" contained
syn match algoquencerInputParameter "^\s*gl" contained
syn match algoquencerInputParameter "^\s*header" contained
syn match algoquencerInputParameter "^\s*hr" contained
syn match algoquencerInputParameter "^\s*l" contained
syn match algoquencerOutputParameter "^\s*l1" contained
syn match algoquencerOutputParameter "^\s*l10" contained
syn match algoquencerOutputParameter "^\s*l11" contained
syn match algoquencerOutputParameter "^\s*l12" contained
syn match algoquencerOutputParameter "^\s*l13" contained
syn match algoquencerOutputParameter "^\s*l14" contained
syn match algoquencerOutputParameter "^\s*l15" contained
syn match algoquencerOutputParameter "^\s*l16" contained
syn match algoquencerOutputParameter "^\s*l2" contained
syn match algoquencerOutputParameter "^\s*l3" contained
syn match algoquencerOutputParameter "^\s*l4" contained
syn match algoquencerOutputParameter "^\s*l5" contained
syn match algoquencerOutputParameter "^\s*l6" contained
syn match algoquencerOutputParameter "^\s*l7" contained
syn match algoquencerOutputParameter "^\s*l8" contained
syn match algoquencerOutputParameter "^\s*l9" contained
syn match algoquencerInputParameter "^\s*lb" contained
syn match algoquencerOutputParameter "^\s*led" contained
syn match algoquencerOutputParameter "^\s*led1" contained
syn match algoquencerOutputParameter "^\s*led10" contained
syn match algoquencerOutputParameter "^\s*led11" contained
syn match algoquencerOutputParameter "^\s*led12" contained
syn match algoquencerOutputParameter "^\s*led13" contained
syn match algoquencerOutputParameter "^\s*led14" contained
syn match algoquencerOutputParameter "^\s*led15" contained
syn match algoquencerOutputParameter "^\s*led16" contained
syn match algoquencerOutputParameter "^\s*led2" contained
syn match algoquencerOutputParameter "^\s*led3" contained
syn match algoquencerOutputParameter "^\s*led4" contained
syn match algoquencerOutputParameter "^\s*led5" contained
syn match algoquencerOutputParameter "^\s*led6" contained
syn match algoquencerOutputParameter "^\s*led7" contained
syn match algoquencerOutputParameter "^\s*led8" contained
syn match algoquencerOutputParameter "^\s*led9" contained
syn match algoquencerInputParameter "^\s*length" contained
syn match algoquencerInputParameter "^\s*lengthbutton" contained
syn match algoquencerOutputParameter "^\s*lengthoutput" contained
syn match algoquencerOutputParameter "^\s*lo" contained
syn match algoquencerInputParameter "^\s*loadpreset" contained
syn match algoquencerInputParameter "^\s*lp" contained
syn match algoquencerInputParameter "^\s*m" contained
syn match algoquencerInputParameter "^\s*mb" contained
syn match algoquencerOutputParameter "^\s*ml" contained
syn match algoquencerOutputParameter "^\s*mol" contained
syn match algoquencerOutputParameter "^\s*morphled" contained
syn match algoquencerInputParameter "^\s*morphs" contained
syn match algoquencerInputParameter "^\s*mutebutton" contained
syn match algoquencerOutputParameter "^\s*muteled" contained
syn match algoquencerInputParameter "^\s*nextpattern" contained
syn match algoquencerInputParameter "^\s*np" contained
syn match algoquencerInputParameter "^\s*ob" contained
syn match algoquencerInputParameter "^\s*offbeats" contained
syn match algoquencerOutputParameter "^\s*p" contained
syn match algoquencerInputParameter "^\s*p1" contained
syn match algoquencerInputParameter "^\s*p10" contained
syn match algoquencerInputParameter "^\s*p11" contained
syn match algoquencerInputParameter "^\s*p12" contained
syn match algoquencerInputParameter "^\s*p13" contained
syn match algoquencerInputParameter "^\s*p14" contained
syn match algoquencerInputParameter "^\s*p15" contained
syn match algoquencerInputParameter "^\s*p16" contained
syn match algoquencerInputParameter "^\s*p2" contained
syn match algoquencerInputParameter "^\s*p3" contained
syn match algoquencerInputParameter "^\s*p4" contained
syn match algoquencerInputParameter "^\s*p5" contained
syn match algoquencerInputParameter "^\s*p6" contained
syn match algoquencerInputParameter "^\s*p7" contained
syn match algoquencerInputParameter "^\s*p8" contained
syn match algoquencerInputParameter "^\s*p9" contained
syn match algoquencerInputParameter "^\s*pattern" contained
syn match algoquencerInputParameter "^\s*ph" contained
syn match algoquencerInputParameter "^\s*pitch" contained
syn match algoquencerOutputParameter "^\s*pitch" contained
syn match algoquencerInputParameter "^\s*pitch1" contained
syn match algoquencerInputParameter "^\s*pitch10" contained
syn match algoquencerInputParameter "^\s*pitch11" contained
syn match algoquencerInputParameter "^\s*pitch12" contained
syn match algoquencerInputParameter "^\s*pitch13" contained
syn match algoquencerInputParameter "^\s*pitch14" contained
syn match algoquencerInputParameter "^\s*pitch15" contained
syn match algoquencerInputParameter "^\s*pitch16" contained
syn match algoquencerInputParameter "^\s*pitch2" contained
syn match algoquencerInputParameter "^\s*pitch3" contained
syn match algoquencerInputParameter "^\s*pitch4" contained
syn match algoquencerInputParameter "^\s*pitch5" contained
syn match algoquencerInputParameter "^\s*pitch6" contained
syn match algoquencerInputParameter "^\s*pitch7" contained
syn match algoquencerInputParameter "^\s*pitch8" contained
syn match algoquencerInputParameter "^\s*pitch9" contained
syn match algoquencerInputParameter "^\s*pitchhigh" contained
syn match algoquencerInputParameter "^\s*pitchlow" contained
syn match algoquencerInputParameter "^\s*pitchresolution" contained
syn match algoquencerInputParameter "^\s*pl" contained
syn match algoquencerInputParameter "^\s*pp" contained
syn match algoquencerInputParameter "^\s*pr" contained
syn match algoquencerInputParameter "^\s*pre" contained
syn match algoquencerInputParameter "^\s*preset" contained
syn match algoquencerInputParameter "^\s*prevpattern" contained
syn match algoquencerInputParameter "^\s*pt" contained
syn match algoquencerInputParameter "^\s*r" contained
syn match algoquencerInputParameter "^\s*rc" contained
syn match algoquencerInputParameter "^\s*repeats" contained
syn match algoquencerInputParameter "^\s*reroll" contained
syn match algoquencerInputParameter "^\s*reset" contained
syn match algoquencerInputParameter "^\s*rl" contained
syn match algoquencerInputParameter "^\s*rollcount" contained
syn match algoquencerInputParameter "^\s*rolls" contained
syn match algoquencerInputParameter "^\s*rollstartvelo" contained
syn match algoquencerInputParameter "^\s*rollsteps" contained
syn match algoquencerOutputParameter "^\s*rollvelocity" contained
syn match algoquencerInputParameter "^\s*rp" contained
syn match algoquencerInputParameter "^\s*rr" contained
syn match algoquencerInputParameter "^\s*rs" contained
syn match algoquencerInputParameter "^\s*rsv" contained
syn match algoquencerOutputParameter "^\s*rv" contained
syn match algoquencerInputParameter "^\s*s" contained
syn match algoquencerInputParameter "^\s*sa" contained
syn match algoquencerInputParameter "^\s*savepreset" contained
syn match algoquencerOutputParameter "^\s*sb" contained
syn match algoquencerInputParameter "^\s*sc" contained
syn match algoquencerInputParameter "^\s*select" contained
syn match algoquencerInputParameter "^\s*selectat" contained
syn match algoquencerInputParameter "^\s*sp" contained
syn match algoquencerInputParameter "^\s*startaccents" contained
syn match algoquencerOutputParameter "^\s*startofbar" contained
syn match algoquencerOutputParameter "^\s*t" contained
syn match algoquencerOutputParameter "^\s*trigger" contained
syn match algoquencerInputParameter "^\s*ub" contained
syn match algoquencerOutputParameter "^\s*ul" contained
syn match algoquencerInputParameter "^\s*unmutebutton" contained
syn match algoquencerOutputParameter "^\s*unmuteled" contained
syn match algoquencerInputParameter "^\s*v" contained
syn match algoquencerInputParameter "^\s*variation" contained
syn match algoquencerHeader /\[algoquencer\]/ contained
syn region algoquencerCircuit start=/\[algoquencer\]/ end=/\[/me=s-1 transparent contains=algoquencerHeader,algoquencerInputParameter,algoquencerOutputParameter,ioregister,number,cable,quotestring,comment
hi def link algoquencerHeader circuitHeader
hi def link algoquencerInputParameter inputParameter
hi def link algoquencerOutputParameter outputParameter


" arpeggio
syn match arpeggioInputParameter "^\s*ar" contained
syn match arpeggioInputParameter "^\s*autoreset" contained
syn match arpeggioInputParameter "^\s*butterfly" contained
syn match arpeggioInputParameter "^\s*by" contained
syn match arpeggioInputParameter "^\s*c" contained
syn match arpeggioInputParameter "^\s*clock" contained
syn match arpeggioInputParameter "^\s*d" contained
syn match arpeggioInputParameter "^\s*degree" contained
syn match arpeggioInputParameter "^\s*dg" contained
syn match arpeggioInputParameter "^\s*direction" contained
syn match arpeggioInputParameter "^\s*dr" contained
syn match arpeggioInputParameter "^\s*drop" contained
syn match arpeggioInputParameter "^\s*harmonicshift" contained
syn match arpeggioInputParameter "^\s*has" contained
syn match arpeggioInputParameter "^\s*nos" contained
syn match arpeggioInputParameter "^\s*noteshift" contained
syn match arpeggioOutputParameter "^\s*o" contained
syn match arpeggioInputParameter "^\s*oc" contained
syn match arpeggioInputParameter "^\s*octaves" contained
syn match arpeggioOutputParameter "^\s*output" contained
syn match arpeggioInputParameter "^\s*p" contained
syn match arpeggioInputParameter "^\s*pattern" contained
syn match arpeggioInputParameter "^\s*pingpong" contained
syn match arpeggioInputParameter "^\s*pitch" contained
syn match arpeggioInputParameter "^\s*pp" contained
syn match arpeggioInputParameter "^\s*pt" contained
syn match arpeggioInputParameter "^\s*r" contained
syn match arpeggioInputParameter "^\s*ra" contained
syn match arpeggioInputParameter "^\s*range" contained
syn match arpeggioInputParameter "^\s*reset" contained
syn match arpeggioInputParameter "^\s*ro" contained
syn match arpeggioInputParameter "^\s*root" contained
syn match arpeggioInputParameter "^\s*s1" contained
syn match arpeggioInputParameter "^\s*s11" contained
syn match arpeggioInputParameter "^\s*s13" contained
syn match arpeggioInputParameter "^\s*s3" contained
syn match arpeggioInputParameter "^\s*s5" contained
syn match arpeggioInputParameter "^\s*s7" contained
syn match arpeggioInputParameter "^\s*s9" contained
syn match arpeggioInputParameter "^\s*select1" contained
syn match arpeggioInputParameter "^\s*select11" contained
syn match arpeggioInputParameter "^\s*select13" contained
syn match arpeggioInputParameter "^\s*select3" contained
syn match arpeggioInputParameter "^\s*select5" contained
syn match arpeggioInputParameter "^\s*select7" contained
syn match arpeggioInputParameter "^\s*select9" contained
syn match arpeggioInputParameter "^\s*selectfill1" contained
syn match arpeggioInputParameter "^\s*selectfill2" contained
syn match arpeggioInputParameter "^\s*selectfill3" contained
syn match arpeggioInputParameter "^\s*selectfill4" contained
syn match arpeggioInputParameter "^\s*selectfill5" contained
syn match arpeggioInputParameter "^\s*selectnoteshift" contained
syn match arpeggioInputParameter "^\s*sf1" contained
syn match arpeggioInputParameter "^\s*sf2" contained
syn match arpeggioInputParameter "^\s*sf3" contained
syn match arpeggioInputParameter "^\s*sf4" contained
syn match arpeggioInputParameter "^\s*sf5" contained
syn match arpeggioInputParameter "^\s*sn" contained
syn match arpeggioInputParameter "^\s*sns" contained
syn match arpeggioInputParameter "^\s*startnote" contained
syn match arpeggioInputParameter "^\s*tm" contained
syn match arpeggioInputParameter "^\s*tp" contained
syn match arpeggioInputParameter "^\s*tr" contained
syn match arpeggioInputParameter "^\s*transpose" contained
syn match arpeggioInputParameter "^\s*tuningmode" contained
syn match arpeggioInputParameter "^\s*tuningpitch" contained
syn match arpeggioHeader /\[arpeggio\]/ contained
syn region arpeggioCircuit start=/\[arpeggio\]/ end=/\[/me=s-1 transparent contains=arpeggioHeader,arpeggioInputParameter,arpeggioOutputParameter,ioregister,number,cable,quotestring,comment
hi def link arpeggioHeader circuitHeader
hi def link arpeggioInputParameter inputParameter
hi def link arpeggioOutputParameter outputParameter


" bernoulli
syn match bernoulliInputParameter "^\s*di" contained
syn match bernoulliInputParameter "^\s*distribution" contained
syn match bernoulliInputParameter "^\s*i" contained
syn match bernoulliInputParameter "^\s*input" contained
syn match bernoulliOutputParameter "^\s*o1" contained
syn match bernoulliOutputParameter "^\s*o2" contained
syn match bernoulliOutputParameter "^\s*output1" contained
syn match bernoulliOutputParameter "^\s*output2" contained
syn match bernoulliHeader /\[bernoulli\]/ contained
syn region bernoulliCircuit start=/\[bernoulli\]/ end=/\[/me=s-1 transparent contains=bernoulliHeader,bernoulliInputParameter,bernoulliOutputParameter,ioregister,number,cable,quotestring,comment
hi def link bernoulliHeader circuitHeader
hi def link bernoulliInputParameter inputParameter
hi def link bernoulliOutputParameter outputParameter


" burst
syn match burstInputParameter "^\s*c" contained
syn match burstInputParameter "^\s*count" contained
syn match burstInputParameter "^\s*hz" contained
syn match burstOutputParameter "^\s*o" contained
syn match burstOutputParameter "^\s*output" contained
syn match burstInputParameter "^\s*r" contained
syn match burstInputParameter "^\s*ra" contained
syn match burstInputParameter "^\s*rate" contained
syn match burstInputParameter "^\s*reset" contained
syn match burstInputParameter "^\s*s" contained
syn match burstInputParameter "^\s*skip" contained
syn match burstInputParameter "^\s*t" contained
syn match burstInputParameter "^\s*taptempo" contained
syn match burstInputParameter "^\s*trigger" contained
syn match burstInputParameter "^\s*tt" contained
syn match burstHeader /\[burst\]/ contained
syn region burstCircuit start=/\[burst\]/ end=/\[/me=s-1 transparent contains=burstHeader,burstInputParameter,burstOutputParameter,ioregister,number,cable,quotestring,comment
hi def link burstHeader circuitHeader
hi def link burstInputParameter inputParameter
hi def link burstOutputParameter outputParameter


" button
syn match buttonInputParameter "^\s*b" contained
syn match buttonInputParameter "^\s*button" contained
syn match buttonInputParameter "^\s*ca" contained
syn match buttonInputParameter "^\s*cl" contained
syn match buttonInputParameter "^\s*clear" contained
syn match buttonInputParameter "^\s*clearall" contained
syn match buttonInputParameter "^\s*display" contained
syn match buttonInputParameter "^\s*dm" contained
syn match buttonInputParameter "^\s*dontsave" contained
syn match buttonInputParameter "^\s*dos" contained
syn match buttonInputParameter "^\s*doubleclickmode" contained
syn match buttonInputParameter "^\s*dy" contained
syn match buttonInputParameter "^\s*fv" contained
syn match buttonInputParameter "^\s*header" contained
syn match buttonInputParameter "^\s*hr" contained
syn match buttonOutputParameter "^\s*inverted" contained
syn match buttonOutputParameter "^\s*iv" contained
syn match buttonOutputParameter "^\s*l" contained
syn match buttonOutputParameter "^\s*led" contained
syn match buttonInputParameter "^\s*loadpreset" contained
syn match buttonOutputParameter "^\s*longpress" contained
syn match buttonInputParameter "^\s*longpresstime" contained
syn match buttonOutputParameter "^\s*lop" contained
syn match buttonInputParameter "^\s*lp" contained
syn match buttonInputParameter "^\s*lt" contained
syn match buttonOutputParameter "^\s*n" contained
syn match buttonOutputParameter "^\s*negated" contained
syn match buttonOutputParameter "^\s*o" contained
syn match buttonInputParameter "^\s*offvalue" contained
syn match buttonInputParameter "^\s*onvalue" contained
syn match buttonOutputParameter "^\s*output" contained
syn match buttonInputParameter "^\s*ov" contained
syn match buttonInputParameter "^\s*pr" contained
syn match buttonInputParameter "^\s*preset" contained
syn match buttonInputParameter "^\s*s" contained
syn match buttonInputParameter "^\s*sa" contained
syn match buttonInputParameter "^\s*savepreset" contained
syn match buttonInputParameter "^\s*select" contained
syn match buttonInputParameter "^\s*selectat" contained
syn match buttonOutputParameter "^\s*shortpress" contained
syn match buttonOutputParameter "^\s*shp" contained
syn match buttonInputParameter "^\s*sp" contained
syn match buttonInputParameter "^\s*st" contained
syn match buttonInputParameter "^\s*startvalue" contained
syn match buttonInputParameter "^\s*states" contained
syn match buttonInputParameter "^\s*sv" contained
syn match buttonInputParameter "^\s*v1" contained
syn match buttonInputParameter "^\s*v2" contained
syn match buttonInputParameter "^\s*v3" contained
syn match buttonInputParameter "^\s*v4" contained
syn match buttonInputParameter "^\s*value" contained
syn match buttonInputParameter "^\s*value1" contained
syn match buttonInputParameter "^\s*value2" contained
syn match buttonInputParameter "^\s*value3" contained
syn match buttonInputParameter "^\s*value4" contained
syn match buttonHeader /\[button\]/ contained
syn region buttonCircuit start=/\[button\]/ end=/\[/me=s-1 transparent contains=buttonHeader,buttonInputParameter,buttonOutputParameter,ioregister,number,cable,quotestring,comment
hi def link buttonHeader circuitHeader
hi def link buttonInputParameter inputParameter
hi def link buttonOutputParameter outputParameter


" buttongroup
syn match buttongroupInputParameter "^\s*b1" contained
syn match buttongroupInputParameter "^\s*b10" contained
syn match buttongroupInputParameter "^\s*b11" contained
syn match buttongroupInputParameter "^\s*b12" contained
syn match buttongroupInputParameter "^\s*b13" contained
syn match buttongroupInputParameter "^\s*b14" contained
syn match buttongroupInputParameter "^\s*b15" contained
syn match buttongroupInputParameter "^\s*b16" contained
syn match buttongroupInputParameter "^\s*b17" contained
syn match buttongroupInputParameter "^\s*b18" contained
syn match buttongroupInputParameter "^\s*b19" contained
syn match buttongroupInputParameter "^\s*b2" contained
syn match buttongroupInputParameter "^\s*b20" contained
syn match buttongroupInputParameter "^\s*b21" contained
syn match buttongroupInputParameter "^\s*b22" contained
syn match buttongroupInputParameter "^\s*b23" contained
syn match buttongroupInputParameter "^\s*b24" contained
syn match buttongroupInputParameter "^\s*b25" contained
syn match buttongroupInputParameter "^\s*b26" contained
syn match buttongroupInputParameter "^\s*b27" contained
syn match buttongroupInputParameter "^\s*b28" contained
syn match buttongroupInputParameter "^\s*b29" contained
syn match buttongroupInputParameter "^\s*b3" contained
syn match buttongroupInputParameter "^\s*b30" contained
syn match buttongroupInputParameter "^\s*b31" contained
syn match buttongroupInputParameter "^\s*b32" contained
syn match buttongroupInputParameter "^\s*b4" contained
syn match buttongroupInputParameter "^\s*b5" contained
syn match buttongroupInputParameter "^\s*b6" contained
syn match buttongroupInputParameter "^\s*b7" contained
syn match buttongroupInputParameter "^\s*b8" contained
syn match buttongroupInputParameter "^\s*b9" contained
syn match buttongroupOutputParameter "^\s*bo1" contained
syn match buttongroupOutputParameter "^\s*bo10" contained
syn match buttongroupOutputParameter "^\s*bo11" contained
syn match buttongroupOutputParameter "^\s*bo12" contained
syn match buttongroupOutputParameter "^\s*bo13" contained
syn match buttongroupOutputParameter "^\s*bo14" contained
syn match buttongroupOutputParameter "^\s*bo15" contained
syn match buttongroupOutputParameter "^\s*bo16" contained
syn match buttongroupOutputParameter "^\s*bo17" contained
syn match buttongroupOutputParameter "^\s*bo18" contained
syn match buttongroupOutputParameter "^\s*bo19" contained
syn match buttongroupOutputParameter "^\s*bo2" contained
syn match buttongroupOutputParameter "^\s*bo20" contained
syn match buttongroupOutputParameter "^\s*bo21" contained
syn match buttongroupOutputParameter "^\s*bo22" contained
syn match buttongroupOutputParameter "^\s*bo23" contained
syn match buttongroupOutputParameter "^\s*bo24" contained
syn match buttongroupOutputParameter "^\s*bo25" contained
syn match buttongroupOutputParameter "^\s*bo26" contained
syn match buttongroupOutputParameter "^\s*bo27" contained
syn match buttongroupOutputParameter "^\s*bo28" contained
syn match buttongroupOutputParameter "^\s*bo29" contained
syn match buttongroupOutputParameter "^\s*bo3" contained
syn match buttongroupOutputParameter "^\s*bo30" contained
syn match buttongroupOutputParameter "^\s*bo31" contained
syn match buttongroupOutputParameter "^\s*bo32" contained
syn match buttongroupOutputParameter "^\s*bo4" contained
syn match buttongroupOutputParameter "^\s*bo5" contained
syn match buttongroupOutputParameter "^\s*bo6" contained
syn match buttongroupOutputParameter "^\s*bo7" contained
syn match buttongroupOutputParameter "^\s*bo8" contained
syn match buttongroupOutputParameter "^\s*bo9" contained
syn match buttongroupOutputParameter "^\s*bp" contained
syn match buttongroupInputParameter "^\s*button" contained
syn match buttongroupInputParameter "^\s*button1" contained
syn match buttongroupInputParameter "^\s*button10" contained
syn match buttongroupInputParameter "^\s*button11" contained
syn match buttongroupInputParameter "^\s*button12" contained
syn match buttongroupInputParameter "^\s*button13" contained
syn match buttongroupInputParameter "^\s*button14" contained
syn match buttongroupInputParameter "^\s*button15" contained
syn match buttongroupInputParameter "^\s*button16" contained
syn match buttongroupInputParameter "^\s*button17" contained
syn match buttongroupInputParameter "^\s*button18" contained
syn match buttongroupInputParameter "^\s*button19" contained
syn match buttongroupInputParameter "^\s*button2" contained
syn match buttongroupInputParameter "^\s*button20" contained
syn match buttongroupInputParameter "^\s*button21" contained
syn match buttongroupInputParameter "^\s*button22" contained
syn match buttongroupInputParameter "^\s*button23" contained
syn match buttongroupInputParameter "^\s*button24" contained
syn match buttongroupInputParameter "^\s*button25" contained
syn match buttongroupInputParameter "^\s*button26" contained
syn match buttongroupInputParameter "^\s*button27" contained
syn match buttongroupInputParameter "^\s*button28" contained
syn match buttongroupInputParameter "^\s*button29" contained
syn match buttongroupInputParameter "^\s*button3" contained
syn match buttongroupInputParameter "^\s*button30" contained
syn match buttongroupInputParameter "^\s*button31" contained
syn match buttongroupInputParameter "^\s*button32" contained
syn match buttongroupInputParameter "^\s*button4" contained
syn match buttongroupInputParameter "^\s*button5" contained
syn match buttongroupInputParameter "^\s*button6" contained
syn match buttongroupInputParameter "^\s*button7" contained
syn match buttongroupInputParameter "^\s*button8" contained
syn match buttongroupInputParameter "^\s*button9" contained
syn match buttongroupOutputParameter "^\s*buttonoutput" contained
syn match buttongroupOutputParameter "^\s*buttonoutput1" contained
syn match buttongroupOutputParameter "^\s*buttonoutput10" contained
syn match buttongroupOutputParameter "^\s*buttonoutput11" contained
syn match buttongroupOutputParameter "^\s*buttonoutput12" contained
syn match buttongroupOutputParameter "^\s*buttonoutput13" contained
syn match buttongroupOutputParameter "^\s*buttonoutput14" contained
syn match buttongroupOutputParameter "^\s*buttonoutput15" contained
syn match buttongroupOutputParameter "^\s*buttonoutput16" contained
syn match buttongroupOutputParameter "^\s*buttonoutput17" contained
syn match buttongroupOutputParameter "^\s*buttonoutput18" contained
syn match buttongroupOutputParameter "^\s*buttonoutput19" contained
syn match buttongroupOutputParameter "^\s*buttonoutput2" contained
syn match buttongroupOutputParameter "^\s*buttonoutput20" contained
syn match buttongroupOutputParameter "^\s*buttonoutput21" contained
syn match buttongroupOutputParameter "^\s*buttonoutput22" contained
syn match buttongroupOutputParameter "^\s*buttonoutput23" contained
syn match buttongroupOutputParameter "^\s*buttonoutput24" contained
syn match buttongroupOutputParameter "^\s*buttonoutput25" contained
syn match buttongroupOutputParameter "^\s*buttonoutput26" contained
syn match buttongroupOutputParameter "^\s*buttonoutput27" contained
syn match buttongroupOutputParameter "^\s*buttonoutput28" contained
syn match buttongroupOutputParameter "^\s*buttonoutput29" contained
syn match buttongroupOutputParameter "^\s*buttonoutput3" contained
syn match buttongroupOutputParameter "^\s*buttonoutput30" contained
syn match buttongroupOutputParameter "^\s*buttonoutput31" contained
syn match buttongroupOutputParameter "^\s*buttonoutput32" contained
syn match buttongroupOutputParameter "^\s*buttonoutput4" contained
syn match buttongroupOutputParameter "^\s*buttonoutput5" contained
syn match buttongroupOutputParameter "^\s*buttonoutput6" contained
syn match buttongroupOutputParameter "^\s*buttonoutput7" contained
syn match buttongroupOutputParameter "^\s*buttonoutput8" contained
syn match buttongroupOutputParameter "^\s*buttonoutput9" contained
syn match buttongroupOutputParameter "^\s*buttonpress" contained
syn match buttongroupInputParameter "^\s*ca" contained
syn match buttongroupInputParameter "^\s*cl" contained
syn match buttongroupInputParameter "^\s*clear" contained
syn match buttongroupInputParameter "^\s*clearall" contained
syn match buttongroupInputParameter "^\s*display" contained
syn match buttongroupInputParameter "^\s*dontsave" contained
syn match buttongroupInputParameter "^\s*dos" contained
syn match buttongroupInputParameter "^\s*dy" contained
syn match buttongroupOutputParameter "^\s*ep" contained
syn match buttongroupOutputParameter "^\s*extrapress" contained
syn match buttongroupInputParameter "^\s*header" contained
syn match buttongroupInputParameter "^\s*hr" contained
syn match buttongroupOutputParameter "^\s*l1" contained
syn match buttongroupOutputParameter "^\s*l10" contained
syn match buttongroupOutputParameter "^\s*l11" contained
syn match buttongroupOutputParameter "^\s*l12" contained
syn match buttongroupOutputParameter "^\s*l13" contained
syn match buttongroupOutputParameter "^\s*l14" contained
syn match buttongroupOutputParameter "^\s*l15" contained
syn match buttongroupOutputParameter "^\s*l16" contained
syn match buttongroupOutputParameter "^\s*l17" contained
syn match buttongroupOutputParameter "^\s*l18" contained
syn match buttongroupOutputParameter "^\s*l19" contained
syn match buttongroupOutputParameter "^\s*l2" contained
syn match buttongroupOutputParameter "^\s*l20" contained
syn match buttongroupOutputParameter "^\s*l21" contained
syn match buttongroupOutputParameter "^\s*l22" contained
syn match buttongroupOutputParameter "^\s*l23" contained
syn match buttongroupOutputParameter "^\s*l24" contained
syn match buttongroupOutputParameter "^\s*l25" contained
syn match buttongroupOutputParameter "^\s*l26" contained
syn match buttongroupOutputParameter "^\s*l27" contained
syn match buttongroupOutputParameter "^\s*l28" contained
syn match buttongroupOutputParameter "^\s*l29" contained
syn match buttongroupOutputParameter "^\s*l3" contained
syn match buttongroupOutputParameter "^\s*l30" contained
syn match buttongroupOutputParameter "^\s*l31" contained
syn match buttongroupOutputParameter "^\s*l32" contained
syn match buttongroupOutputParameter "^\s*l4" contained
syn match buttongroupOutputParameter "^\s*l5" contained
syn match buttongroupOutputParameter "^\s*l6" contained
syn match buttongroupOutputParameter "^\s*l7" contained
syn match buttongroupOutputParameter "^\s*l8" contained
syn match buttongroupOutputParameter "^\s*l9" contained
syn match buttongroupOutputParameter "^\s*led" contained
syn match buttongroupOutputParameter "^\s*led1" contained
syn match buttongroupOutputParameter "^\s*led10" contained
syn match buttongroupOutputParameter "^\s*led11" contained
syn match buttongroupOutputParameter "^\s*led12" contained
syn match buttongroupOutputParameter "^\s*led13" contained
syn match buttongroupOutputParameter "^\s*led14" contained
syn match buttongroupOutputParameter "^\s*led15" contained
syn match buttongroupOutputParameter "^\s*led16" contained
syn match buttongroupOutputParameter "^\s*led17" contained
syn match buttongroupOutputParameter "^\s*led18" contained
syn match buttongroupOutputParameter "^\s*led19" contained
syn match buttongroupOutputParameter "^\s*led2" contained
syn match buttongroupOutputParameter "^\s*led20" contained
syn match buttongroupOutputParameter "^\s*led21" contained
syn match buttongroupOutputParameter "^\s*led22" contained
syn match buttongroupOutputParameter "^\s*led23" contained
syn match buttongroupOutputParameter "^\s*led24" contained
syn match buttongroupOutputParameter "^\s*led25" contained
syn match buttongroupOutputParameter "^\s*led26" contained
syn match buttongroupOutputParameter "^\s*led27" contained
syn match buttongroupOutputParameter "^\s*led28" contained
syn match buttongroupOutputParameter "^\s*led29" contained
syn match buttongroupOutputParameter "^\s*led3" contained
syn match buttongroupOutputParameter "^\s*led30" contained
syn match buttongroupOutputParameter "^\s*led31" contained
syn match buttongroupOutputParameter "^\s*led32" contained
syn match buttongroupOutputParameter "^\s*led4" contained
syn match buttongroupOutputParameter "^\s*led5" contained
syn match buttongroupOutputParameter "^\s*led6" contained
syn match buttongroupOutputParameter "^\s*led7" contained
syn match buttongroupOutputParameter "^\s*led8" contained
syn match buttongroupOutputParameter "^\s*led9" contained
syn match buttongroupInputParameter "^\s*loadpreset" contained
syn match buttongroupOutputParameter "^\s*longpress" contained
syn match buttongroupInputParameter "^\s*longpresstime" contained
syn match buttongroupOutputParameter "^\s*lop" contained
syn match buttongroupInputParameter "^\s*lp" contained
syn match buttongroupInputParameter "^\s*lt" contained
syn match buttongroupInputParameter "^\s*ma" contained
syn match buttongroupInputParameter "^\s*maxactive" contained
syn match buttongroupInputParameter "^\s*minactive" contained
syn match buttongroupOutputParameter "^\s*o" contained
syn match buttongroupOutputParameter "^\s*output" contained
syn match buttongroupInputParameter "^\s*pr" contained
syn match buttongroupInputParameter "^\s*preset" contained
syn match buttongroupInputParameter "^\s*s" contained
syn match buttongroupInputParameter "^\s*sa" contained
syn match buttongroupInputParameter "^\s*savepreset" contained
syn match buttongroupInputParameter "^\s*sb" contained
syn match buttongroupOutputParameter "^\s*sc" contained
syn match buttongroupInputParameter "^\s*select" contained
syn match buttongroupInputParameter "^\s*selectat" contained
syn match buttongroupOutputParameter "^\s*selectionchanged" contained
syn match buttongroupInputParameter "^\s*sp" contained
syn match buttongroupInputParameter "^\s*startbutton" contained
syn match buttongroupInputParameter "^\s*v1" contained
syn match buttongroupInputParameter "^\s*v10" contained
syn match buttongroupInputParameter "^\s*v11" contained
syn match buttongroupInputParameter "^\s*v12" contained
syn match buttongroupInputParameter "^\s*v13" contained
syn match buttongroupInputParameter "^\s*v14" contained
syn match buttongroupInputParameter "^\s*v15" contained
syn match buttongroupInputParameter "^\s*v16" contained
syn match buttongroupInputParameter "^\s*v17" contained
syn match buttongroupInputParameter "^\s*v18" contained
syn match buttongroupInputParameter "^\s*v19" contained
syn match buttongroupInputParameter "^\s*v2" contained
syn match buttongroupInputParameter "^\s*v20" contained
syn match buttongroupInputParameter "^\s*v21" contained
syn match buttongroupInputParameter "^\s*v22" contained
syn match buttongroupInputParameter "^\s*v23" contained
syn match buttongroupInputParameter "^\s*v24" contained
syn match buttongroupInputParameter "^\s*v25" contained
syn match buttongroupInputParameter "^\s*v26" contained
syn match buttongroupInputParameter "^\s*v27" contained
syn match buttongroupInputParameter "^\s*v28" contained
syn match buttongroupInputParameter "^\s*v29" contained
syn match buttongroupInputParameter "^\s*v3" contained
syn match buttongroupInputParameter "^\s*v30" contained
syn match buttongroupInputParameter "^\s*v31" contained
syn match buttongroupInputParameter "^\s*v32" contained
syn match buttongroupInputParameter "^\s*v4" contained
syn match buttongroupInputParameter "^\s*v5" contained
syn match buttongroupInputParameter "^\s*v6" contained
syn match buttongroupInputParameter "^\s*v7" contained
syn match buttongroupInputParameter "^\s*v8" contained
syn match buttongroupInputParameter "^\s*v9" contained
syn match buttongroupInputParameter "^\s*value" contained
syn match buttongroupInputParameter "^\s*value1" contained
syn match buttongroupInputParameter "^\s*value10" contained
syn match buttongroupInputParameter "^\s*value11" contained
syn match buttongroupInputParameter "^\s*value12" contained
syn match buttongroupInputParameter "^\s*value13" contained
syn match buttongroupInputParameter "^\s*value14" contained
syn match buttongroupInputParameter "^\s*value15" contained
syn match buttongroupInputParameter "^\s*value16" contained
syn match buttongroupInputParameter "^\s*value17" contained
syn match buttongroupInputParameter "^\s*value18" contained
syn match buttongroupInputParameter "^\s*value19" contained
syn match buttongroupInputParameter "^\s*value2" contained
syn match buttongroupInputParameter "^\s*value20" contained
syn match buttongroupInputParameter "^\s*value21" contained
syn match buttongroupInputParameter "^\s*value22" contained
syn match buttongroupInputParameter "^\s*value23" contained
syn match buttongroupInputParameter "^\s*value24" contained
syn match buttongroupInputParameter "^\s*value25" contained
syn match buttongroupInputParameter "^\s*value26" contained
syn match buttongroupInputParameter "^\s*value27" contained
syn match buttongroupInputParameter "^\s*value28" contained
syn match buttongroupInputParameter "^\s*value29" contained
syn match buttongroupInputParameter "^\s*value3" contained
syn match buttongroupInputParameter "^\s*value30" contained
syn match buttongroupInputParameter "^\s*value31" contained
syn match buttongroupInputParameter "^\s*value32" contained
syn match buttongroupInputParameter "^\s*value4" contained
syn match buttongroupInputParameter "^\s*value5" contained
syn match buttongroupInputParameter "^\s*value6" contained
syn match buttongroupInputParameter "^\s*value7" contained
syn match buttongroupInputParameter "^\s*value8" contained
syn match buttongroupInputParameter "^\s*value9" contained
syn match buttongroupInputParameter "^\s*xa" contained
syn match buttongroupHeader /\[buttongroup\]/ contained
syn region buttongroupCircuit start=/\[buttongroup\]/ end=/\[/me=s-1 transparent contains=buttongroupHeader,buttongroupInputParameter,buttongroupOutputParameter,ioregister,number,cable,quotestring,comment
hi def link buttongroupHeader circuitHeader
hi def link buttongroupInputParameter inputParameter
hi def link buttongroupOutputParameter outputParameter


" calibrator
syn match calibratorOutputParameter "^\s*c" contained
syn match calibratorInputParameter "^\s*ca" contained
syn match calibratorInputParameter "^\s*ch" contained
syn match calibratorInputParameter "^\s*cl" contained
syn match calibratorInputParameter "^\s*clear" contained
syn match calibratorInputParameter "^\s*clearall" contained
syn match calibratorInputParameter "^\s*clearhere" contained
syn match calibratorOutputParameter "^\s*correction" contained
syn match calibratorInputParameter "^\s*display" contained
syn match calibratorInputParameter "^\s*dontsave" contained
syn match calibratorInputParameter "^\s*dos" contained
syn match calibratorInputParameter "^\s*dy" contained
syn match calibratorInputParameter "^\s*fd" contained
syn match calibratorInputParameter "^\s*forcedisplay" contained
syn match calibratorInputParameter "^\s*header" contained
syn match calibratorInputParameter "^\s*hr" contained
syn match calibratorInputParameter "^\s*i" contained
syn match calibratorInputParameter "^\s*input" contained
syn match calibratorOutputParameter "^\s*ld" contained
syn match calibratorOutputParameter "^\s*leddown" contained
syn match calibratorOutputParameter "^\s*ledup" contained
syn match calibratorInputParameter "^\s*loadpreset" contained
syn match calibratorInputParameter "^\s*lp" contained
syn match calibratorOutputParameter "^\s*lu" contained
syn match calibratorInputParameter "^\s*na" contained
syn match calibratorInputParameter "^\s*nd" contained
syn match calibratorInputParameter "^\s*nu" contained
syn match calibratorInputParameter "^\s*nudgeamount" contained
syn match calibratorInputParameter "^\s*nudgedown" contained
syn match calibratorInputParameter "^\s*nudgeup" contained
syn match calibratorOutputParameter "^\s*o" contained
syn match calibratorOutputParameter "^\s*output" contained
syn match calibratorInputParameter "^\s*pr" contained
syn match calibratorInputParameter "^\s*preset" contained
syn match calibratorInputParameter "^\s*s" contained
syn match calibratorInputParameter "^\s*sa" contained
syn match calibratorInputParameter "^\s*savepreset" contained
syn match calibratorInputParameter "^\s*select" contained
syn match calibratorInputParameter "^\s*selectat" contained
syn match calibratorInputParameter "^\s*sp" contained
syn match calibratorInputParameter "^\s*t0" contained
syn match calibratorInputParameter "^\s*t1" contained
syn match calibratorInputParameter "^\s*t2" contained
syn match calibratorInputParameter "^\s*t3" contained
syn match calibratorInputParameter "^\s*t4" contained
syn match calibratorInputParameter "^\s*t5" contained
syn match calibratorInputParameter "^\s*t6" contained
syn match calibratorInputParameter "^\s*t7" contained
syn match calibratorInputParameter "^\s*t8" contained
syn match calibratorInputParameter "^\s*t9" contained
syn match calibratorInputParameter "^\s*th" contained
syn match calibratorInputParameter "^\s*tl" contained
syn match calibratorInputParameter "^\s*tune" contained
syn match calibratorInputParameter "^\s*tune0" contained
syn match calibratorInputParameter "^\s*tune1" contained
syn match calibratorInputParameter "^\s*tune2" contained
syn match calibratorInputParameter "^\s*tune3" contained
syn match calibratorInputParameter "^\s*tune4" contained
syn match calibratorInputParameter "^\s*tune5" contained
syn match calibratorInputParameter "^\s*tune6" contained
syn match calibratorInputParameter "^\s*tune7" contained
syn match calibratorInputParameter "^\s*tune8" contained
syn match calibratorInputParameter "^\s*tune9" contained
syn match calibratorInputParameter "^\s*tunehightail" contained
syn match calibratorInputParameter "^\s*tunelowtail" contained
syn match calibratorHeader /\[calibrator\]/ contained
syn region calibratorCircuit start=/\[calibrator\]/ end=/\[/me=s-1 transparent contains=calibratorHeader,calibratorInputParameter,calibratorOutputParameter,ioregister,number,cable,quotestring,comment
hi def link calibratorHeader circuitHeader
hi def link calibratorInputParameter inputParameter
hi def link calibratorOutputParameter outputParameter


" case
syn match caseInputParameter "^\s*c1" contained
syn match caseInputParameter "^\s*c10" contained
syn match caseInputParameter "^\s*c11" contained
syn match caseInputParameter "^\s*c12" contained
syn match caseInputParameter "^\s*c13" contained
syn match caseInputParameter "^\s*c14" contained
syn match caseInputParameter "^\s*c15" contained
syn match caseInputParameter "^\s*c16" contained
syn match caseInputParameter "^\s*c2" contained
syn match caseInputParameter "^\s*c3" contained
syn match caseInputParameter "^\s*c4" contained
syn match caseInputParameter "^\s*c5" contained
syn match caseInputParameter "^\s*c6" contained
syn match caseInputParameter "^\s*c7" contained
syn match caseInputParameter "^\s*c8" contained
syn match caseInputParameter "^\s*c9" contained
syn match caseInputParameter "^\s*case" contained
syn match caseInputParameter "^\s*case1" contained
syn match caseInputParameter "^\s*case10" contained
syn match caseInputParameter "^\s*case11" contained
syn match caseInputParameter "^\s*case12" contained
syn match caseInputParameter "^\s*case13" contained
syn match caseInputParameter "^\s*case14" contained
syn match caseInputParameter "^\s*case15" contained
syn match caseInputParameter "^\s*case16" contained
syn match caseInputParameter "^\s*case2" contained
syn match caseInputParameter "^\s*case3" contained
syn match caseInputParameter "^\s*case4" contained
syn match caseInputParameter "^\s*case5" contained
syn match caseInputParameter "^\s*case6" contained
syn match caseInputParameter "^\s*case7" contained
syn match caseInputParameter "^\s*case8" contained
syn match caseInputParameter "^\s*case9" contained
syn match caseInputParameter "^\s*e" contained
syn match caseInputParameter "^\s*else" contained
syn match caseOutputParameter "^\s*o" contained
syn match caseOutputParameter "^\s*output" contained
syn match caseInputParameter "^\s*v1" contained
syn match caseInputParameter "^\s*v10" contained
syn match caseInputParameter "^\s*v11" contained
syn match caseInputParameter "^\s*v12" contained
syn match caseInputParameter "^\s*v13" contained
syn match caseInputParameter "^\s*v14" contained
syn match caseInputParameter "^\s*v15" contained
syn match caseInputParameter "^\s*v16" contained
syn match caseInputParameter "^\s*v2" contained
syn match caseInputParameter "^\s*v3" contained
syn match caseInputParameter "^\s*v4" contained
syn match caseInputParameter "^\s*v5" contained
syn match caseInputParameter "^\s*v6" contained
syn match caseInputParameter "^\s*v7" contained
syn match caseInputParameter "^\s*v8" contained
syn match caseInputParameter "^\s*v9" contained
syn match caseInputParameter "^\s*value" contained
syn match caseInputParameter "^\s*value1" contained
syn match caseInputParameter "^\s*value10" contained
syn match caseInputParameter "^\s*value11" contained
syn match caseInputParameter "^\s*value12" contained
syn match caseInputParameter "^\s*value13" contained
syn match caseInputParameter "^\s*value14" contained
syn match caseInputParameter "^\s*value15" contained
syn match caseInputParameter "^\s*value16" contained
syn match caseInputParameter "^\s*value2" contained
syn match caseInputParameter "^\s*value3" contained
syn match caseInputParameter "^\s*value4" contained
syn match caseInputParameter "^\s*value5" contained
syn match caseInputParameter "^\s*value6" contained
syn match caseInputParameter "^\s*value7" contained
syn match caseInputParameter "^\s*value8" contained
syn match caseInputParameter "^\s*value9" contained
syn match caseHeader /\[case\]/ contained
syn region caseCircuit start=/\[case\]/ end=/\[/me=s-1 transparent contains=caseHeader,caseInputParameter,caseOutputParameter,ioregister,number,cable,quotestring,comment
hi def link caseHeader circuitHeader
hi def link caseInputParameter inputParameter
hi def link caseOutputParameter outputParameter


" chord
syn match chordInputParameter "^\s*degree" contained
syn match chordInputParameter "^\s*dg" contained
syn match chordInputParameter "^\s*harmonicshift" contained
syn match chordInputParameter "^\s*has" contained
syn match chordInputParameter "^\s*inversion" contained
syn match chordInputParameter "^\s*iv" contained
syn match chordInputParameter "^\s*nos" contained
syn match chordInputParameter "^\s*noteshift" contained
syn match chordOutputParameter "^\s*o1" contained
syn match chordOutputParameter "^\s*o2" contained
syn match chordOutputParameter "^\s*o3" contained
syn match chordOutputParameter "^\s*o4" contained
syn match chordOutputParameter "^\s*output" contained
syn match chordOutputParameter "^\s*output1" contained
syn match chordOutputParameter "^\s*output2" contained
syn match chordOutputParameter "^\s*output3" contained
syn match chordOutputParameter "^\s*output4" contained
syn match chordInputParameter "^\s*p" contained
syn match chordInputParameter "^\s*pitch" contained
syn match chordInputParameter "^\s*ro" contained
syn match chordInputParameter "^\s*root" contained
syn match chordInputParameter "^\s*s" contained
syn match chordInputParameter "^\s*s1" contained
syn match chordInputParameter "^\s*s11" contained
syn match chordInputParameter "^\s*s13" contained
syn match chordInputParameter "^\s*s3" contained
syn match chordInputParameter "^\s*s5" contained
syn match chordInputParameter "^\s*s7" contained
syn match chordInputParameter "^\s*s9" contained
syn match chordInputParameter "^\s*select1" contained
syn match chordInputParameter "^\s*select11" contained
syn match chordInputParameter "^\s*select13" contained
syn match chordInputParameter "^\s*select3" contained
syn match chordInputParameter "^\s*select5" contained
syn match chordInputParameter "^\s*select7" contained
syn match chordInputParameter "^\s*select9" contained
syn match chordInputParameter "^\s*selectfill1" contained
syn match chordInputParameter "^\s*selectfill2" contained
syn match chordInputParameter "^\s*selectfill3" contained
syn match chordInputParameter "^\s*selectfill4" contained
syn match chordInputParameter "^\s*selectfill5" contained
syn match chordInputParameter "^\s*selectnoteshift" contained
syn match chordInputParameter "^\s*sf1" contained
syn match chordInputParameter "^\s*sf2" contained
syn match chordInputParameter "^\s*sf3" contained
syn match chordInputParameter "^\s*sf4" contained
syn match chordInputParameter "^\s*sf5" contained
syn match chordInputParameter "^\s*sns" contained
syn match chordInputParameter "^\s*spread" contained
syn match chordInputParameter "^\s*t" contained
syn match chordInputParameter "^\s*tm" contained
syn match chordInputParameter "^\s*tp" contained
syn match chordInputParameter "^\s*tr" contained
syn match chordInputParameter "^\s*transpose" contained
syn match chordInputParameter "^\s*trigger" contained
syn match chordInputParameter "^\s*tuningmode" contained
syn match chordInputParameter "^\s*tuningpitch" contained
syn match chordHeader /\[chord\]/ contained
syn region chordCircuit start=/\[chord\]/ end=/\[/me=s-1 transparent contains=chordHeader,chordInputParameter,chordOutputParameter,ioregister,number,cable,quotestring,comment
hi def link chordHeader circuitHeader
hi def link chordInputParameter inputParameter
hi def link chordOutputParameter outputParameter


" clockedtrigger
syn match clockedtriggerInputParameter "^\s*c" contained
syn match clockedtriggerInputParameter "^\s*cl" contained
syn match clockedtriggerInputParameter "^\s*clear" contained
syn match clockedtriggerInputParameter "^\s*clock" contained
syn match clockedtriggerOutputParameter "^\s*clockedtrigger" contained
syn match clockedtriggerOutputParameter "^\s*clockedvalue" contained
syn match clockedtriggerOutputParameter "^\s*ct" contained
syn match clockedtriggerOutputParameter "^\s*cv" contained
syn match clockedtriggerOutputParameter "^\s*p" contained
syn match clockedtriggerOutputParameter "^\s*pendingtrigger" contained
syn match clockedtriggerOutputParameter "^\s*pendingvalue" contained
syn match clockedtriggerOutputParameter "^\s*pv" contained
syn match clockedtriggerInputParameter "^\s*t" contained
syn match clockedtriggerInputParameter "^\s*trigger" contained
syn match clockedtriggerInputParameter "^\s*v" contained
syn match clockedtriggerInputParameter "^\s*value" contained
syn match clockedtriggerHeader /\[clockedtrigger\]/ contained
syn region clockedtriggerCircuit start=/\[clockedtrigger\]/ end=/\[/me=s-1 transparent contains=clockedtriggerHeader,clockedtriggerInputParameter,clockedtriggerOutputParameter,ioregister,number,cable,quotestring,comment
hi def link clockedtriggerHeader circuitHeader
hi def link clockedtriggerInputParameter inputParameter
hi def link clockedtriggerOutputParameter outputParameter


" clocktool
syn match clocktoolInputParameter "^\s*c" contained
syn match clocktoolInputParameter "^\s*clock" contained
syn match clocktoolInputParameter "^\s*d" contained
syn match clocktoolInputParameter "^\s*dc" contained
syn match clocktoolInputParameter "^\s*delay" contained
syn match clocktoolInputParameter "^\s*divide" contained
syn match clocktoolInputParameter "^\s*dl" contained
syn match clocktoolInputParameter "^\s*dutycycle" contained
syn match clocktoolInputParameter "^\s*gatelength" contained
syn match clocktoolInputParameter "^\s*gl" contained
syn match clocktoolOutputParameter "^\s*inputpitch" contained
syn match clocktoolOutputParameter "^\s*ip" contained
syn match clocktoolInputParameter "^\s*m" contained
syn match clocktoolInputParameter "^\s*multiply" contained
syn match clocktoolOutputParameter "^\s*o" contained
syn match clocktoolOutputParameter "^\s*op" contained
syn match clocktoolOutputParameter "^\s*output" contained
syn match clocktoolOutputParameter "^\s*outputpitch" contained
syn match clocktoolInputParameter "^\s*r" contained
syn match clocktoolInputParameter "^\s*reset" contained
syn match clocktoolHeader /\[clocktool\]/ contained
syn region clocktoolCircuit start=/\[clocktool\]/ end=/\[/me=s-1 transparent contains=clocktoolHeader,clocktoolInputParameter,clocktoolOutputParameter,ioregister,number,cable,quotestring,comment
hi def link clocktoolHeader circuitHeader
hi def link clocktoolInputParameter inputParameter
hi def link clocktoolOutputParameter outputParameter


" compare
syn match compareInputParameter "^\s*c" contained
syn match compareInputParameter "^\s*compare" contained
syn match compareInputParameter "^\s*e" contained
syn match compareInputParameter "^\s*else" contained
syn match compareInputParameter "^\s*g" contained
syn match compareInputParameter "^\s*i" contained
syn match compareInputParameter "^\s*ifequal" contained
syn match compareInputParameter "^\s*ifgreater" contained
syn match compareInputParameter "^\s*ifless" contained
syn match compareInputParameter "^\s*input" contained
syn match compareInputParameter "^\s*l" contained
syn match compareOutputParameter "^\s*o" contained
syn match compareOutputParameter "^\s*output" contained
syn match compareInputParameter "^\s*pc" contained
syn match compareInputParameter "^\s*precision" contained
syn match compareInputParameter "^\s*q" contained
syn match compareHeader /\[compare\]/ contained
syn region compareCircuit start=/\[compare\]/ end=/\[/me=s-1 transparent contains=compareHeader,compareInputParameter,compareOutputParameter,ioregister,number,cable,quotestring,comment
hi def link compareHeader circuitHeader
hi def link compareInputParameter inputParameter
hi def link compareOutputParameter outputParameter


" contour
syn match contourInputParameter "^\s*a" contained
syn match contourInputParameter "^\s*aa" contained
syn match contourInputParameter "^\s*abortattack" contained
syn match contourInputParameter "^\s*as" contained
syn match contourInputParameter "^\s*attack" contained
syn match contourInputParameter "^\s*attackshape" contained
syn match contourInputParameter "^\s*d" contained
syn match contourInputParameter "^\s*decay" contained
syn match contourInputParameter "^\s*decayshape" contained
syn match contourInputParameter "^\s*ds" contained
syn match contourOutputParameter "^\s*ea" contained
syn match contourOutputParameter "^\s*ed" contained
syn match contourOutputParameter "^\s*eh" contained
syn match contourOutputParameter "^\s*endofattack" contained
syn match contourOutputParameter "^\s*endofdecay" contained
syn match contourOutputParameter "^\s*endofhold" contained
syn match contourOutputParameter "^\s*endofpredelay" contained
syn match contourOutputParameter "^\s*endofrelease" contained
syn match contourOutputParameter "^\s*ep" contained
syn match contourOutputParameter "^\s*er" contained
syn match contourInputParameter "^\s*g" contained
syn match contourInputParameter "^\s*gate" contained
syn match contourInputParameter "^\s*h" contained
syn match contourInputParameter "^\s*hold" contained
syn match contourOutputParameter "^\s*inverted" contained
syn match contourOutputParameter "^\s*iv" contained
syn match contourInputParameter "^\s*l" contained
syn match contourInputParameter "^\s*level" contained
syn match contourInputParameter "^\s*lo" contained
syn match contourInputParameter "^\s*loop" contained
syn match contourOutputParameter "^\s*n" contained
syn match contourOutputParameter "^\s*negated" contained
syn match contourOutputParameter "^\s*o" contained
syn match contourOutputParameter "^\s*output" contained
syn match contourInputParameter "^\s*p" contained
syn match contourInputParameter "^\s*pd" contained
syn match contourInputParameter "^\s*pitch" contained
syn match contourInputParameter "^\s*predelay" contained
syn match contourInputParameter "^\s*r" contained
syn match contourInputParameter "^\s*release" contained
syn match contourInputParameter "^\s*releaseshape" contained
syn match contourInputParameter "^\s*retrigger" contained
syn match contourInputParameter "^\s*rs" contained
syn match contourInputParameter "^\s*rt" contained
syn match contourInputParameter "^\s*s" contained
syn match contourInputParameter "^\s*sh" contained
syn match contourInputParameter "^\s*shape" contained
syn match contourInputParameter "^\s*sl" contained
syn match contourInputParameter "^\s*ss" contained
syn match contourInputParameter "^\s*st" contained
syn match contourInputParameter "^\s*startfromzero" contained
syn match contourInputParameter "^\s*sustain" contained
syn match contourInputParameter "^\s*sw" contained
syn match contourInputParameter "^\s*swell" contained
syn match contourInputParameter "^\s*swelllevel" contained
syn match contourInputParameter "^\s*swellshape" contained
syn match contourInputParameter "^\s*swelltime" contained
syn match contourInputParameter "^\s*sz" contained
syn match contourInputParameter "^\s*t" contained
syn match contourInputParameter "^\s*taptempo" contained
syn match contourInputParameter "^\s*trigger" contained
syn match contourInputParameter "^\s*tt" contained
syn match contourInputParameter "^\s*v" contained
syn match contourInputParameter "^\s*velocity" contained
syn match contourInputParameter "^\s*z" contained
syn match contourInputParameter "^\s*zerocrossing" contained
syn match contourHeader /\[contour\]/ contained
syn region contourCircuit start=/\[contour\]/ end=/\[/me=s-1 transparent contains=contourHeader,contourInputParameter,contourOutputParameter,ioregister,number,cable,quotestring,comment
hi def link contourHeader circuitHeader
hi def link contourInputParameter inputParameter
hi def link contourOutputParameter outputParameter


" copy
syn match copyInputParameter "^\s*i" contained
syn match copyInputParameter "^\s*input" contained
syn match copyOutputParameter "^\s*o" contained
syn match copyOutputParameter "^\s*output" contained
syn match copyHeader /\[copy\]/ contained
syn region copyCircuit start=/\[copy\]/ end=/\[/me=s-1 transparent contains=copyHeader,copyInputParameter,copyOutputParameter,ioregister,number,cable,quotestring,comment
hi def link copyHeader circuitHeader
hi def link copyInputParameter inputParameter
hi def link copyOutputParameter outputParameter


" crossfader
syn match crossfaderInputParameter "^\s*f" contained
syn match crossfaderInputParameter "^\s*fade" contained
syn match crossfaderInputParameter "^\s*i1" contained
syn match crossfaderInputParameter "^\s*i2" contained
syn match crossfaderInputParameter "^\s*i3" contained
syn match crossfaderInputParameter "^\s*i4" contained
syn match crossfaderInputParameter "^\s*i5" contained
syn match crossfaderInputParameter "^\s*i6" contained
syn match crossfaderInputParameter "^\s*i7" contained
syn match crossfaderInputParameter "^\s*i8" contained
syn match crossfaderInputParameter "^\s*input" contained
syn match crossfaderInputParameter "^\s*input1" contained
syn match crossfaderInputParameter "^\s*input2" contained
syn match crossfaderInputParameter "^\s*input3" contained
syn match crossfaderInputParameter "^\s*input4" contained
syn match crossfaderInputParameter "^\s*input5" contained
syn match crossfaderInputParameter "^\s*input6" contained
syn match crossfaderInputParameter "^\s*input7" contained
syn match crossfaderInputParameter "^\s*input8" contained
syn match crossfaderOutputParameter "^\s*o" contained
syn match crossfaderOutputParameter "^\s*output" contained
syn match crossfaderHeader /\[crossfader\]/ contained
syn region crossfaderCircuit start=/\[crossfader\]/ end=/\[/me=s-1 transparent contains=crossfaderHeader,crossfaderInputParameter,crossfaderOutputParameter,ioregister,number,cable,quotestring,comment
hi def link crossfaderHeader circuitHeader
hi def link crossfaderInputParameter inputParameter
hi def link crossfaderOutputParameter outputParameter


" cvlooper
syn match cvlooperInputParameter "^\s*b" contained
syn match cvlooperInputParameter "^\s*bypass" contained
syn match cvlooperInputParameter "^\s*c" contained
syn match cvlooperInputParameter "^\s*ci" contained
syn match cvlooperInputParameter "^\s*clock" contained
syn match cvlooperOutputParameter "^\s*co" contained
syn match cvlooperInputParameter "^\s*cvin" contained
syn match cvlooperOutputParameter "^\s*cvout" contained
syn match cvlooperInputParameter "^\s*gatein" contained
syn match cvlooperOutputParameter "^\s*gateout" contained
syn match cvlooperInputParameter "^\s*gi" contained
syn match cvlooperOutputParameter "^\s*go" contained
syn match cvlooperInputParameter "^\s*l" contained
syn match cvlooperInputParameter "^\s*length" contained
syn match cvlooperInputParameter "^\s*loopswitch" contained
syn match cvlooperInputParameter "^\s*ls" contained
syn match cvlooperInputParameter "^\s*od" contained
syn match cvlooperInputParameter "^\s*ov" contained
syn match cvlooperInputParameter "^\s*overdub" contained
syn match cvlooperInputParameter "^\s*overlay" contained
syn match cvlooperInputParameter "^\s*p" contained
syn match cvlooperInputParameter "^\s*pause" contained
syn match cvlooperInputParameter "^\s*r" contained
syn match cvlooperInputParameter "^\s*reset" contained
syn match cvlooperInputParameter "^\s*s" contained
syn match cvlooperInputParameter "^\s*tapespeed" contained
syn match cvlooperHeader /\[cvlooper\]/ contained
syn region cvlooperCircuit start=/\[cvlooper\]/ end=/\[/me=s-1 transparent contains=cvlooperHeader,cvlooperInputParameter,cvlooperOutputParameter,ioregister,number,cable,quotestring,comment
hi def link cvlooperHeader circuitHeader
hi def link cvlooperInputParameter inputParameter
hi def link cvlooperOutputParameter outputParameter


" dac
syn match dacInputParameter "^\s*b1" contained
syn match dacInputParameter "^\s*b10" contained
syn match dacInputParameter "^\s*b11" contained
syn match dacInputParameter "^\s*b12" contained
syn match dacInputParameter "^\s*b2" contained
syn match dacInputParameter "^\s*b3" contained
syn match dacInputParameter "^\s*b4" contained
syn match dacInputParameter "^\s*b5" contained
syn match dacInputParameter "^\s*b6" contained
syn match dacInputParameter "^\s*b7" contained
syn match dacInputParameter "^\s*b8" contained
syn match dacInputParameter "^\s*b9" contained
syn match dacInputParameter "^\s*bit" contained
syn match dacInputParameter "^\s*bit1" contained
syn match dacInputParameter "^\s*bit10" contained
syn match dacInputParameter "^\s*bit11" contained
syn match dacInputParameter "^\s*bit12" contained
syn match dacInputParameter "^\s*bit2" contained
syn match dacInputParameter "^\s*bit3" contained
syn match dacInputParameter "^\s*bit4" contained
syn match dacInputParameter "^\s*bit5" contained
syn match dacInputParameter "^\s*bit6" contained
syn match dacInputParameter "^\s*bit7" contained
syn match dacInputParameter "^\s*bit8" contained
syn match dacInputParameter "^\s*bit9" contained
syn match dacInputParameter "^\s*m" contained
syn match dacInputParameter "^\s*maximum" contained
syn match dacInputParameter "^\s*minimum" contained
syn match dacOutputParameter "^\s*o" contained
syn match dacOutputParameter "^\s*output" contained
syn match dacInputParameter "^\s*x" contained
syn match dacHeader /\[dac\]/ contained
syn region dacCircuit start=/\[dac\]/ end=/\[/me=s-1 transparent contains=dacHeader,dacInputParameter,dacOutputParameter,ioregister,number,cable,quotestring,comment
hi def link dacHeader circuitHeader
hi def link dacInputParameter inputParameter
hi def link dacOutputParameter outputParameter


" delay
syn match delayInputParameter "^\s*b" contained
syn match delayInputParameter "^\s*bypass" contained
syn match delayInputParameter "^\s*c" contained
syn match delayInputParameter "^\s*ci" contained
syn match delayInputParameter "^\s*clock" contained
syn match delayOutputParameter "^\s*co" contained
syn match delayInputParameter "^\s*cvin" contained
syn match delayOutputParameter "^\s*cvout" contained
syn match delayInputParameter "^\s*delay" contained
syn match delayInputParameter "^\s*dl" contained
syn match delayInputParameter "^\s*f" contained
syn match delayInputParameter "^\s*filenumber" contained
syn match delayInputParameter "^\s*gatein" contained
syn match delayInputParameter "^\s*gatein1" contained
syn match delayInputParameter "^\s*gatein2" contained
syn match delayInputParameter "^\s*gatein3" contained
syn match delayInputParameter "^\s*gatein4" contained
syn match delayInputParameter "^\s*gatein5" contained
syn match delayInputParameter "^\s*gatein6" contained
syn match delayInputParameter "^\s*gatein7" contained
syn match delayInputParameter "^\s*gatein8" contained
syn match delayOutputParameter "^\s*gateout" contained
syn match delayOutputParameter "^\s*gateout1" contained
syn match delayOutputParameter "^\s*gateout2" contained
syn match delayOutputParameter "^\s*gateout3" contained
syn match delayOutputParameter "^\s*gateout4" contained
syn match delayOutputParameter "^\s*gateout5" contained
syn match delayOutputParameter "^\s*gateout6" contained
syn match delayOutputParameter "^\s*gateout7" contained
syn match delayOutputParameter "^\s*gateout8" contained
syn match delayInputParameter "^\s*gi1" contained
syn match delayInputParameter "^\s*gi2" contained
syn match delayInputParameter "^\s*gi3" contained
syn match delayInputParameter "^\s*gi4" contained
syn match delayInputParameter "^\s*gi5" contained
syn match delayInputParameter "^\s*gi6" contained
syn match delayInputParameter "^\s*gi7" contained
syn match delayInputParameter "^\s*gi8" contained
syn match delayOutputParameter "^\s*go1" contained
syn match delayOutputParameter "^\s*go2" contained
syn match delayOutputParameter "^\s*go3" contained
syn match delayOutputParameter "^\s*go4" contained
syn match delayOutputParameter "^\s*go5" contained
syn match delayOutputParameter "^\s*go6" contained
syn match delayOutputParameter "^\s*go7" contained
syn match delayOutputParameter "^\s*go8" contained
syn match delayInputParameter "^\s*ld" contained
syn match delayInputParameter "^\s*load" contained
syn match delayInputParameter "^\s*ni" contained
syn match delayOutputParameter "^\s*no" contained
syn match delayInputParameter "^\s*numberin" contained
syn match delayOutputParameter "^\s*numberout" contained
syn match delayOutputParameter "^\s*ov" contained
syn match delayOutputParameter "^\s*overflow" contained
syn match delayInputParameter "^\s*sample" contained
syn match delayInputParameter "^\s*save" contained
syn match delayInputParameter "^\s*sm" contained
syn match delayInputParameter "^\s*sv" contained
syn match delayInputParameter "^\s*timewindow" contained
syn match delayInputParameter "^\s*tw" contained
syn match delayHeader /\[delay\]/ contained
syn region delayCircuit start=/\[delay\]/ end=/\[/me=s-1 transparent contains=delayHeader,delayInputParameter,delayOutputParameter,ioregister,number,cable,quotestring,comment
hi def link delayHeader circuitHeader
hi def link delayInputParameter inputParameter
hi def link delayOutputParameter outputParameter


" detune
syn match detuneInputParameter "^\s*d" contained
syn match detuneInputParameter "^\s*detune" contained
syn match detuneInputParameter "^\s*i1" contained
syn match detuneInputParameter "^\s*i2" contained
syn match detuneInputParameter "^\s*i3" contained
syn match detuneInputParameter "^\s*i4" contained
syn match detuneInputParameter "^\s*i5" contained
syn match detuneInputParameter "^\s*i6" contained
syn match detuneInputParameter "^\s*i7" contained
syn match detuneInputParameter "^\s*i8" contained
syn match detuneInputParameter "^\s*input" contained
syn match detuneInputParameter "^\s*input1" contained
syn match detuneInputParameter "^\s*input2" contained
syn match detuneInputParameter "^\s*input3" contained
syn match detuneInputParameter "^\s*input4" contained
syn match detuneInputParameter "^\s*input5" contained
syn match detuneInputParameter "^\s*input6" contained
syn match detuneInputParameter "^\s*input7" contained
syn match detuneInputParameter "^\s*input8" contained
syn match detuneOutputParameter "^\s*o1" contained
syn match detuneOutputParameter "^\s*o2" contained
syn match detuneOutputParameter "^\s*o3" contained
syn match detuneOutputParameter "^\s*o4" contained
syn match detuneOutputParameter "^\s*o5" contained
syn match detuneOutputParameter "^\s*o6" contained
syn match detuneOutputParameter "^\s*o7" contained
syn match detuneOutputParameter "^\s*o8" contained
syn match detuneOutputParameter "^\s*output" contained
syn match detuneOutputParameter "^\s*output1" contained
syn match detuneOutputParameter "^\s*output2" contained
syn match detuneOutputParameter "^\s*output3" contained
syn match detuneOutputParameter "^\s*output4" contained
syn match detuneOutputParameter "^\s*output5" contained
syn match detuneOutputParameter "^\s*output6" contained
syn match detuneOutputParameter "^\s*output7" contained
syn match detuneOutputParameter "^\s*output8" contained
syn match detuneInputParameter "^\s*tm" contained
syn match detuneInputParameter "^\s*tp" contained
syn match detuneInputParameter "^\s*tuningmode" contained
syn match detuneInputParameter "^\s*tuningpitch" contained
syn match detuneHeader /\[detune\]/ contained
syn region detuneCircuit start=/\[detune\]/ end=/\[/me=s-1 transparent contains=detuneHeader,detuneInputParameter,detuneOutputParameter,ioregister,number,cable,quotestring,comment
hi def link detuneHeader circuitHeader
hi def link detuneInputParameter inputParameter
hi def link detuneOutputParameter outputParameter


" display
syn match displayInputParameter "^\s*display" contained
syn match displayInputParameter "^\s*dy" contained
syn match displayInputParameter "^\s*f" contained
syn match displayInputParameter "^\s*fontsize" contained
syn match displayInputParameter "^\s*header" contained
syn match displayInputParameter "^\s*hr" contained
syn match displayInputParameter "^\s*l" contained
syn match displayInputParameter "^\s*linger" contained
syn match displayInputParameter "^\s*nm" contained
syn match displayInputParameter "^\s*numbermode" contained
syn match displayInputParameter "^\s*s" contained
syn match displayInputParameter "^\s*sa" contained
syn match displayInputParameter "^\s*screensaver" contained
syn match displayInputParameter "^\s*select" contained
syn match displayInputParameter "^\s*selectat" contained
syn match displayInputParameter "^\s*ss" contained
syn match displayInputParameter "^\s*t" contained
syn match displayInputParameter "^\s*takeovercontrols" contained
syn match displayInputParameter "^\s*text" contained
syn match displayInputParameter "^\s*th" contained
syn match displayInputParameter "^\s*threshold" contained
syn match displayInputParameter "^\s*to" contained
syn match displayInputParameter "^\s*trigger" contained
syn match displayInputParameter "^\s*tx" contained
syn match displayInputParameter "^\s*u" contained
syn match displayInputParameter "^\s*useasdefault" contained
syn match displayInputParameter "^\s*v" contained
syn match displayInputParameter "^\s*value" contained
syn match displayHeader /\[display\]/ contained
syn region displayCircuit start=/\[display\]/ end=/\[/me=s-1 transparent contains=displayHeader,displayInputParameter,displayOutputParameter,ioregister,number,cable,quotestring,comment
hi def link displayHeader circuitHeader
hi def link displayInputParameter inputParameter
hi def link displayOutputParameter outputParameter


" droid
syn match droidInputParameter "^\s*c" contained
syn match droidInputParameter "^\s*ca" contained
syn match droidInputParameter "^\s*calibrate" contained
syn match droidInputParameter "^\s*cl" contained
syn match droidInputParameter "^\s*clear" contained
syn match droidInputParameter "^\s*clearall" contained
syn match droidInputParameter "^\s*l" contained
syn match droidInputParameter "^\s*ledbrightness" contained
syn match droidInputParameter "^\s*lf1" contained
syn match droidInputParameter "^\s*lf2" contained
syn match droidInputParameter "^\s*lf3" contained
syn match droidInputParameter "^\s*lf4" contained
syn match droidInputParameter "^\s*lf5" contained
syn match droidInputParameter "^\s*lf6" contained
syn match droidInputParameter "^\s*lf7" contained
syn match droidInputParameter "^\s*lf8" contained
syn match droidInputParameter "^\s*lpfilter" contained
syn match droidInputParameter "^\s*lpfilter1" contained
syn match droidInputParameter "^\s*lpfilter2" contained
syn match droidInputParameter "^\s*lpfilter3" contained
syn match droidInputParameter "^\s*lpfilter4" contained
syn match droidInputParameter "^\s*lpfilter5" contained
syn match droidInputParameter "^\s*lpfilter6" contained
syn match droidInputParameter "^\s*lpfilter7" contained
syn match droidInputParameter "^\s*lpfilter8" contained
syn match droidInputParameter "^\s*m4f" contained
syn match droidInputParameter "^\s*m4faderspeed" contained
syn match droidInputParameter "^\s*m4n" contained
syn match droidInputParameter "^\s*m4notchpower" contained
syn match droidInputParameter "^\s*m4t1" contained
syn match droidInputParameter "^\s*m4t2" contained
syn match droidInputParameter "^\s*m4t3" contained
syn match droidInputParameter "^\s*m4t4" contained
syn match droidInputParameter "^\s*m4t5" contained
syn match droidInputParameter "^\s*m4t6" contained
syn match droidInputParameter "^\s*m4t7" contained
syn match droidInputParameter "^\s*m4t8" contained
syn match droidInputParameter "^\s*m4touchgain" contained
syn match droidInputParameter "^\s*m4touchgain1" contained
syn match droidInputParameter "^\s*m4touchgain2" contained
syn match droidInputParameter "^\s*m4touchgain3" contained
syn match droidInputParameter "^\s*m4touchgain4" contained
syn match droidInputParameter "^\s*m4touchgain5" contained
syn match droidInputParameter "^\s*m4touchgain6" contained
syn match droidInputParameter "^\s*m4touchgain7" contained
syn match droidInputParameter "^\s*m4touchgain8" contained
syn match droidInputParameter "^\s*maxslope" contained
syn match droidInputParameter "^\s*maxslope1" contained
syn match droidInputParameter "^\s*maxslope2" contained
syn match droidInputParameter "^\s*maxslope3" contained
syn match droidInputParameter "^\s*maxslope4" contained
syn match droidInputParameter "^\s*maxslope5" contained
syn match droidInputParameter "^\s*maxslope6" contained
syn match droidInputParameter "^\s*maxslope7" contained
syn match droidInputParameter "^\s*maxslope8" contained
syn match droidInputParameter "^\s*s1" contained
syn match droidInputParameter "^\s*s2" contained
syn match droidInputParameter "^\s*s3" contained
syn match droidInputParameter "^\s*s4" contained
syn match droidInputParameter "^\s*s5" contained
syn match droidInputParameter "^\s*s6" contained
syn match droidInputParameter "^\s*s7" contained
syn match droidInputParameter "^\s*s8" contained
syn match droidInputParameter "^\s*sd" contained
syn match droidInputParameter "^\s*startcontrollerupgrade" contained
syn match droidInputParameter "^\s*startx7upgrade" contained
syn match droidInputParameter "^\s*statusdump" contained
syn match droidInputParameter "^\s*u" contained
syn match droidInputParameter "^\s*uislowdown" contained
syn match droidInputParameter "^\s*us" contained
syn match droidInputParameter "^\s*x7" contained
syn match droidHeader /\[droid\]/ contained
syn region droidCircuit start=/\[droid\]/ end=/\[/me=s-1 transparent contains=droidHeader,droidInputParameter,droidOutputParameter,ioregister,number,cable,quotestring,comment
hi def link droidHeader circuitHeader
hi def link droidInputParameter inputParameter
hi def link droidOutputParameter outputParameter


" encoderbank
syn match encoderbankInputParameter "^\s*a" contained
syn match encoderbankInputParameter "^\s*autozoom" contained
syn match encoderbankOutputParameter "^\s*b1" contained
syn match encoderbankOutputParameter "^\s*b2" contained
syn match encoderbankOutputParameter "^\s*b3" contained
syn match encoderbankOutputParameter "^\s*b4" contained
syn match encoderbankOutputParameter "^\s*b5" contained
syn match encoderbankOutputParameter "^\s*b6" contained
syn match encoderbankOutputParameter "^\s*b7" contained
syn match encoderbankOutputParameter "^\s*b8" contained
syn match encoderbankOutputParameter "^\s*button" contained
syn match encoderbankOutputParameter "^\s*button1" contained
syn match encoderbankOutputParameter "^\s*button2" contained
syn match encoderbankOutputParameter "^\s*button3" contained
syn match encoderbankOutputParameter "^\s*button4" contained
syn match encoderbankOutputParameter "^\s*button5" contained
syn match encoderbankOutputParameter "^\s*button6" contained
syn match encoderbankOutputParameter "^\s*button7" contained
syn match encoderbankOutputParameter "^\s*button8" contained
syn match encoderbankInputParameter "^\s*ca" contained
syn match encoderbankInputParameter "^\s*cl" contained
syn match encoderbankInputParameter "^\s*clear" contained
syn match encoderbankInputParameter "^\s*clearall" contained
syn match encoderbankInputParameter "^\s*co" contained
syn match encoderbankInputParameter "^\s*color" contained
syn match encoderbankInputParameter "^\s*d" contained
syn match encoderbankInputParameter "^\s*discrete" contained
syn match encoderbankInputParameter "^\s*display" contained
syn match encoderbankInputParameter "^\s*dontsave" contained
syn match encoderbankInputParameter "^\s*dos" contained
syn match encoderbankInputParameter "^\s*dy" contained
syn match encoderbankInputParameter "^\s*e" contained
syn match encoderbankInputParameter "^\s*firstencoder" contained
syn match encoderbankInputParameter "^\s*header" contained
syn match encoderbankInputParameter "^\s*hr" contained
syn match encoderbankInputParameter "^\s*l1" contained
syn match encoderbankInputParameter "^\s*l2" contained
syn match encoderbankInputParameter "^\s*l3" contained
syn match encoderbankInputParameter "^\s*l4" contained
syn match encoderbankInputParameter "^\s*l5" contained
syn match encoderbankInputParameter "^\s*l6" contained
syn match encoderbankInputParameter "^\s*l7" contained
syn match encoderbankInputParameter "^\s*l8" contained
syn match encoderbankInputParameter "^\s*led" contained
syn match encoderbankInputParameter "^\s*led1" contained
syn match encoderbankInputParameter "^\s*led2" contained
syn match encoderbankInputParameter "^\s*led3" contained
syn match encoderbankInputParameter "^\s*led4" contained
syn match encoderbankInputParameter "^\s*led5" contained
syn match encoderbankInputParameter "^\s*led6" contained
syn match encoderbankInputParameter "^\s*led7" contained
syn match encoderbankInputParameter "^\s*led8" contained
syn match encoderbankInputParameter "^\s*ledfill" contained
syn match encoderbankInputParameter "^\s*lf" contained
syn match encoderbankInputParameter "^\s*loadpreset" contained
syn match encoderbankInputParameter "^\s*lp" contained
syn match encoderbankInputParameter "^\s*m" contained
syn match encoderbankInputParameter "^\s*mode" contained
syn match encoderbankInputParameter "^\s*nc" contained
syn match encoderbankInputParameter "^\s*negativecolor" contained
syn match encoderbankInputParameter "^\s*no" contained
syn match encoderbankInputParameter "^\s*notch" contained
syn match encoderbankOutputParameter "^\s*o1" contained
syn match encoderbankOutputParameter "^\s*o2" contained
syn match encoderbankOutputParameter "^\s*o3" contained
syn match encoderbankOutputParameter "^\s*o4" contained
syn match encoderbankOutputParameter "^\s*o5" contained
syn match encoderbankOutputParameter "^\s*o6" contained
syn match encoderbankOutputParameter "^\s*o7" contained
syn match encoderbankOutputParameter "^\s*o8" contained
syn match encoderbankInputParameter "^\s*oo" contained
syn match encoderbankInputParameter "^\s*os" contained
syn match encoderbankOutputParameter "^\s*output" contained
syn match encoderbankOutputParameter "^\s*output1" contained
syn match encoderbankOutputParameter "^\s*output2" contained
syn match encoderbankOutputParameter "^\s*output3" contained
syn match encoderbankOutputParameter "^\s*output4" contained
syn match encoderbankOutputParameter "^\s*output5" contained
syn match encoderbankOutputParameter "^\s*output6" contained
syn match encoderbankOutputParameter "^\s*output7" contained
syn match encoderbankOutputParameter "^\s*output8" contained
syn match encoderbankInputParameter "^\s*outputoffset" contained
syn match encoderbankInputParameter "^\s*outputscale" contained
syn match encoderbankInputParameter "^\s*pr" contained
syn match encoderbankInputParameter "^\s*preset" contained
syn match encoderbankInputParameter "^\s*s" contained
syn match encoderbankInputParameter "^\s*sa" contained
syn match encoderbankInputParameter "^\s*savepreset" contained
syn match encoderbankInputParameter "^\s*se" contained
syn match encoderbankInputParameter "^\s*select" contained
syn match encoderbankInputParameter "^\s*selectat" contained
syn match encoderbankInputParameter "^\s*sensivity" contained
syn match encoderbankInputParameter "^\s*sf" contained
syn match encoderbankInputParameter "^\s*sm" contained
syn match encoderbankInputParameter "^\s*smooth" contained
syn match encoderbankInputParameter "^\s*sn" contained
syn match encoderbankInputParameter "^\s*snapforce" contained
syn match encoderbankInputParameter "^\s*snapto" contained
syn match encoderbankInputParameter "^\s*sp" contained
syn match encoderbankInputParameter "^\s*startvalue" contained
syn match encoderbankInputParameter "^\s*sv" contained
syn match encoderbankHeader /\[encoderbank\]/ contained
syn region encoderbankCircuit start=/\[encoderbank\]/ end=/\[/me=s-1 transparent contains=encoderbankHeader,encoderbankInputParameter,encoderbankOutputParameter,ioregister,number,cable,quotestring,comment
hi def link encoderbankHeader circuitHeader
hi def link encoderbankInputParameter inputParameter
hi def link encoderbankOutputParameter outputParameter


" encoder
syn match encoderInputParameter "^\s*a" contained
syn match encoderInputParameter "^\s*autozoom" contained
syn match encoderOutputParameter "^\s*b" contained
syn match encoderOutputParameter "^\s*button" contained
syn match encoderInputParameter "^\s*ca" contained
syn match encoderInputParameter "^\s*cl" contained
syn match encoderInputParameter "^\s*clear" contained
syn match encoderInputParameter "^\s*clearall" contained
syn match encoderInputParameter "^\s*co" contained
syn match encoderInputParameter "^\s*color" contained
syn match encoderInputParameter "^\s*d" contained
syn match encoderInputParameter "^\s*discrete" contained
syn match encoderInputParameter "^\s*display" contained
syn match encoderInputParameter "^\s*dontsave" contained
syn match encoderInputParameter "^\s*dos" contained
syn match encoderInputParameter "^\s*dy" contained
syn match encoderInputParameter "^\s*e" contained
syn match encoderInputParameter "^\s*encoder" contained
syn match encoderInputParameter "^\s*header" contained
syn match encoderInputParameter "^\s*hr" contained
syn match encoderInputParameter "^\s*l" contained
syn match encoderInputParameter "^\s*led" contained
syn match encoderInputParameter "^\s*ledfill" contained
syn match encoderInputParameter "^\s*lf" contained
syn match encoderInputParameter "^\s*loadpreset" contained
syn match encoderInputParameter "^\s*lp" contained
syn match encoderInputParameter "^\s*m" contained
syn match encoderOutputParameter "^\s*md" contained
syn match encoderInputParameter "^\s*mode" contained
syn match encoderOutputParameter "^\s*moveddown" contained
syn match encoderOutputParameter "^\s*movedup" contained
syn match encoderInputParameter "^\s*movementticks" contained
syn match encoderOutputParameter "^\s*mu" contained
syn match encoderInputParameter "^\s*mv" contained
syn match encoderInputParameter "^\s*nc" contained
syn match encoderInputParameter "^\s*negativecolor" contained
syn match encoderInputParameter "^\s*no" contained
syn match encoderInputParameter "^\s*notch" contained
syn match encoderOutputParameter "^\s*o" contained
syn match encoderInputParameter "^\s*oo" contained
syn match encoderInputParameter "^\s*or" contained
syn match encoderInputParameter "^\s*os" contained
syn match encoderOutputParameter "^\s*output" contained
syn match encoderInputParameter "^\s*outputoffset" contained
syn match encoderInputParameter "^\s*outputscale" contained
syn match encoderInputParameter "^\s*override" contained
syn match encoderInputParameter "^\s*pr" contained
syn match encoderInputParameter "^\s*preset" contained
syn match encoderInputParameter "^\s*s" contained
syn match encoderInputParameter "^\s*sa" contained
syn match encoderInputParameter "^\s*savepreset" contained
syn match encoderInputParameter "^\s*se" contained
syn match encoderInputParameter "^\s*select" contained
syn match encoderInputParameter "^\s*selectat" contained
syn match encoderInputParameter "^\s*sensivity" contained
syn match encoderInputParameter "^\s*sf" contained
syn match encoderInputParameter "^\s*sharewithnext" contained
syn match encoderInputParameter "^\s*sm" contained
syn match encoderInputParameter "^\s*smooth" contained
syn match encoderInputParameter "^\s*sn" contained
syn match encoderInputParameter "^\s*snapforce" contained
syn match encoderInputParameter "^\s*snapto" contained
syn match encoderInputParameter "^\s*sp" contained
syn match encoderInputParameter "^\s*startvalue" contained
syn match encoderInputParameter "^\s*sv" contained
syn match encoderInputParameter "^\s*sw" contained
syn match encoderOutputParameter "^\s*valuechanged" contained
syn match encoderOutputParameter "^\s*vc" contained
syn match encoderHeader /\[encoder\]/ contained
syn region encoderCircuit start=/\[encoder\]/ end=/\[/me=s-1 transparent contains=encoderHeader,encoderInputParameter,encoderOutputParameter,ioregister,number,cable,quotestring,comment
hi def link encoderHeader circuitHeader
hi def link encoderInputParameter inputParameter
hi def link encoderOutputParameter outputParameter


" encoquencer
syn match encoquencerInputParameter "^\s*ac" contained
syn match encoquencerOutputParameter "^\s*acc" contained
syn match encoquencerOutputParameter "^\s*accumulator" contained
syn match encoquencerInputParameter "^\s*accumulatorrange" contained
syn match encoquencerInputParameter "^\s*ar" contained
syn match encoquencerInputParameter "^\s*autoreset" contained
syn match encoquencerInputParameter "^\s*bc" contained
syn match encoquencerInputParameter "^\s*be" contained
syn match encoquencerInputParameter "^\s*bm" contained
syn match encoquencerInputParameter "^\s*bulkedit" contained
syn match encoquencerInputParameter "^\s*buttoncolor" contained
syn match encoquencerInputParameter "^\s*buttonmode" contained
syn match encoquencerInputParameter "^\s*c" contained
syn match encoquencerInputParameter "^\s*ca" contained
syn match encoquencerInputParameter "^\s*cb" contained
syn match encoquencerInputParameter "^\s*ce" contained
syn match encoquencerInputParameter "^\s*cl" contained
syn match encoquencerInputParameter "^\s*clear" contained
syn match encoquencerInputParameter "^\s*clearall" contained
syn match encoquencerInputParameter "^\s*clearrepeats" contained
syn match encoquencerInputParameter "^\s*clearskips" contained
syn match encoquencerInputParameter "^\s*clearstartend" contained
syn match encoquencerInputParameter "^\s*clock" contained
syn match encoquencerInputParameter "^\s*cm" contained
syn match encoquencerInputParameter "^\s*cn" contained
syn match encoquencerInputParameter "^\s*co" contained
syn match encoquencerInputParameter "^\s*composemode" contained
syn match encoquencerInputParameter "^\s*constantlength" contained
syn match encoquencerInputParameter "^\s*copy" contained
syn match encoquencerOutputParameter "^\s*cpg" contained
syn match encoquencerInputParameter "^\s*cr" contained
syn match encoquencerInputParameter "^\s*crp" contained
syn match encoquencerInputParameter "^\s*cs" contained
syn match encoquencerInputParameter "^\s*cse" contained
syn match encoquencerOutputParameter "^\s*cst" contained
syn match encoquencerOutputParameter "^\s*currentpage" contained
syn match encoquencerOutputParameter "^\s*currentstep" contained
syn match encoquencerOutputParameter "^\s*cv" contained
syn match encoquencerInputParameter "^\s*cvbase" contained
syn match encoquencerInputParameter "^\s*cvname" contained
syn match encoquencerInputParameter "^\s*cvnotches" contained
syn match encoquencerInputParameter "^\s*cvrange" contained
syn match encoquencerInputParameter "^\s*cy" contained
syn match encoquencerInputParameter "^\s*d" contained
syn match encoquencerInputParameter "^\s*dc" contained
syn match encoquencerInputParameter "^\s*defaultcv" contained
syn match encoquencerInputParameter "^\s*defaultgate" contained
syn match encoquencerInputParameter "^\s*degree" contained
syn match encoquencerInputParameter "^\s*dfg" contained
syn match encoquencerInputParameter "^\s*dg" contained
syn match encoquencerInputParameter "^\s*direction" contained
syn match encoquencerInputParameter "^\s*display" contained
syn match encoquencerInputParameter "^\s*dontsave" contained
syn match encoquencerInputParameter "^\s*dos" contained
syn match encoquencerInputParameter "^\s*doublerange" contained
syn match encoquencerInputParameter "^\s*dr" contained
syn match encoquencerInputParameter "^\s*dy" contained
syn match encoquencerInputParameter "^\s*endstep" contained
syn match encoquencerOutputParameter "^\s*endstepout" contained
syn match encoquencerInputParameter "^\s*es" contained
syn match encoquencerOutputParameter "^\s*eso" contained
syn match encoquencerInputParameter "^\s*f" contained
syn match encoquencerInputParameter "^\s*fadermode" contained
syn match encoquencerInputParameter "^\s*firstfader" contained
syn match encoquencerInputParameter "^\s*fm" contained
syn match encoquencerInputParameter "^\s*fo" contained
syn match encoquencerInputParameter "^\s*form" contained
syn match encoquencerOutputParameter "^\s*g" contained
syn match encoquencerOutputParameter "^\s*gate" contained
syn match encoquencerInputParameter "^\s*gatelength" contained
syn match encoquencerInputParameter "^\s*gatename" contained
syn match encoquencerInputParameter "^\s*gl" contained
syn match encoquencerInputParameter "^\s*gn" contained
syn match encoquencerInputParameter "^\s*harmonicshift" contained
syn match encoquencerInputParameter "^\s*has" contained
syn match encoquencerInputParameter "^\s*hc" contained
syn match encoquencerInputParameter "^\s*holdcv" contained
syn match encoquencerInputParameter "^\s*invert" contained
syn match encoquencerInputParameter "^\s*iv" contained
syn match encoquencerInputParameter "^\s*kc" contained
syn match encoquencerInputParameter "^\s*keyboardcv" contained
syn match encoquencerInputParameter "^\s*keyboardgate" contained
syn match encoquencerInputParameter "^\s*keyboardmode" contained
syn match encoquencerInputParameter "^\s*kg" contained
syn match encoquencerInputParameter "^\s*km" contained
syn match encoquencerInputParameter "^\s*la" contained
syn match encoquencerInputParameter "^\s*lb" contained
syn match encoquencerInputParameter "^\s*lc" contained
syn match encoquencerInputParameter "^\s*lcv" contained
syn match encoquencerInputParameter "^\s*ld" contained
syn match encoquencerInputParameter "^\s*ledpreview" contained
syn match encoquencerInputParameter "^\s*lf" contained
syn match encoquencerInputParameter "^\s*lg" contained
syn match encoquencerInputParameter "^\s*lga" contained
syn match encoquencerInputParameter "^\s*lgp" contained
syn match encoquencerInputParameter "^\s*li" contained
syn match encoquencerInputParameter "^\s*linktonext" contained
syn match encoquencerInputParameter "^\s*lk" contained
syn match encoquencerInputParameter "^\s*ln" contained
syn match encoquencerInputParameter "^\s*loadpreset" contained
syn match encoquencerInputParameter "^\s*lp" contained
syn match encoquencerInputParameter "^\s*lr" contained
syn match encoquencerInputParameter "^\s*lrc" contained
syn match encoquencerInputParameter "^\s*lrp" contained
syn match encoquencerInputParameter "^\s*lrt" contained
syn match encoquencerInputParameter "^\s*lrv" contained
syn match encoquencerInputParameter "^\s*ls" contained
syn match encoquencerInputParameter "^\s*lsh" contained
syn match encoquencerInputParameter "^\s*lt" contained
syn match encoquencerInputParameter "^\s*luckyamount" contained
syn match encoquencerInputParameter "^\s*luckybuttons" contained
syn match encoquencerInputParameter "^\s*luckychance" contained
syn match encoquencerInputParameter "^\s*luckycvbase" contained
syn match encoquencerInputParameter "^\s*luckycvdrift" contained
syn match encoquencerInputParameter "^\s*luckycvs" contained
syn match encoquencerInputParameter "^\s*luckyfaders" contained
syn match encoquencerInputParameter "^\s*luckygatepattern" contained
syn match encoquencerInputParameter "^\s*luckygateprob" contained
syn match encoquencerInputParameter "^\s*luckygates" contained
syn match encoquencerInputParameter "^\s*luckyinvert" contained
syn match encoquencerInputParameter "^\s*luckyrandomizecv" contained
syn match encoquencerInputParameter "^\s*luckyratchets" contained
syn match encoquencerInputParameter "^\s*luckyrepeats" contained
syn match encoquencerInputParameter "^\s*luckyreverse" contained
syn match encoquencerInputParameter "^\s*luckyscope" contained
syn match encoquencerInputParameter "^\s*luckyshuffle" contained
syn match encoquencerInputParameter "^\s*luckyskips" contained
syn match encoquencerInputParameter "^\s*luckyspread" contained
syn match encoquencerInputParameter "^\s*luckyties" contained
syn match encoquencerInputParameter "^\s*lv" contained
syn match encoquencerInputParameter "^\s*m" contained
syn match encoquencerInputParameter "^\s*metricsaver" contained
syn match encoquencerInputParameter "^\s*ms" contained
syn match encoquencerInputParameter "^\s*mute" contained
syn match encoquencerInputParameter "^\s*n" contained
syn match encoquencerInputParameter "^\s*n4" contained
syn match encoquencerInputParameter "^\s*nos" contained
syn match encoquencerInputParameter "^\s*noteshift" contained
syn match encoquencerInputParameter "^\s*ns" contained
syn match encoquencerInputParameter "^\s*nume4s" contained
syn match encoquencerInputParameter "^\s*numfaders" contained
syn match encoquencerInputParameter "^\s*numsteps" contained
syn match encoquencerInputParameter "^\s*p" contained
syn match encoquencerInputParameter "^\s*pa" contained
syn match encoquencerInputParameter "^\s*page" contained
syn match encoquencerInputParameter "^\s*paste" contained
syn match encoquencerInputParameter "^\s*pastebuttons" contained
syn match encoquencerInputParameter "^\s*pastefaders" contained
syn match encoquencerInputParameter "^\s*pattern" contained
syn match encoquencerInputParameter "^\s*pb" contained
syn match encoquencerInputParameter "^\s*pf" contained
syn match encoquencerInputParameter "^\s*pingpong" contained
syn match encoquencerInputParameter "^\s*pp" contained
syn match encoquencerInputParameter "^\s*pr" contained
syn match encoquencerInputParameter "^\s*preset" contained
syn match encoquencerInputParameter "^\s*pt" contained
syn match encoquencerInputParameter "^\s*pv" contained
syn match encoquencerInputParameter "^\s*q" contained
syn match encoquencerInputParameter "^\s*quantize" contained
syn match encoquencerInputParameter "^\s*r" contained
syn match encoquencerInputParameter "^\s*ras" contained
syn match encoquencerInputParameter "^\s*ratchetshift" contained
syn match encoquencerInputParameter "^\s*recordmode" contained
syn match encoquencerInputParameter "^\s*recordsilence" contained
syn match encoquencerInputParameter "^\s*repeatshift" contained
syn match encoquencerInputParameter "^\s*reset" contained
syn match encoquencerInputParameter "^\s*rm" contained
syn match encoquencerInputParameter "^\s*ro" contained
syn match encoquencerInputParameter "^\s*root" contained
syn match encoquencerInputParameter "^\s*rs" contained
syn match encoquencerInputParameter "^\s*rsi" contained
syn match encoquencerInputParameter "^\s*ru" contained
syn match encoquencerInputParameter "^\s*run" contained
syn match encoquencerInputParameter "^\s*s" contained
syn match encoquencerInputParameter "^\s*s1" contained
syn match encoquencerInputParameter "^\s*s11" contained
syn match encoquencerInputParameter "^\s*s13" contained
syn match encoquencerInputParameter "^\s*s3" contained
syn match encoquencerInputParameter "^\s*s5" contained
syn match encoquencerInputParameter "^\s*s7" contained
syn match encoquencerInputParameter "^\s*s9" contained
syn match encoquencerInputParameter "^\s*sa" contained
syn match encoquencerInputParameter "^\s*savepreset" contained
syn match encoquencerInputParameter "^\s*sc" contained
syn match encoquencerInputParameter "^\s*select" contained
syn match encoquencerInputParameter "^\s*select1" contained
syn match encoquencerInputParameter "^\s*select11" contained
syn match encoquencerInputParameter "^\s*select13" contained
syn match encoquencerInputParameter "^\s*select3" contained
syn match encoquencerInputParameter "^\s*select5" contained
syn match encoquencerInputParameter "^\s*select7" contained
syn match encoquencerInputParameter "^\s*select9" contained
syn match encoquencerInputParameter "^\s*selectat" contained
syn match encoquencerInputParameter "^\s*selectfill1" contained
syn match encoquencerInputParameter "^\s*selectfill2" contained
syn match encoquencerInputParameter "^\s*selectfill3" contained
syn match encoquencerInputParameter "^\s*selectfill4" contained
syn match encoquencerInputParameter "^\s*selectfill5" contained
syn match encoquencerInputParameter "^\s*selectnoteshift" contained
syn match encoquencerInputParameter "^\s*ses" contained
syn match encoquencerInputParameter "^\s*setendstep" contained
syn match encoquencerInputParameter "^\s*sf1" contained
syn match encoquencerInputParameter "^\s*sf2" contained
syn match encoquencerInputParameter "^\s*sf3" contained
syn match encoquencerInputParameter "^\s*sf4" contained
syn match encoquencerInputParameter "^\s*sf5" contained
syn match encoquencerInputParameter "^\s*sh" contained
syn match encoquencerInputParameter "^\s*shiftsteps" contained
syn match encoquencerInputParameter "^\s*sns" contained
syn match encoquencerInputParameter "^\s*sp" contained
syn match encoquencerOutputParameter "^\s*spa" contained
syn match encoquencerInputParameter "^\s*ss" contained
syn match encoquencerOutputParameter "^\s*sso" contained
syn match encoquencerOutputParameter "^\s*ssq" contained
syn match encoquencerOutputParameter "^\s*startofpart" contained
syn match encoquencerOutputParameter "^\s*startofsequence" contained
syn match encoquencerInputParameter "^\s*startstep" contained
syn match encoquencerOutputParameter "^\s*startstepout" contained
syn match encoquencerInputParameter "^\s*stepcopy" contained
syn match encoquencerInputParameter "^\s*taptempo" contained
syn match encoquencerInputParameter "^\s*tm" contained
syn match encoquencerInputParameter "^\s*tp" contained
syn match encoquencerInputParameter "^\s*tr" contained
syn match encoquencerInputParameter "^\s*transpose" contained
syn match encoquencerInputParameter "^\s*tt" contained
syn match encoquencerInputParameter "^\s*tuningmode" contained
syn match encoquencerInputParameter "^\s*tuningpitch" contained
syn match encoquencerInputParameter "^\s*z" contained
syn match encoquencerInputParameter "^\s*zorder" contained
syn match encoquencerHeader /\[encoquencer\]/ contained
syn region encoquencerCircuit start=/\[encoquencer\]/ end=/\[/me=s-1 transparent contains=encoquencerHeader,encoquencerInputParameter,encoquencerOutputParameter,ioregister,number,cable,quotestring,comment
hi def link encoquencerHeader circuitHeader
hi def link encoquencerInputParameter inputParameter
hi def link encoquencerOutputParameter outputParameter


" euklid
syn match euklidInputParameter "^\s*b" contained
syn match euklidInputParameter "^\s*beats" contained
syn match euklidInputParameter "^\s*c" contained
syn match euklidInputParameter "^\s*clock" contained
syn match euklidInputParameter "^\s*l" contained
syn match euklidInputParameter "^\s*length" contained
syn match euklidOutputParameter "^\s*o" contained
syn match euklidOutputParameter "^\s*ob" contained
syn match euklidInputParameter "^\s*of" contained
syn match euklidOutputParameter "^\s*offbeats" contained
syn match euklidInputParameter "^\s*offset" contained
syn match euklidInputParameter "^\s*os" contained
syn match euklidOutputParameter "^\s*output" contained
syn match euklidInputParameter "^\s*outputsignal" contained
syn match euklidInputParameter "^\s*r" contained
syn match euklidInputParameter "^\s*reset" contained
syn match euklidHeader /\[euklid\]/ contained
syn region euklidCircuit start=/\[euklid\]/ end=/\[/me=s-1 transparent contains=euklidHeader,euklidInputParameter,euklidOutputParameter,ioregister,number,cable,quotestring,comment
hi def link euklidHeader circuitHeader
hi def link euklidInputParameter inputParameter
hi def link euklidOutputParameter outputParameter


" explin
syn match explinInputParameter "^\s*endvalue" contained
syn match explinInputParameter "^\s*ev" contained
syn match explinInputParameter "^\s*i" contained
syn match explinInputParameter "^\s*input" contained
syn match explinInputParameter "^\s*m" contained
syn match explinInputParameter "^\s*mix" contained
syn match explinOutputParameter "^\s*o" contained
syn match explinOutputParameter "^\s*output" contained
syn match explinInputParameter "^\s*startvalue" contained
syn match explinInputParameter "^\s*sv" contained
syn match explinHeader /\[explin\]/ contained
syn region explinCircuit start=/\[explin\]/ end=/\[/me=s-1 transparent contains=explinHeader,explinInputParameter,explinOutputParameter,ioregister,number,cable,quotestring,comment
hi def link explinHeader circuitHeader
hi def link explinInputParameter inputParameter
hi def link explinOutputParameter outputParameter


" faderbank
syn match faderbankOutputParameter "^\s*b1" contained
syn match faderbankOutputParameter "^\s*b10" contained
syn match faderbankOutputParameter "^\s*b11" contained
syn match faderbankOutputParameter "^\s*b12" contained
syn match faderbankOutputParameter "^\s*b13" contained
syn match faderbankOutputParameter "^\s*b14" contained
syn match faderbankOutputParameter "^\s*b15" contained
syn match faderbankOutputParameter "^\s*b16" contained
syn match faderbankOutputParameter "^\s*b2" contained
syn match faderbankOutputParameter "^\s*b3" contained
syn match faderbankOutputParameter "^\s*b4" contained
syn match faderbankOutputParameter "^\s*b5" contained
syn match faderbankOutputParameter "^\s*b6" contained
syn match faderbankOutputParameter "^\s*b7" contained
syn match faderbankOutputParameter "^\s*b8" contained
syn match faderbankOutputParameter "^\s*b9" contained
syn match faderbankOutputParameter "^\s*button" contained
syn match faderbankOutputParameter "^\s*button1" contained
syn match faderbankOutputParameter "^\s*button10" contained
syn match faderbankOutputParameter "^\s*button11" contained
syn match faderbankOutputParameter "^\s*button12" contained
syn match faderbankOutputParameter "^\s*button13" contained
syn match faderbankOutputParameter "^\s*button14" contained
syn match faderbankOutputParameter "^\s*button15" contained
syn match faderbankOutputParameter "^\s*button16" contained
syn match faderbankOutputParameter "^\s*button2" contained
syn match faderbankOutputParameter "^\s*button3" contained
syn match faderbankOutputParameter "^\s*button4" contained
syn match faderbankOutputParameter "^\s*button5" contained
syn match faderbankOutputParameter "^\s*button6" contained
syn match faderbankOutputParameter "^\s*button7" contained
syn match faderbankOutputParameter "^\s*button8" contained
syn match faderbankOutputParameter "^\s*button9" contained
syn match faderbankInputParameter "^\s*ca" contained
syn match faderbankInputParameter "^\s*cl" contained
syn match faderbankInputParameter "^\s*clear" contained
syn match faderbankInputParameter "^\s*clearall" contained
syn match faderbankInputParameter "^\s*display" contained
syn match faderbankInputParameter "^\s*dontsave" contained
syn match faderbankInputParameter "^\s*dos" contained
syn match faderbankInputParameter "^\s*dy" contained
syn match faderbankInputParameter "^\s*f" contained
syn match faderbankInputParameter "^\s*firstfader" contained
syn match faderbankInputParameter "^\s*header" contained
syn match faderbankInputParameter "^\s*hr" contained
syn match faderbankInputParameter "^\s*lc" contained
syn match faderbankInputParameter "^\s*ledcolor" contained
syn match faderbankInputParameter "^\s*ledvalue" contained
syn match faderbankInputParameter "^\s*ledvalue1" contained
syn match faderbankInputParameter "^\s*ledvalue10" contained
syn match faderbankInputParameter "^\s*ledvalue11" contained
syn match faderbankInputParameter "^\s*ledvalue12" contained
syn match faderbankInputParameter "^\s*ledvalue13" contained
syn match faderbankInputParameter "^\s*ledvalue14" contained
syn match faderbankInputParameter "^\s*ledvalue15" contained
syn match faderbankInputParameter "^\s*ledvalue16" contained
syn match faderbankInputParameter "^\s*ledvalue2" contained
syn match faderbankInputParameter "^\s*ledvalue3" contained
syn match faderbankInputParameter "^\s*ledvalue4" contained
syn match faderbankInputParameter "^\s*ledvalue5" contained
syn match faderbankInputParameter "^\s*ledvalue6" contained
syn match faderbankInputParameter "^\s*ledvalue7" contained
syn match faderbankInputParameter "^\s*ledvalue8" contained
syn match faderbankInputParameter "^\s*ledvalue9" contained
syn match faderbankInputParameter "^\s*loadpreset" contained
syn match faderbankInputParameter "^\s*lp" contained
syn match faderbankInputParameter "^\s*lv1" contained
syn match faderbankInputParameter "^\s*lv10" contained
syn match faderbankInputParameter "^\s*lv11" contained
syn match faderbankInputParameter "^\s*lv12" contained
syn match faderbankInputParameter "^\s*lv13" contained
syn match faderbankInputParameter "^\s*lv14" contained
syn match faderbankInputParameter "^\s*lv15" contained
syn match faderbankInputParameter "^\s*lv16" contained
syn match faderbankInputParameter "^\s*lv2" contained
syn match faderbankInputParameter "^\s*lv3" contained
syn match faderbankInputParameter "^\s*lv4" contained
syn match faderbankInputParameter "^\s*lv5" contained
syn match faderbankInputParameter "^\s*lv6" contained
syn match faderbankInputParameter "^\s*lv7" contained
syn match faderbankInputParameter "^\s*lv8" contained
syn match faderbankInputParameter "^\s*lv9" contained
syn match faderbankInputParameter "^\s*n" contained
syn match faderbankInputParameter "^\s*notches" contained
syn match faderbankOutputParameter "^\s*o1" contained
syn match faderbankOutputParameter "^\s*o10" contained
syn match faderbankOutputParameter "^\s*o11" contained
syn match faderbankOutputParameter "^\s*o12" contained
syn match faderbankOutputParameter "^\s*o13" contained
syn match faderbankOutputParameter "^\s*o14" contained
syn match faderbankOutputParameter "^\s*o15" contained
syn match faderbankOutputParameter "^\s*o16" contained
syn match faderbankOutputParameter "^\s*o2" contained
syn match faderbankOutputParameter "^\s*o3" contained
syn match faderbankOutputParameter "^\s*o4" contained
syn match faderbankOutputParameter "^\s*o5" contained
syn match faderbankOutputParameter "^\s*o6" contained
syn match faderbankOutputParameter "^\s*o7" contained
syn match faderbankOutputParameter "^\s*o8" contained
syn match faderbankOutputParameter "^\s*o9" contained
syn match faderbankOutputParameter "^\s*output" contained
syn match faderbankOutputParameter "^\s*output1" contained
syn match faderbankOutputParameter "^\s*output10" contained
syn match faderbankOutputParameter "^\s*output11" contained
syn match faderbankOutputParameter "^\s*output12" contained
syn match faderbankOutputParameter "^\s*output13" contained
syn match faderbankOutputParameter "^\s*output14" contained
syn match faderbankOutputParameter "^\s*output15" contained
syn match faderbankOutputParameter "^\s*output16" contained
syn match faderbankOutputParameter "^\s*output2" contained
syn match faderbankOutputParameter "^\s*output3" contained
syn match faderbankOutputParameter "^\s*output4" contained
syn match faderbankOutputParameter "^\s*output5" contained
syn match faderbankOutputParameter "^\s*output6" contained
syn match faderbankOutputParameter "^\s*output7" contained
syn match faderbankOutputParameter "^\s*output8" contained
syn match faderbankOutputParameter "^\s*output9" contained
syn match faderbankInputParameter "^\s*pr" contained
syn match faderbankInputParameter "^\s*preset" contained
syn match faderbankInputParameter "^\s*s" contained
syn match faderbankInputParameter "^\s*sa" contained
syn match faderbankInputParameter "^\s*savepreset" contained
syn match faderbankInputParameter "^\s*select" contained
syn match faderbankInputParameter "^\s*selectat" contained
syn match faderbankInputParameter "^\s*sp" contained
syn match faderbankInputParameter "^\s*startvalue" contained
syn match faderbankInputParameter "^\s*sv" contained
syn match faderbankHeader /\[faderbank\]/ contained
syn region faderbankCircuit start=/\[faderbank\]/ end=/\[/me=s-1 transparent contains=faderbankHeader,faderbankInputParameter,faderbankOutputParameter,ioregister,number,cable,quotestring,comment
hi def link faderbankHeader circuitHeader
hi def link faderbankInputParameter inputParameter
hi def link faderbankOutputParameter outputParameter


" fadermatrix
syn match fadermatrixOutputParameter "^\s*b11" contained
syn match fadermatrixOutputParameter "^\s*b12" contained
syn match fadermatrixOutputParameter "^\s*b13" contained
syn match fadermatrixOutputParameter "^\s*b14" contained
syn match fadermatrixOutputParameter "^\s*b21" contained
syn match fadermatrixOutputParameter "^\s*b22" contained
syn match fadermatrixOutputParameter "^\s*b23" contained
syn match fadermatrixOutputParameter "^\s*b24" contained
syn match fadermatrixOutputParameter "^\s*b31" contained
syn match fadermatrixOutputParameter "^\s*b32" contained
syn match fadermatrixOutputParameter "^\s*b33" contained
syn match fadermatrixOutputParameter "^\s*b34" contained
syn match fadermatrixOutputParameter "^\s*b41" contained
syn match fadermatrixOutputParameter "^\s*b42" contained
syn match fadermatrixOutputParameter "^\s*b43" contained
syn match fadermatrixOutputParameter "^\s*b44" contained
syn match fadermatrixOutputParameter "^\s*button1" contained
syn match fadermatrixOutputParameter "^\s*button11" contained
syn match fadermatrixOutputParameter "^\s*button12" contained
syn match fadermatrixOutputParameter "^\s*button13" contained
syn match fadermatrixOutputParameter "^\s*button14" contained
syn match fadermatrixOutputParameter "^\s*button2" contained
syn match fadermatrixOutputParameter "^\s*button21" contained
syn match fadermatrixOutputParameter "^\s*button22" contained
syn match fadermatrixOutputParameter "^\s*button23" contained
syn match fadermatrixOutputParameter "^\s*button24" contained
syn match fadermatrixOutputParameter "^\s*button3" contained
syn match fadermatrixOutputParameter "^\s*button31" contained
syn match fadermatrixOutputParameter "^\s*button32" contained
syn match fadermatrixOutputParameter "^\s*button33" contained
syn match fadermatrixOutputParameter "^\s*button34" contained
syn match fadermatrixOutputParameter "^\s*button4" contained
syn match fadermatrixOutputParameter "^\s*button41" contained
syn match fadermatrixOutputParameter "^\s*button42" contained
syn match fadermatrixOutputParameter "^\s*button43" contained
syn match fadermatrixOutputParameter "^\s*button44" contained
syn match fadermatrixInputParameter "^\s*ca" contained
syn match fadermatrixInputParameter "^\s*cl" contained
syn match fadermatrixInputParameter "^\s*clear" contained
syn match fadermatrixInputParameter "^\s*clearall" contained
syn match fadermatrixInputParameter "^\s*display" contained
syn match fadermatrixInputParameter "^\s*dontsave" contained
syn match fadermatrixInputParameter "^\s*dos" contained
syn match fadermatrixInputParameter "^\s*dy" contained
syn match fadermatrixInputParameter "^\s*f" contained
syn match fadermatrixInputParameter "^\s*firstfader" contained
syn match fadermatrixInputParameter "^\s*header" contained
syn match fadermatrixInputParameter "^\s*hr" contained
syn match fadermatrixInputParameter "^\s*l11" contained
syn match fadermatrixInputParameter "^\s*l12" contained
syn match fadermatrixInputParameter "^\s*l13" contained
syn match fadermatrixInputParameter "^\s*l14" contained
syn match fadermatrixInputParameter "^\s*l21" contained
syn match fadermatrixInputParameter "^\s*l22" contained
syn match fadermatrixInputParameter "^\s*l23" contained
syn match fadermatrixInputParameter "^\s*l24" contained
syn match fadermatrixInputParameter "^\s*l31" contained
syn match fadermatrixInputParameter "^\s*l32" contained
syn match fadermatrixInputParameter "^\s*l33" contained
syn match fadermatrixInputParameter "^\s*l34" contained
syn match fadermatrixInputParameter "^\s*l41" contained
syn match fadermatrixInputParameter "^\s*l42" contained
syn match fadermatrixInputParameter "^\s*l43" contained
syn match fadermatrixInputParameter "^\s*l44" contained
syn match fadermatrixInputParameter "^\s*lc1" contained
syn match fadermatrixInputParameter "^\s*lc2" contained
syn match fadermatrixInputParameter "^\s*lc3" contained
syn match fadermatrixInputParameter "^\s*lc4" contained
syn match fadermatrixInputParameter "^\s*ledcolor" contained
syn match fadermatrixInputParameter "^\s*ledcolor1" contained
syn match fadermatrixInputParameter "^\s*ledcolor2" contained
syn match fadermatrixInputParameter "^\s*ledcolor3" contained
syn match fadermatrixInputParameter "^\s*ledcolor4" contained
syn match fadermatrixInputParameter "^\s*ledvalue1" contained
syn match fadermatrixInputParameter "^\s*ledvalue11" contained
syn match fadermatrixInputParameter "^\s*ledvalue12" contained
syn match fadermatrixInputParameter "^\s*ledvalue13" contained
syn match fadermatrixInputParameter "^\s*ledvalue14" contained
syn match fadermatrixInputParameter "^\s*ledvalue2" contained
syn match fadermatrixInputParameter "^\s*ledvalue21" contained
syn match fadermatrixInputParameter "^\s*ledvalue22" contained
syn match fadermatrixInputParameter "^\s*ledvalue23" contained
syn match fadermatrixInputParameter "^\s*ledvalue24" contained
syn match fadermatrixInputParameter "^\s*ledvalue3" contained
syn match fadermatrixInputParameter "^\s*ledvalue31" contained
syn match fadermatrixInputParameter "^\s*ledvalue32" contained
syn match fadermatrixInputParameter "^\s*ledvalue33" contained
syn match fadermatrixInputParameter "^\s*ledvalue34" contained
syn match fadermatrixInputParameter "^\s*ledvalue4" contained
syn match fadermatrixInputParameter "^\s*ledvalue41" contained
syn match fadermatrixInputParameter "^\s*ledvalue42" contained
syn match fadermatrixInputParameter "^\s*ledvalue43" contained
syn match fadermatrixInputParameter "^\s*ledvalue44" contained
syn match fadermatrixInputParameter "^\s*loadpreset" contained
syn match fadermatrixInputParameter "^\s*lp" contained
syn match fadermatrixInputParameter "^\s*n1" contained
syn match fadermatrixInputParameter "^\s*n2" contained
syn match fadermatrixInputParameter "^\s*n3" contained
syn match fadermatrixInputParameter "^\s*n4" contained
syn match fadermatrixInputParameter "^\s*notches" contained
syn match fadermatrixInputParameter "^\s*notches1" contained
syn match fadermatrixInputParameter "^\s*notches2" contained
syn match fadermatrixInputParameter "^\s*notches3" contained
syn match fadermatrixInputParameter "^\s*notches4" contained
syn match fadermatrixOutputParameter "^\s*o11" contained
syn match fadermatrixOutputParameter "^\s*o12" contained
syn match fadermatrixOutputParameter "^\s*o13" contained
syn match fadermatrixOutputParameter "^\s*o14" contained
syn match fadermatrixOutputParameter "^\s*o21" contained
syn match fadermatrixOutputParameter "^\s*o22" contained
syn match fadermatrixOutputParameter "^\s*o23" contained
syn match fadermatrixOutputParameter "^\s*o24" contained
syn match fadermatrixOutputParameter "^\s*o31" contained
syn match fadermatrixOutputParameter "^\s*o32" contained
syn match fadermatrixOutputParameter "^\s*o33" contained
syn match fadermatrixOutputParameter "^\s*o34" contained
syn match fadermatrixOutputParameter "^\s*o41" contained
syn match fadermatrixOutputParameter "^\s*o42" contained
syn match fadermatrixOutputParameter "^\s*o43" contained
syn match fadermatrixOutputParameter "^\s*o44" contained
syn match fadermatrixOutputParameter "^\s*output1" contained
syn match fadermatrixOutputParameter "^\s*output11" contained
syn match fadermatrixOutputParameter "^\s*output12" contained
syn match fadermatrixOutputParameter "^\s*output13" contained
syn match fadermatrixOutputParameter "^\s*output14" contained
syn match fadermatrixOutputParameter "^\s*output2" contained
syn match fadermatrixOutputParameter "^\s*output21" contained
syn match fadermatrixOutputParameter "^\s*output22" contained
syn match fadermatrixOutputParameter "^\s*output23" contained
syn match fadermatrixOutputParameter "^\s*output24" contained
syn match fadermatrixOutputParameter "^\s*output3" contained
syn match fadermatrixOutputParameter "^\s*output31" contained
syn match fadermatrixOutputParameter "^\s*output32" contained
syn match fadermatrixOutputParameter "^\s*output33" contained
syn match fadermatrixOutputParameter "^\s*output34" contained
syn match fadermatrixOutputParameter "^\s*output4" contained
syn match fadermatrixOutputParameter "^\s*output41" contained
syn match fadermatrixOutputParameter "^\s*output42" contained
syn match fadermatrixOutputParameter "^\s*output43" contained
syn match fadermatrixOutputParameter "^\s*output44" contained
syn match fadermatrixInputParameter "^\s*pr" contained
syn match fadermatrixInputParameter "^\s*preset" contained
syn match fadermatrixInputParameter "^\s*rc" contained
syn match fadermatrixInputParameter "^\s*rowcolumn" contained
syn match fadermatrixInputParameter "^\s*s" contained
syn match fadermatrixInputParameter "^\s*sa" contained
syn match fadermatrixInputParameter "^\s*savepreset" contained
syn match fadermatrixInputParameter "^\s*select" contained
syn match fadermatrixInputParameter "^\s*selectat" contained
syn match fadermatrixInputParameter "^\s*sp" contained
syn match fadermatrixInputParameter "^\s*startvalue" contained
syn match fadermatrixInputParameter "^\s*startvalue1" contained
syn match fadermatrixInputParameter "^\s*startvalue2" contained
syn match fadermatrixInputParameter "^\s*startvalue3" contained
syn match fadermatrixInputParameter "^\s*startvalue4" contained
syn match fadermatrixInputParameter "^\s*sv1" contained
syn match fadermatrixInputParameter "^\s*sv2" contained
syn match fadermatrixInputParameter "^\s*sv3" contained
syn match fadermatrixInputParameter "^\s*sv4" contained
syn match fadermatrixHeader /\[fadermatrix\]/ contained
syn region fadermatrixCircuit start=/\[fadermatrix\]/ end=/\[/me=s-1 transparent contains=fadermatrixHeader,fadermatrixInputParameter,fadermatrixOutputParameter,ioregister,number,cable,quotestring,comment
hi def link fadermatrixHeader circuitHeader
hi def link fadermatrixInputParameter inputParameter
hi def link fadermatrixOutputParameter outputParameter


" firefacecontrol
syn match firefacecontrolInputParameter "^\s*mainoutput" contained
syn match firefacecontrolInputParameter "^\s*mo" contained
syn match firefacecontrolInputParameter "^\s*o10i1" contained
syn match firefacecontrolInputParameter "^\s*o10i10" contained
syn match firefacecontrolInputParameter "^\s*o10i11" contained
syn match firefacecontrolInputParameter "^\s*o10i12" contained
syn match firefacecontrolInputParameter "^\s*o10i13" contained
syn match firefacecontrolInputParameter "^\s*o10i14" contained
syn match firefacecontrolInputParameter "^\s*o10i15" contained
syn match firefacecontrolInputParameter "^\s*o10i16" contained
syn match firefacecontrolInputParameter "^\s*o10i2" contained
syn match firefacecontrolInputParameter "^\s*o10i3" contained
syn match firefacecontrolInputParameter "^\s*o10i4" contained
syn match firefacecontrolInputParameter "^\s*o10i5" contained
syn match firefacecontrolInputParameter "^\s*o10i6" contained
syn match firefacecontrolInputParameter "^\s*o10i7" contained
syn match firefacecontrolInputParameter "^\s*o10i8" contained
syn match firefacecontrolInputParameter "^\s*o10i9" contained
syn match firefacecontrolInputParameter "^\s*o11i1" contained
syn match firefacecontrolInputParameter "^\s*o11i10" contained
syn match firefacecontrolInputParameter "^\s*o11i11" contained
syn match firefacecontrolInputParameter "^\s*o11i12" contained
syn match firefacecontrolInputParameter "^\s*o11i13" contained
syn match firefacecontrolInputParameter "^\s*o11i14" contained
syn match firefacecontrolInputParameter "^\s*o11i15" contained
syn match firefacecontrolInputParameter "^\s*o11i16" contained
syn match firefacecontrolInputParameter "^\s*o11i2" contained
syn match firefacecontrolInputParameter "^\s*o11i3" contained
syn match firefacecontrolInputParameter "^\s*o11i4" contained
syn match firefacecontrolInputParameter "^\s*o11i5" contained
syn match firefacecontrolInputParameter "^\s*o11i6" contained
syn match firefacecontrolInputParameter "^\s*o11i7" contained
syn match firefacecontrolInputParameter "^\s*o11i8" contained
syn match firefacecontrolInputParameter "^\s*o11i9" contained
syn match firefacecontrolInputParameter "^\s*o12i1" contained
syn match firefacecontrolInputParameter "^\s*o12i10" contained
syn match firefacecontrolInputParameter "^\s*o12i11" contained
syn match firefacecontrolInputParameter "^\s*o12i12" contained
syn match firefacecontrolInputParameter "^\s*o12i13" contained
syn match firefacecontrolInputParameter "^\s*o12i14" contained
syn match firefacecontrolInputParameter "^\s*o12i15" contained
syn match firefacecontrolInputParameter "^\s*o12i16" contained
syn match firefacecontrolInputParameter "^\s*o12i2" contained
syn match firefacecontrolInputParameter "^\s*o12i3" contained
syn match firefacecontrolInputParameter "^\s*o12i4" contained
syn match firefacecontrolInputParameter "^\s*o12i5" contained
syn match firefacecontrolInputParameter "^\s*o12i6" contained
syn match firefacecontrolInputParameter "^\s*o12i7" contained
syn match firefacecontrolInputParameter "^\s*o12i8" contained
syn match firefacecontrolInputParameter "^\s*o12i9" contained
syn match firefacecontrolInputParameter "^\s*o13i1" contained
syn match firefacecontrolInputParameter "^\s*o13i10" contained
syn match firefacecontrolInputParameter "^\s*o13i11" contained
syn match firefacecontrolInputParameter "^\s*o13i12" contained
syn match firefacecontrolInputParameter "^\s*o13i13" contained
syn match firefacecontrolInputParameter "^\s*o13i14" contained
syn match firefacecontrolInputParameter "^\s*o13i15" contained
syn match firefacecontrolInputParameter "^\s*o13i16" contained
syn match firefacecontrolInputParameter "^\s*o13i2" contained
syn match firefacecontrolInputParameter "^\s*o13i3" contained
syn match firefacecontrolInputParameter "^\s*o13i4" contained
syn match firefacecontrolInputParameter "^\s*o13i5" contained
syn match firefacecontrolInputParameter "^\s*o13i6" contained
syn match firefacecontrolInputParameter "^\s*o13i7" contained
syn match firefacecontrolInputParameter "^\s*o13i8" contained
syn match firefacecontrolInputParameter "^\s*o13i9" contained
syn match firefacecontrolInputParameter "^\s*o14i1" contained
syn match firefacecontrolInputParameter "^\s*o14i10" contained
syn match firefacecontrolInputParameter "^\s*o14i11" contained
syn match firefacecontrolInputParameter "^\s*o14i12" contained
syn match firefacecontrolInputParameter "^\s*o14i13" contained
syn match firefacecontrolInputParameter "^\s*o14i14" contained
syn match firefacecontrolInputParameter "^\s*o14i15" contained
syn match firefacecontrolInputParameter "^\s*o14i16" contained
syn match firefacecontrolInputParameter "^\s*o14i2" contained
syn match firefacecontrolInputParameter "^\s*o14i3" contained
syn match firefacecontrolInputParameter "^\s*o14i4" contained
syn match firefacecontrolInputParameter "^\s*o14i5" contained
syn match firefacecontrolInputParameter "^\s*o14i6" contained
syn match firefacecontrolInputParameter "^\s*o14i7" contained
syn match firefacecontrolInputParameter "^\s*o14i8" contained
syn match firefacecontrolInputParameter "^\s*o14i9" contained
syn match firefacecontrolInputParameter "^\s*o15i1" contained
syn match firefacecontrolInputParameter "^\s*o15i10" contained
syn match firefacecontrolInputParameter "^\s*o15i11" contained
syn match firefacecontrolInputParameter "^\s*o15i12" contained
syn match firefacecontrolInputParameter "^\s*o15i13" contained
syn match firefacecontrolInputParameter "^\s*o15i14" contained
syn match firefacecontrolInputParameter "^\s*o15i15" contained
syn match firefacecontrolInputParameter "^\s*o15i16" contained
syn match firefacecontrolInputParameter "^\s*o15i2" contained
syn match firefacecontrolInputParameter "^\s*o15i3" contained
syn match firefacecontrolInputParameter "^\s*o15i4" contained
syn match firefacecontrolInputParameter "^\s*o15i5" contained
syn match firefacecontrolInputParameter "^\s*o15i6" contained
syn match firefacecontrolInputParameter "^\s*o15i7" contained
syn match firefacecontrolInputParameter "^\s*o15i8" contained
syn match firefacecontrolInputParameter "^\s*o15i9" contained
syn match firefacecontrolInputParameter "^\s*o16i1" contained
syn match firefacecontrolInputParameter "^\s*o16i10" contained
syn match firefacecontrolInputParameter "^\s*o16i11" contained
syn match firefacecontrolInputParameter "^\s*o16i12" contained
syn match firefacecontrolInputParameter "^\s*o16i13" contained
syn match firefacecontrolInputParameter "^\s*o16i14" contained
syn match firefacecontrolInputParameter "^\s*o16i15" contained
syn match firefacecontrolInputParameter "^\s*o16i16" contained
syn match firefacecontrolInputParameter "^\s*o16i2" contained
syn match firefacecontrolInputParameter "^\s*o16i3" contained
syn match firefacecontrolInputParameter "^\s*o16i4" contained
syn match firefacecontrolInputParameter "^\s*o16i5" contained
syn match firefacecontrolInputParameter "^\s*o16i6" contained
syn match firefacecontrolInputParameter "^\s*o16i7" contained
syn match firefacecontrolInputParameter "^\s*o16i8" contained
syn match firefacecontrolInputParameter "^\s*o16i9" contained
syn match firefacecontrolInputParameter "^\s*o1i1" contained
syn match firefacecontrolInputParameter "^\s*o1i10" contained
syn match firefacecontrolInputParameter "^\s*o1i11" contained
syn match firefacecontrolInputParameter "^\s*o1i12" contained
syn match firefacecontrolInputParameter "^\s*o1i13" contained
syn match firefacecontrolInputParameter "^\s*o1i14" contained
syn match firefacecontrolInputParameter "^\s*o1i15" contained
syn match firefacecontrolInputParameter "^\s*o1i16" contained
syn match firefacecontrolInputParameter "^\s*o1i2" contained
syn match firefacecontrolInputParameter "^\s*o1i3" contained
syn match firefacecontrolInputParameter "^\s*o1i4" contained
syn match firefacecontrolInputParameter "^\s*o1i5" contained
syn match firefacecontrolInputParameter "^\s*o1i6" contained
syn match firefacecontrolInputParameter "^\s*o1i7" contained
syn match firefacecontrolInputParameter "^\s*o1i8" contained
syn match firefacecontrolInputParameter "^\s*o1i9" contained
syn match firefacecontrolInputParameter "^\s*o2i1" contained
syn match firefacecontrolInputParameter "^\s*o2i10" contained
syn match firefacecontrolInputParameter "^\s*o2i11" contained
syn match firefacecontrolInputParameter "^\s*o2i12" contained
syn match firefacecontrolInputParameter "^\s*o2i13" contained
syn match firefacecontrolInputParameter "^\s*o2i14" contained
syn match firefacecontrolInputParameter "^\s*o2i15" contained
syn match firefacecontrolInputParameter "^\s*o2i16" contained
syn match firefacecontrolInputParameter "^\s*o2i2" contained
syn match firefacecontrolInputParameter "^\s*o2i3" contained
syn match firefacecontrolInputParameter "^\s*o2i4" contained
syn match firefacecontrolInputParameter "^\s*o2i5" contained
syn match firefacecontrolInputParameter "^\s*o2i6" contained
syn match firefacecontrolInputParameter "^\s*o2i7" contained
syn match firefacecontrolInputParameter "^\s*o2i8" contained
syn match firefacecontrolInputParameter "^\s*o2i9" contained
syn match firefacecontrolInputParameter "^\s*o3i1" contained
syn match firefacecontrolInputParameter "^\s*o3i10" contained
syn match firefacecontrolInputParameter "^\s*o3i11" contained
syn match firefacecontrolInputParameter "^\s*o3i12" contained
syn match firefacecontrolInputParameter "^\s*o3i13" contained
syn match firefacecontrolInputParameter "^\s*o3i14" contained
syn match firefacecontrolInputParameter "^\s*o3i15" contained
syn match firefacecontrolInputParameter "^\s*o3i16" contained
syn match firefacecontrolInputParameter "^\s*o3i2" contained
syn match firefacecontrolInputParameter "^\s*o3i3" contained
syn match firefacecontrolInputParameter "^\s*o3i4" contained
syn match firefacecontrolInputParameter "^\s*o3i5" contained
syn match firefacecontrolInputParameter "^\s*o3i6" contained
syn match firefacecontrolInputParameter "^\s*o3i7" contained
syn match firefacecontrolInputParameter "^\s*o3i8" contained
syn match firefacecontrolInputParameter "^\s*o3i9" contained
syn match firefacecontrolInputParameter "^\s*o4i1" contained
syn match firefacecontrolInputParameter "^\s*o4i10" contained
syn match firefacecontrolInputParameter "^\s*o4i11" contained
syn match firefacecontrolInputParameter "^\s*o4i12" contained
syn match firefacecontrolInputParameter "^\s*o4i13" contained
syn match firefacecontrolInputParameter "^\s*o4i14" contained
syn match firefacecontrolInputParameter "^\s*o4i15" contained
syn match firefacecontrolInputParameter "^\s*o4i16" contained
syn match firefacecontrolInputParameter "^\s*o4i2" contained
syn match firefacecontrolInputParameter "^\s*o4i3" contained
syn match firefacecontrolInputParameter "^\s*o4i4" contained
syn match firefacecontrolInputParameter "^\s*o4i5" contained
syn match firefacecontrolInputParameter "^\s*o4i6" contained
syn match firefacecontrolInputParameter "^\s*o4i7" contained
syn match firefacecontrolInputParameter "^\s*o4i8" contained
syn match firefacecontrolInputParameter "^\s*o4i9" contained
syn match firefacecontrolInputParameter "^\s*o5i1" contained
syn match firefacecontrolInputParameter "^\s*o5i10" contained
syn match firefacecontrolInputParameter "^\s*o5i11" contained
syn match firefacecontrolInputParameter "^\s*o5i12" contained
syn match firefacecontrolInputParameter "^\s*o5i13" contained
syn match firefacecontrolInputParameter "^\s*o5i14" contained
syn match firefacecontrolInputParameter "^\s*o5i15" contained
syn match firefacecontrolInputParameter "^\s*o5i16" contained
syn match firefacecontrolInputParameter "^\s*o5i2" contained
syn match firefacecontrolInputParameter "^\s*o5i3" contained
syn match firefacecontrolInputParameter "^\s*o5i4" contained
syn match firefacecontrolInputParameter "^\s*o5i5" contained
syn match firefacecontrolInputParameter "^\s*o5i6" contained
syn match firefacecontrolInputParameter "^\s*o5i7" contained
syn match firefacecontrolInputParameter "^\s*o5i8" contained
syn match firefacecontrolInputParameter "^\s*o5i9" contained
syn match firefacecontrolInputParameter "^\s*o6i1" contained
syn match firefacecontrolInputParameter "^\s*o6i10" contained
syn match firefacecontrolInputParameter "^\s*o6i11" contained
syn match firefacecontrolInputParameter "^\s*o6i12" contained
syn match firefacecontrolInputParameter "^\s*o6i13" contained
syn match firefacecontrolInputParameter "^\s*o6i14" contained
syn match firefacecontrolInputParameter "^\s*o6i15" contained
syn match firefacecontrolInputParameter "^\s*o6i16" contained
syn match firefacecontrolInputParameter "^\s*o6i2" contained
syn match firefacecontrolInputParameter "^\s*o6i3" contained
syn match firefacecontrolInputParameter "^\s*o6i4" contained
syn match firefacecontrolInputParameter "^\s*o6i5" contained
syn match firefacecontrolInputParameter "^\s*o6i6" contained
syn match firefacecontrolInputParameter "^\s*o6i7" contained
syn match firefacecontrolInputParameter "^\s*o6i8" contained
syn match firefacecontrolInputParameter "^\s*o6i9" contained
syn match firefacecontrolInputParameter "^\s*o7i1" contained
syn match firefacecontrolInputParameter "^\s*o7i10" contained
syn match firefacecontrolInputParameter "^\s*o7i11" contained
syn match firefacecontrolInputParameter "^\s*o7i12" contained
syn match firefacecontrolInputParameter "^\s*o7i13" contained
syn match firefacecontrolInputParameter "^\s*o7i14" contained
syn match firefacecontrolInputParameter "^\s*o7i15" contained
syn match firefacecontrolInputParameter "^\s*o7i16" contained
syn match firefacecontrolInputParameter "^\s*o7i2" contained
syn match firefacecontrolInputParameter "^\s*o7i3" contained
syn match firefacecontrolInputParameter "^\s*o7i4" contained
syn match firefacecontrolInputParameter "^\s*o7i5" contained
syn match firefacecontrolInputParameter "^\s*o7i6" contained
syn match firefacecontrolInputParameter "^\s*o7i7" contained
syn match firefacecontrolInputParameter "^\s*o7i8" contained
syn match firefacecontrolInputParameter "^\s*o7i9" contained
syn match firefacecontrolInputParameter "^\s*o8i1" contained
syn match firefacecontrolInputParameter "^\s*o8i10" contained
syn match firefacecontrolInputParameter "^\s*o8i11" contained
syn match firefacecontrolInputParameter "^\s*o8i12" contained
syn match firefacecontrolInputParameter "^\s*o8i13" contained
syn match firefacecontrolInputParameter "^\s*o8i14" contained
syn match firefacecontrolInputParameter "^\s*o8i15" contained
syn match firefacecontrolInputParameter "^\s*o8i16" contained
syn match firefacecontrolInputParameter "^\s*o8i2" contained
syn match firefacecontrolInputParameter "^\s*o8i3" contained
syn match firefacecontrolInputParameter "^\s*o8i4" contained
syn match firefacecontrolInputParameter "^\s*o8i5" contained
syn match firefacecontrolInputParameter "^\s*o8i6" contained
syn match firefacecontrolInputParameter "^\s*o8i7" contained
syn match firefacecontrolInputParameter "^\s*o8i8" contained
syn match firefacecontrolInputParameter "^\s*o8i9" contained
syn match firefacecontrolInputParameter "^\s*o9i1" contained
syn match firefacecontrolInputParameter "^\s*o9i10" contained
syn match firefacecontrolInputParameter "^\s*o9i11" contained
syn match firefacecontrolInputParameter "^\s*o9i12" contained
syn match firefacecontrolInputParameter "^\s*o9i13" contained
syn match firefacecontrolInputParameter "^\s*o9i14" contained
syn match firefacecontrolInputParameter "^\s*o9i15" contained
syn match firefacecontrolInputParameter "^\s*o9i16" contained
syn match firefacecontrolInputParameter "^\s*o9i2" contained
syn match firefacecontrolInputParameter "^\s*o9i3" contained
syn match firefacecontrolInputParameter "^\s*o9i4" contained
syn match firefacecontrolInputParameter "^\s*o9i5" contained
syn match firefacecontrolInputParameter "^\s*o9i6" contained
syn match firefacecontrolInputParameter "^\s*o9i7" contained
syn match firefacecontrolInputParameter "^\s*o9i8" contained
syn match firefacecontrolInputParameter "^\s*o9i9" contained
syn match firefacecontrolInputParameter "^\s*ol1" contained
syn match firefacecontrolInputParameter "^\s*ol10" contained
syn match firefacecontrolInputParameter "^\s*ol11" contained
syn match firefacecontrolInputParameter "^\s*ol12" contained
syn match firefacecontrolInputParameter "^\s*ol13" contained
syn match firefacecontrolInputParameter "^\s*ol14" contained
syn match firefacecontrolInputParameter "^\s*ol15" contained
syn match firefacecontrolInputParameter "^\s*ol16" contained
syn match firefacecontrolInputParameter "^\s*ol2" contained
syn match firefacecontrolInputParameter "^\s*ol3" contained
syn match firefacecontrolInputParameter "^\s*ol4" contained
syn match firefacecontrolInputParameter "^\s*ol5" contained
syn match firefacecontrolInputParameter "^\s*ol6" contained
syn match firefacecontrolInputParameter "^\s*ol7" contained
syn match firefacecontrolInputParameter "^\s*ol8" contained
syn match firefacecontrolInputParameter "^\s*ol9" contained
syn match firefacecontrolInputParameter "^\s*outputlevel" contained
syn match firefacecontrolInputParameter "^\s*outputlevel1" contained
syn match firefacecontrolInputParameter "^\s*outputlevel10" contained
syn match firefacecontrolInputParameter "^\s*outputlevel11" contained
syn match firefacecontrolInputParameter "^\s*outputlevel12" contained
syn match firefacecontrolInputParameter "^\s*outputlevel13" contained
syn match firefacecontrolInputParameter "^\s*outputlevel14" contained
syn match firefacecontrolInputParameter "^\s*outputlevel15" contained
syn match firefacecontrolInputParameter "^\s*outputlevel16" contained
syn match firefacecontrolInputParameter "^\s*outputlevel2" contained
syn match firefacecontrolInputParameter "^\s*outputlevel3" contained
syn match firefacecontrolInputParameter "^\s*outputlevel4" contained
syn match firefacecontrolInputParameter "^\s*outputlevel5" contained
syn match firefacecontrolInputParameter "^\s*outputlevel6" contained
syn match firefacecontrolInputParameter "^\s*outputlevel7" contained
syn match firefacecontrolInputParameter "^\s*outputlevel8" contained
syn match firefacecontrolInputParameter "^\s*outputlevel9" contained
syn match firefacecontrolInputParameter "^\s*outputmix10in" contained
syn match firefacecontrolInputParameter "^\s*outputmix10in1" contained
syn match firefacecontrolInputParameter "^\s*outputmix10in10" contained
syn match firefacecontrolInputParameter "^\s*outputmix10in11" contained
syn match firefacecontrolInputParameter "^\s*outputmix10in12" contained
syn match firefacecontrolInputParameter "^\s*outputmix10in13" contained
syn match firefacecontrolInputParameter "^\s*outputmix10in14" contained
syn match firefacecontrolInputParameter "^\s*outputmix10in15" contained
syn match firefacecontrolInputParameter "^\s*outputmix10in16" contained
syn match firefacecontrolInputParameter "^\s*outputmix10in2" contained
syn match firefacecontrolInputParameter "^\s*outputmix10in3" contained
syn match firefacecontrolInputParameter "^\s*outputmix10in4" contained
syn match firefacecontrolInputParameter "^\s*outputmix10in5" contained
syn match firefacecontrolInputParameter "^\s*outputmix10in6" contained
syn match firefacecontrolInputParameter "^\s*outputmix10in7" contained
syn match firefacecontrolInputParameter "^\s*outputmix10in8" contained
syn match firefacecontrolInputParameter "^\s*outputmix10in9" contained
syn match firefacecontrolInputParameter "^\s*outputmix11in" contained
syn match firefacecontrolInputParameter "^\s*outputmix11in1" contained
syn match firefacecontrolInputParameter "^\s*outputmix11in10" contained
syn match firefacecontrolInputParameter "^\s*outputmix11in11" contained
syn match firefacecontrolInputParameter "^\s*outputmix11in12" contained
syn match firefacecontrolInputParameter "^\s*outputmix11in13" contained
syn match firefacecontrolInputParameter "^\s*outputmix11in14" contained
syn match firefacecontrolInputParameter "^\s*outputmix11in15" contained
syn match firefacecontrolInputParameter "^\s*outputmix11in16" contained
syn match firefacecontrolInputParameter "^\s*outputmix11in2" contained
syn match firefacecontrolInputParameter "^\s*outputmix11in3" contained
syn match firefacecontrolInputParameter "^\s*outputmix11in4" contained
syn match firefacecontrolInputParameter "^\s*outputmix11in5" contained
syn match firefacecontrolInputParameter "^\s*outputmix11in6" contained
syn match firefacecontrolInputParameter "^\s*outputmix11in7" contained
syn match firefacecontrolInputParameter "^\s*outputmix11in8" contained
syn match firefacecontrolInputParameter "^\s*outputmix11in9" contained
syn match firefacecontrolInputParameter "^\s*outputmix12in" contained
syn match firefacecontrolInputParameter "^\s*outputmix12in1" contained
syn match firefacecontrolInputParameter "^\s*outputmix12in10" contained
syn match firefacecontrolInputParameter "^\s*outputmix12in11" contained
syn match firefacecontrolInputParameter "^\s*outputmix12in12" contained
syn match firefacecontrolInputParameter "^\s*outputmix12in13" contained
syn match firefacecontrolInputParameter "^\s*outputmix12in14" contained
syn match firefacecontrolInputParameter "^\s*outputmix12in15" contained
syn match firefacecontrolInputParameter "^\s*outputmix12in16" contained
syn match firefacecontrolInputParameter "^\s*outputmix12in2" contained
syn match firefacecontrolInputParameter "^\s*outputmix12in3" contained
syn match firefacecontrolInputParameter "^\s*outputmix12in4" contained
syn match firefacecontrolInputParameter "^\s*outputmix12in5" contained
syn match firefacecontrolInputParameter "^\s*outputmix12in6" contained
syn match firefacecontrolInputParameter "^\s*outputmix12in7" contained
syn match firefacecontrolInputParameter "^\s*outputmix12in8" contained
syn match firefacecontrolInputParameter "^\s*outputmix12in9" contained
syn match firefacecontrolInputParameter "^\s*outputmix13in" contained
syn match firefacecontrolInputParameter "^\s*outputmix13in1" contained
syn match firefacecontrolInputParameter "^\s*outputmix13in10" contained
syn match firefacecontrolInputParameter "^\s*outputmix13in11" contained
syn match firefacecontrolInputParameter "^\s*outputmix13in12" contained
syn match firefacecontrolInputParameter "^\s*outputmix13in13" contained
syn match firefacecontrolInputParameter "^\s*outputmix13in14" contained
syn match firefacecontrolInputParameter "^\s*outputmix13in15" contained
syn match firefacecontrolInputParameter "^\s*outputmix13in16" contained
syn match firefacecontrolInputParameter "^\s*outputmix13in2" contained
syn match firefacecontrolInputParameter "^\s*outputmix13in3" contained
syn match firefacecontrolInputParameter "^\s*outputmix13in4" contained
syn match firefacecontrolInputParameter "^\s*outputmix13in5" contained
syn match firefacecontrolInputParameter "^\s*outputmix13in6" contained
syn match firefacecontrolInputParameter "^\s*outputmix13in7" contained
syn match firefacecontrolInputParameter "^\s*outputmix13in8" contained
syn match firefacecontrolInputParameter "^\s*outputmix13in9" contained
syn match firefacecontrolInputParameter "^\s*outputmix14in" contained
syn match firefacecontrolInputParameter "^\s*outputmix14in1" contained
syn match firefacecontrolInputParameter "^\s*outputmix14in10" contained
syn match firefacecontrolInputParameter "^\s*outputmix14in11" contained
syn match firefacecontrolInputParameter "^\s*outputmix14in12" contained
syn match firefacecontrolInputParameter "^\s*outputmix14in13" contained
syn match firefacecontrolInputParameter "^\s*outputmix14in14" contained
syn match firefacecontrolInputParameter "^\s*outputmix14in15" contained
syn match firefacecontrolInputParameter "^\s*outputmix14in16" contained
syn match firefacecontrolInputParameter "^\s*outputmix14in2" contained
syn match firefacecontrolInputParameter "^\s*outputmix14in3" contained
syn match firefacecontrolInputParameter "^\s*outputmix14in4" contained
syn match firefacecontrolInputParameter "^\s*outputmix14in5" contained
syn match firefacecontrolInputParameter "^\s*outputmix14in6" contained
syn match firefacecontrolInputParameter "^\s*outputmix14in7" contained
syn match firefacecontrolInputParameter "^\s*outputmix14in8" contained
syn match firefacecontrolInputParameter "^\s*outputmix14in9" contained
syn match firefacecontrolInputParameter "^\s*outputmix15in" contained
syn match firefacecontrolInputParameter "^\s*outputmix15in1" contained
syn match firefacecontrolInputParameter "^\s*outputmix15in10" contained
syn match firefacecontrolInputParameter "^\s*outputmix15in11" contained
syn match firefacecontrolInputParameter "^\s*outputmix15in12" contained
syn match firefacecontrolInputParameter "^\s*outputmix15in13" contained
syn match firefacecontrolInputParameter "^\s*outputmix15in14" contained
syn match firefacecontrolInputParameter "^\s*outputmix15in15" contained
syn match firefacecontrolInputParameter "^\s*outputmix15in16" contained
syn match firefacecontrolInputParameter "^\s*outputmix15in2" contained
syn match firefacecontrolInputParameter "^\s*outputmix15in3" contained
syn match firefacecontrolInputParameter "^\s*outputmix15in4" contained
syn match firefacecontrolInputParameter "^\s*outputmix15in5" contained
syn match firefacecontrolInputParameter "^\s*outputmix15in6" contained
syn match firefacecontrolInputParameter "^\s*outputmix15in7" contained
syn match firefacecontrolInputParameter "^\s*outputmix15in8" contained
syn match firefacecontrolInputParameter "^\s*outputmix15in9" contained
syn match firefacecontrolInputParameter "^\s*outputmix16in" contained
syn match firefacecontrolInputParameter "^\s*outputmix16in1" contained
syn match firefacecontrolInputParameter "^\s*outputmix16in10" contained
syn match firefacecontrolInputParameter "^\s*outputmix16in11" contained
syn match firefacecontrolInputParameter "^\s*outputmix16in12" contained
syn match firefacecontrolInputParameter "^\s*outputmix16in13" contained
syn match firefacecontrolInputParameter "^\s*outputmix16in14" contained
syn match firefacecontrolInputParameter "^\s*outputmix16in15" contained
syn match firefacecontrolInputParameter "^\s*outputmix16in16" contained
syn match firefacecontrolInputParameter "^\s*outputmix16in2" contained
syn match firefacecontrolInputParameter "^\s*outputmix16in3" contained
syn match firefacecontrolInputParameter "^\s*outputmix16in4" contained
syn match firefacecontrolInputParameter "^\s*outputmix16in5" contained
syn match firefacecontrolInputParameter "^\s*outputmix16in6" contained
syn match firefacecontrolInputParameter "^\s*outputmix16in7" contained
syn match firefacecontrolInputParameter "^\s*outputmix16in8" contained
syn match firefacecontrolInputParameter "^\s*outputmix16in9" contained
syn match firefacecontrolInputParameter "^\s*outputmix1in" contained
syn match firefacecontrolInputParameter "^\s*outputmix1in1" contained
syn match firefacecontrolInputParameter "^\s*outputmix1in10" contained
syn match firefacecontrolInputParameter "^\s*outputmix1in11" contained
syn match firefacecontrolInputParameter "^\s*outputmix1in12" contained
syn match firefacecontrolInputParameter "^\s*outputmix1in13" contained
syn match firefacecontrolInputParameter "^\s*outputmix1in14" contained
syn match firefacecontrolInputParameter "^\s*outputmix1in15" contained
syn match firefacecontrolInputParameter "^\s*outputmix1in16" contained
syn match firefacecontrolInputParameter "^\s*outputmix1in2" contained
syn match firefacecontrolInputParameter "^\s*outputmix1in3" contained
syn match firefacecontrolInputParameter "^\s*outputmix1in4" contained
syn match firefacecontrolInputParameter "^\s*outputmix1in5" contained
syn match firefacecontrolInputParameter "^\s*outputmix1in6" contained
syn match firefacecontrolInputParameter "^\s*outputmix1in7" contained
syn match firefacecontrolInputParameter "^\s*outputmix1in8" contained
syn match firefacecontrolInputParameter "^\s*outputmix1in9" contained
syn match firefacecontrolInputParameter "^\s*outputmix2in" contained
syn match firefacecontrolInputParameter "^\s*outputmix2in1" contained
syn match firefacecontrolInputParameter "^\s*outputmix2in10" contained
syn match firefacecontrolInputParameter "^\s*outputmix2in11" contained
syn match firefacecontrolInputParameter "^\s*outputmix2in12" contained
syn match firefacecontrolInputParameter "^\s*outputmix2in13" contained
syn match firefacecontrolInputParameter "^\s*outputmix2in14" contained
syn match firefacecontrolInputParameter "^\s*outputmix2in15" contained
syn match firefacecontrolInputParameter "^\s*outputmix2in16" contained
syn match firefacecontrolInputParameter "^\s*outputmix2in2" contained
syn match firefacecontrolInputParameter "^\s*outputmix2in3" contained
syn match firefacecontrolInputParameter "^\s*outputmix2in4" contained
syn match firefacecontrolInputParameter "^\s*outputmix2in5" contained
syn match firefacecontrolInputParameter "^\s*outputmix2in6" contained
syn match firefacecontrolInputParameter "^\s*outputmix2in7" contained
syn match firefacecontrolInputParameter "^\s*outputmix2in8" contained
syn match firefacecontrolInputParameter "^\s*outputmix2in9" contained
syn match firefacecontrolInputParameter "^\s*outputmix3in" contained
syn match firefacecontrolInputParameter "^\s*outputmix3in1" contained
syn match firefacecontrolInputParameter "^\s*outputmix3in10" contained
syn match firefacecontrolInputParameter "^\s*outputmix3in11" contained
syn match firefacecontrolInputParameter "^\s*outputmix3in12" contained
syn match firefacecontrolInputParameter "^\s*outputmix3in13" contained
syn match firefacecontrolInputParameter "^\s*outputmix3in14" contained
syn match firefacecontrolInputParameter "^\s*outputmix3in15" contained
syn match firefacecontrolInputParameter "^\s*outputmix3in16" contained
syn match firefacecontrolInputParameter "^\s*outputmix3in2" contained
syn match firefacecontrolInputParameter "^\s*outputmix3in3" contained
syn match firefacecontrolInputParameter "^\s*outputmix3in4" contained
syn match firefacecontrolInputParameter "^\s*outputmix3in5" contained
syn match firefacecontrolInputParameter "^\s*outputmix3in6" contained
syn match firefacecontrolInputParameter "^\s*outputmix3in7" contained
syn match firefacecontrolInputParameter "^\s*outputmix3in8" contained
syn match firefacecontrolInputParameter "^\s*outputmix3in9" contained
syn match firefacecontrolInputParameter "^\s*outputmix4in" contained
syn match firefacecontrolInputParameter "^\s*outputmix4in1" contained
syn match firefacecontrolInputParameter "^\s*outputmix4in10" contained
syn match firefacecontrolInputParameter "^\s*outputmix4in11" contained
syn match firefacecontrolInputParameter "^\s*outputmix4in12" contained
syn match firefacecontrolInputParameter "^\s*outputmix4in13" contained
syn match firefacecontrolInputParameter "^\s*outputmix4in14" contained
syn match firefacecontrolInputParameter "^\s*outputmix4in15" contained
syn match firefacecontrolInputParameter "^\s*outputmix4in16" contained
syn match firefacecontrolInputParameter "^\s*outputmix4in2" contained
syn match firefacecontrolInputParameter "^\s*outputmix4in3" contained
syn match firefacecontrolInputParameter "^\s*outputmix4in4" contained
syn match firefacecontrolInputParameter "^\s*outputmix4in5" contained
syn match firefacecontrolInputParameter "^\s*outputmix4in6" contained
syn match firefacecontrolInputParameter "^\s*outputmix4in7" contained
syn match firefacecontrolInputParameter "^\s*outputmix4in8" contained
syn match firefacecontrolInputParameter "^\s*outputmix4in9" contained
syn match firefacecontrolInputParameter "^\s*outputmix5in" contained
syn match firefacecontrolInputParameter "^\s*outputmix5in1" contained
syn match firefacecontrolInputParameter "^\s*outputmix5in10" contained
syn match firefacecontrolInputParameter "^\s*outputmix5in11" contained
syn match firefacecontrolInputParameter "^\s*outputmix5in12" contained
syn match firefacecontrolInputParameter "^\s*outputmix5in13" contained
syn match firefacecontrolInputParameter "^\s*outputmix5in14" contained
syn match firefacecontrolInputParameter "^\s*outputmix5in15" contained
syn match firefacecontrolInputParameter "^\s*outputmix5in16" contained
syn match firefacecontrolInputParameter "^\s*outputmix5in2" contained
syn match firefacecontrolInputParameter "^\s*outputmix5in3" contained
syn match firefacecontrolInputParameter "^\s*outputmix5in4" contained
syn match firefacecontrolInputParameter "^\s*outputmix5in5" contained
syn match firefacecontrolInputParameter "^\s*outputmix5in6" contained
syn match firefacecontrolInputParameter "^\s*outputmix5in7" contained
syn match firefacecontrolInputParameter "^\s*outputmix5in8" contained
syn match firefacecontrolInputParameter "^\s*outputmix5in9" contained
syn match firefacecontrolInputParameter "^\s*outputmix6in" contained
syn match firefacecontrolInputParameter "^\s*outputmix6in1" contained
syn match firefacecontrolInputParameter "^\s*outputmix6in10" contained
syn match firefacecontrolInputParameter "^\s*outputmix6in11" contained
syn match firefacecontrolInputParameter "^\s*outputmix6in12" contained
syn match firefacecontrolInputParameter "^\s*outputmix6in13" contained
syn match firefacecontrolInputParameter "^\s*outputmix6in14" contained
syn match firefacecontrolInputParameter "^\s*outputmix6in15" contained
syn match firefacecontrolInputParameter "^\s*outputmix6in16" contained
syn match firefacecontrolInputParameter "^\s*outputmix6in2" contained
syn match firefacecontrolInputParameter "^\s*outputmix6in3" contained
syn match firefacecontrolInputParameter "^\s*outputmix6in4" contained
syn match firefacecontrolInputParameter "^\s*outputmix6in5" contained
syn match firefacecontrolInputParameter "^\s*outputmix6in6" contained
syn match firefacecontrolInputParameter "^\s*outputmix6in7" contained
syn match firefacecontrolInputParameter "^\s*outputmix6in8" contained
syn match firefacecontrolInputParameter "^\s*outputmix6in9" contained
syn match firefacecontrolInputParameter "^\s*outputmix7in" contained
syn match firefacecontrolInputParameter "^\s*outputmix7in1" contained
syn match firefacecontrolInputParameter "^\s*outputmix7in10" contained
syn match firefacecontrolInputParameter "^\s*outputmix7in11" contained
syn match firefacecontrolInputParameter "^\s*outputmix7in12" contained
syn match firefacecontrolInputParameter "^\s*outputmix7in13" contained
syn match firefacecontrolInputParameter "^\s*outputmix7in14" contained
syn match firefacecontrolInputParameter "^\s*outputmix7in15" contained
syn match firefacecontrolInputParameter "^\s*outputmix7in16" contained
syn match firefacecontrolInputParameter "^\s*outputmix7in2" contained
syn match firefacecontrolInputParameter "^\s*outputmix7in3" contained
syn match firefacecontrolInputParameter "^\s*outputmix7in4" contained
syn match firefacecontrolInputParameter "^\s*outputmix7in5" contained
syn match firefacecontrolInputParameter "^\s*outputmix7in6" contained
syn match firefacecontrolInputParameter "^\s*outputmix7in7" contained
syn match firefacecontrolInputParameter "^\s*outputmix7in8" contained
syn match firefacecontrolInputParameter "^\s*outputmix7in9" contained
syn match firefacecontrolInputParameter "^\s*outputmix8in" contained
syn match firefacecontrolInputParameter "^\s*outputmix8in1" contained
syn match firefacecontrolInputParameter "^\s*outputmix8in10" contained
syn match firefacecontrolInputParameter "^\s*outputmix8in11" contained
syn match firefacecontrolInputParameter "^\s*outputmix8in12" contained
syn match firefacecontrolInputParameter "^\s*outputmix8in13" contained
syn match firefacecontrolInputParameter "^\s*outputmix8in14" contained
syn match firefacecontrolInputParameter "^\s*outputmix8in15" contained
syn match firefacecontrolInputParameter "^\s*outputmix8in16" contained
syn match firefacecontrolInputParameter "^\s*outputmix8in2" contained
syn match firefacecontrolInputParameter "^\s*outputmix8in3" contained
syn match firefacecontrolInputParameter "^\s*outputmix8in4" contained
syn match firefacecontrolInputParameter "^\s*outputmix8in5" contained
syn match firefacecontrolInputParameter "^\s*outputmix8in6" contained
syn match firefacecontrolInputParameter "^\s*outputmix8in7" contained
syn match firefacecontrolInputParameter "^\s*outputmix8in8" contained
syn match firefacecontrolInputParameter "^\s*outputmix8in9" contained
syn match firefacecontrolInputParameter "^\s*outputmix9in" contained
syn match firefacecontrolInputParameter "^\s*outputmix9in1" contained
syn match firefacecontrolInputParameter "^\s*outputmix9in10" contained
syn match firefacecontrolInputParameter "^\s*outputmix9in11" contained
syn match firefacecontrolInputParameter "^\s*outputmix9in12" contained
syn match firefacecontrolInputParameter "^\s*outputmix9in13" contained
syn match firefacecontrolInputParameter "^\s*outputmix9in14" contained
syn match firefacecontrolInputParameter "^\s*outputmix9in15" contained
syn match firefacecontrolInputParameter "^\s*outputmix9in16" contained
syn match firefacecontrolInputParameter "^\s*outputmix9in2" contained
syn match firefacecontrolInputParameter "^\s*outputmix9in3" contained
syn match firefacecontrolInputParameter "^\s*outputmix9in4" contained
syn match firefacecontrolInputParameter "^\s*outputmix9in5" contained
syn match firefacecontrolInputParameter "^\s*outputmix9in6" contained
syn match firefacecontrolInputParameter "^\s*outputmix9in7" contained
syn match firefacecontrolInputParameter "^\s*outputmix9in8" contained
syn match firefacecontrolInputParameter "^\s*outputmix9in9" contained
syn match firefacecontrolInputParameter "^\s*p1" contained
syn match firefacecontrolInputParameter "^\s*p10" contained
syn match firefacecontrolInputParameter "^\s*p11" contained
syn match firefacecontrolInputParameter "^\s*p12" contained
syn match firefacecontrolInputParameter "^\s*p13" contained
syn match firefacecontrolInputParameter "^\s*p14" contained
syn match firefacecontrolInputParameter "^\s*p15" contained
syn match firefacecontrolInputParameter "^\s*p16" contained
syn match firefacecontrolInputParameter "^\s*p2" contained
syn match firefacecontrolInputParameter "^\s*p3" contained
syn match firefacecontrolInputParameter "^\s*p4" contained
syn match firefacecontrolInputParameter "^\s*p5" contained
syn match firefacecontrolInputParameter "^\s*p6" contained
syn match firefacecontrolInputParameter "^\s*p7" contained
syn match firefacecontrolInputParameter "^\s*p8" contained
syn match firefacecontrolInputParameter "^\s*p9" contained
syn match firefacecontrolInputParameter "^\s*pan" contained
syn match firefacecontrolInputParameter "^\s*pan1" contained
syn match firefacecontrolInputParameter "^\s*pan10" contained
syn match firefacecontrolInputParameter "^\s*pan11" contained
syn match firefacecontrolInputParameter "^\s*pan12" contained
syn match firefacecontrolInputParameter "^\s*pan13" contained
syn match firefacecontrolInputParameter "^\s*pan14" contained
syn match firefacecontrolInputParameter "^\s*pan15" contained
syn match firefacecontrolInputParameter "^\s*pan16" contained
syn match firefacecontrolInputParameter "^\s*pan2" contained
syn match firefacecontrolInputParameter "^\s*pan3" contained
syn match firefacecontrolInputParameter "^\s*pan4" contained
syn match firefacecontrolInputParameter "^\s*pan5" contained
syn match firefacecontrolInputParameter "^\s*pan6" contained
syn match firefacecontrolInputParameter "^\s*pan7" contained
syn match firefacecontrolInputParameter "^\s*pan8" contained
syn match firefacecontrolInputParameter "^\s*pan9" contained
syn match firefacecontrolInputParameter "^\s*pf1" contained
syn match firefacecontrolInputParameter "^\s*pf10" contained
syn match firefacecontrolInputParameter "^\s*pf11" contained
syn match firefacecontrolInputParameter "^\s*pf12" contained
syn match firefacecontrolInputParameter "^\s*pf13" contained
syn match firefacecontrolInputParameter "^\s*pf14" contained
syn match firefacecontrolInputParameter "^\s*pf15" contained
syn match firefacecontrolInputParameter "^\s*pf16" contained
syn match firefacecontrolInputParameter "^\s*pf2" contained
syn match firefacecontrolInputParameter "^\s*pf3" contained
syn match firefacecontrolInputParameter "^\s*pf4" contained
syn match firefacecontrolInputParameter "^\s*pf5" contained
syn match firefacecontrolInputParameter "^\s*pf6" contained
syn match firefacecontrolInputParameter "^\s*pf7" contained
syn match firefacecontrolInputParameter "^\s*pf8" contained
syn match firefacecontrolInputParameter "^\s*pf9" contained
syn match firefacecontrolInputParameter "^\s*phonesoutput" contained
syn match firefacecontrolInputParameter "^\s*phonesoutput1" contained
syn match firefacecontrolInputParameter "^\s*phonesoutput2" contained
syn match firefacecontrolInputParameter "^\s*po1" contained
syn match firefacecontrolInputParameter "^\s*po2" contained
syn match firefacecontrolInputParameter "^\s*postfader" contained
syn match firefacecontrolInputParameter "^\s*postfader1" contained
syn match firefacecontrolInputParameter "^\s*postfader10" contained
syn match firefacecontrolInputParameter "^\s*postfader11" contained
syn match firefacecontrolInputParameter "^\s*postfader12" contained
syn match firefacecontrolInputParameter "^\s*postfader13" contained
syn match firefacecontrolInputParameter "^\s*postfader14" contained
syn match firefacecontrolInputParameter "^\s*postfader15" contained
syn match firefacecontrolInputParameter "^\s*postfader16" contained
syn match firefacecontrolInputParameter "^\s*postfader2" contained
syn match firefacecontrolInputParameter "^\s*postfader3" contained
syn match firefacecontrolInputParameter "^\s*postfader4" contained
syn match firefacecontrolInputParameter "^\s*postfader5" contained
syn match firefacecontrolInputParameter "^\s*postfader6" contained
syn match firefacecontrolInputParameter "^\s*postfader7" contained
syn match firefacecontrolInputParameter "^\s*postfader8" contained
syn match firefacecontrolInputParameter "^\s*postfader9" contained
syn match firefacecontrolInputParameter "^\s*s" contained
syn match firefacecontrolInputParameter "^\s*sa" contained
syn match firefacecontrolInputParameter "^\s*select" contained
syn match firefacecontrolInputParameter "^\s*selectat" contained
syn match firefacecontrolInputParameter "^\s*trs" contained
syn match firefacecontrolInputParameter "^\s*u1" contained
syn match firefacecontrolInputParameter "^\s*u10" contained
syn match firefacecontrolInputParameter "^\s*u11" contained
syn match firefacecontrolInputParameter "^\s*u12" contained
syn match firefacecontrolInputParameter "^\s*u13" contained
syn match firefacecontrolInputParameter "^\s*u14" contained
syn match firefacecontrolInputParameter "^\s*u15" contained
syn match firefacecontrolInputParameter "^\s*u16" contained
syn match firefacecontrolInputParameter "^\s*u2" contained
syn match firefacecontrolInputParameter "^\s*u3" contained
syn match firefacecontrolInputParameter "^\s*u4" contained
syn match firefacecontrolInputParameter "^\s*u5" contained
syn match firefacecontrolInputParameter "^\s*u6" contained
syn match firefacecontrolInputParameter "^\s*u7" contained
syn match firefacecontrolInputParameter "^\s*u8" contained
syn match firefacecontrolInputParameter "^\s*u9" contained
syn match firefacecontrolInputParameter "^\s*ud" contained
syn match firefacecontrolInputParameter "^\s*unmute" contained
syn match firefacecontrolInputParameter "^\s*unmute1" contained
syn match firefacecontrolInputParameter "^\s*unmute10" contained
syn match firefacecontrolInputParameter "^\s*unmute11" contained
syn match firefacecontrolInputParameter "^\s*unmute12" contained
syn match firefacecontrolInputParameter "^\s*unmute13" contained
syn match firefacecontrolInputParameter "^\s*unmute14" contained
syn match firefacecontrolInputParameter "^\s*unmute15" contained
syn match firefacecontrolInputParameter "^\s*unmute16" contained
syn match firefacecontrolInputParameter "^\s*unmute2" contained
syn match firefacecontrolInputParameter "^\s*unmute3" contained
syn match firefacecontrolInputParameter "^\s*unmute4" contained
syn match firefacecontrolInputParameter "^\s*unmute5" contained
syn match firefacecontrolInputParameter "^\s*unmute6" contained
syn match firefacecontrolInputParameter "^\s*unmute7" contained
syn match firefacecontrolInputParameter "^\s*unmute8" contained
syn match firefacecontrolInputParameter "^\s*unmute9" contained
syn match firefacecontrolInputParameter "^\s*update" contained
syn match firefacecontrolHeader /\[firefacecontrol\]/ contained
syn region firefacecontrolCircuit start=/\[firefacecontrol\]/ end=/\[/me=s-1 transparent contains=firefacecontrolHeader,firefacecontrolInputParameter,firefacecontrolOutputParameter,ioregister,number,cable,quotestring,comment
hi def link firefacecontrolHeader circuitHeader
hi def link firefacecontrolInputParameter inputParameter
hi def link firefacecontrolOutputParameter outputParameter


" flipflop
syn match flipflopInputParameter "^\s*cl" contained
syn match flipflopInputParameter "^\s*clear" contained
syn match flipflopInputParameter "^\s*ld" contained
syn match flipflopInputParameter "^\s*load" contained
syn match flipflopInputParameter "^\s*loadvalue" contained
syn match flipflopInputParameter "^\s*lv" contained
syn match flipflopOutputParameter "^\s*o" contained
syn match flipflopOutputParameter "^\s*output" contained
syn match flipflopInputParameter "^\s*r" contained
syn match flipflopInputParameter "^\s*reset" contained
syn match flipflopInputParameter "^\s*s" contained
syn match flipflopInputParameter "^\s*set" contained
syn match flipflopInputParameter "^\s*startvalue" contained
syn match flipflopInputParameter "^\s*sv" contained
syn match flipflopInputParameter "^\s*t" contained
syn match flipflopInputParameter "^\s*toggle" contained
syn match flipflopHeader /\[flipflop\]/ contained
syn region flipflopCircuit start=/\[flipflop\]/ end=/\[/me=s-1 transparent contains=flipflopHeader,flipflopInputParameter,flipflopOutputParameter,ioregister,number,cable,quotestring,comment
hi def link flipflopHeader circuitHeader
hi def link flipflopInputParameter inputParameter
hi def link flipflopOutputParameter outputParameter


" fold
syn match foldInputParameter "^\s*f" contained
syn match foldInputParameter "^\s*foldby" contained
syn match foldInputParameter "^\s*i" contained
syn match foldInputParameter "^\s*input" contained
syn match foldInputParameter "^\s*m" contained
syn match foldInputParameter "^\s*maximum" contained
syn match foldInputParameter "^\s*minimum" contained
syn match foldOutputParameter "^\s*o" contained
syn match foldOutputParameter "^\s*output" contained
syn match foldInputParameter "^\s*x" contained
syn match foldHeader /\[fold\]/ contained
syn region foldCircuit start=/\[fold\]/ end=/\[/me=s-1 transparent contains=foldHeader,foldInputParameter,foldOutputParameter,ioregister,number,cable,quotestring,comment
hi def link foldHeader circuitHeader
hi def link foldInputParameter inputParameter
hi def link foldOutputParameter outputParameter


" fourstatebutton
syn match fourstatebuttonInputParameter "^\s*b" contained
syn match fourstatebuttonInputParameter "^\s*button" contained
syn match fourstatebuttonOutputParameter "^\s*l" contained
syn match fourstatebuttonOutputParameter "^\s*led" contained
syn match fourstatebuttonOutputParameter "^\s*o" contained
syn match fourstatebuttonOutputParameter "^\s*output" contained
syn match fourstatebuttonInputParameter "^\s*r" contained
syn match fourstatebuttonInputParameter "^\s*reset" contained
syn match fourstatebuttonInputParameter "^\s*startvalue" contained
syn match fourstatebuttonInputParameter "^\s*sv" contained
syn match fourstatebuttonInputParameter "^\s*v1" contained
syn match fourstatebuttonInputParameter "^\s*v2" contained
syn match fourstatebuttonInputParameter "^\s*v3" contained
syn match fourstatebuttonInputParameter "^\s*v4" contained
syn match fourstatebuttonInputParameter "^\s*value" contained
syn match fourstatebuttonInputParameter "^\s*value1" contained
syn match fourstatebuttonInputParameter "^\s*value2" contained
syn match fourstatebuttonInputParameter "^\s*value3" contained
syn match fourstatebuttonInputParameter "^\s*value4" contained
syn match fourstatebuttonHeader /\[fourstatebutton\]/ contained
syn region fourstatebuttonCircuit start=/\[fourstatebutton\]/ end=/\[/me=s-1 transparent contains=fourstatebuttonHeader,fourstatebuttonInputParameter,fourstatebuttonOutputParameter,ioregister,number,cable,quotestring,comment
hi def link fourstatebuttonHeader circuitHeader
hi def link fourstatebuttonInputParameter inputParameter
hi def link fourstatebuttonOutputParameter outputParameter


" gatetool
syn match gatetoolInputParameter "^\s*gatelength" contained
syn match gatetoolInputParameter "^\s*gatestretch" contained
syn match gatetoolInputParameter "^\s*gl" contained
syn match gatetoolInputParameter "^\s*ie" contained
syn match gatetoolInputParameter "^\s*ig" contained
syn match gatetoolInputParameter "^\s*inputedge" contained
syn match gatetoolInputParameter "^\s*inputgate" contained
syn match gatetoolInputParameter "^\s*inputtrigger" contained
syn match gatetoolInputParameter "^\s*it" contained
syn match gatetoolInputParameter "^\s*m" contained
syn match gatetoolInputParameter "^\s*maxgatelength" contained
syn match gatetoolInputParameter "^\s*mingatelength" contained
syn match gatetoolOutputParameter "^\s*oe" contained
syn match gatetoolOutputParameter "^\s*og" contained
syn match gatetoolOutputParameter "^\s*ot" contained
syn match gatetoolOutputParameter "^\s*outputedge" contained
syn match gatetoolOutputParameter "^\s*outputgate" contained
syn match gatetoolOutputParameter "^\s*outputtrigger" contained
syn match gatetoolInputParameter "^\s*s" contained
syn match gatetoolInputParameter "^\s*taptempo" contained
syn match gatetoolInputParameter "^\s*tt" contained
syn match gatetoolInputParameter "^\s*x" contained
syn match gatetoolHeader /\[gatetool\]/ contained
syn region gatetoolCircuit start=/\[gatetool\]/ end=/\[/me=s-1 transparent contains=gatetoolHeader,gatetoolInputParameter,gatetoolOutputParameter,ioregister,number,cable,quotestring,comment
hi def link gatetoolHeader circuitHeader
hi def link gatetoolInputParameter inputParameter
hi def link gatetoolOutputParameter outputParameter


" ifequal
syn match ifequalInputParameter "^\s*e" contained
syn match ifequalInputParameter "^\s*else" contained
syn match ifequalInputParameter "^\s*i1" contained
syn match ifequalInputParameter "^\s*i2" contained
syn match ifequalInputParameter "^\s*ifequal" contained
syn match ifequalInputParameter "^\s*input1" contained
syn match ifequalInputParameter "^\s*input2" contained
syn match ifequalOutputParameter "^\s*o" contained
syn match ifequalOutputParameter "^\s*output" contained
syn match ifequalInputParameter "^\s*q" contained
syn match ifequalHeader /\[ifequal\]/ contained
syn region ifequalCircuit start=/\[ifequal\]/ end=/\[/me=s-1 transparent contains=ifequalHeader,ifequalInputParameter,ifequalOutputParameter,ioregister,number,cable,quotestring,comment
hi def link ifequalHeader circuitHeader
hi def link ifequalInputParameter inputParameter
hi def link ifequalOutputParameter outputParameter


" lfo
syn match lfoInputParameter "^\s*b" contained
syn match lfoInputParameter "^\s*bipolar" contained
syn match lfoOutputParameter "^\s*cosine" contained
syn match lfoOutputParameter "^\s*cs" contained
syn match lfoInputParameter "^\s*hz" contained
syn match lfoInputParameter "^\s*l" contained
syn match lfoInputParameter "^\s*level" contained
syn match lfoOutputParameter "^\s*o" contained
syn match lfoInputParameter "^\s*of" contained
syn match lfoInputParameter "^\s*offset" contained
syn match lfoOutputParameter "^\s*output" contained
syn match lfoInputParameter "^\s*p" contained
syn match lfoOutputParameter "^\s*paraboloid" contained
syn match lfoOutputParameter "^\s*pb" contained
syn match lfoInputParameter "^\s*phase" contained
syn match lfoInputParameter "^\s*pulsewidth" contained
syn match lfoInputParameter "^\s*pw" contained
syn match lfoOutputParameter "^\s*q" contained
syn match lfoInputParameter "^\s*r" contained
syn match lfoInputParameter "^\s*ra" contained
syn match lfoOutputParameter "^\s*ramp" contained
syn match lfoInputParameter "^\s*randomize" contained
syn match lfoInputParameter "^\s*rate" contained
syn match lfoOutputParameter "^\s*rp" contained
syn match lfoOutputParameter "^\s*sawtooth" contained
syn match lfoOutputParameter "^\s*si" contained
syn match lfoOutputParameter "^\s*sine" contained
syn match lfoInputParameter "^\s*sk" contained
syn match lfoInputParameter "^\s*skew" contained
syn match lfoInputParameter "^\s*sp" contained
syn match lfoOutputParameter "^\s*square" contained
syn match lfoOutputParameter "^\s*st" contained
syn match lfoInputParameter "^\s*sy" contained
syn match lfoInputParameter "^\s*sync" contained
syn match lfoInputParameter "^\s*syncphase" contained
syn match lfoOutputParameter "^\s*t" contained
syn match lfoInputParameter "^\s*taptempo" contained
syn match lfoOutputParameter "^\s*triangle" contained
syn match lfoInputParameter "^\s*tt" contained
syn match lfoInputParameter "^\s*w" contained
syn match lfoInputParameter "^\s*waveform" contained
syn match lfoHeader /\[lfo\]/ contained
syn region lfoCircuit start=/\[lfo\]/ end=/\[/me=s-1 transparent contains=lfoHeader,lfoInputParameter,lfoOutputParameter,ioregister,number,cable,quotestring,comment
hi def link lfoHeader circuitHeader
hi def link lfoInputParameter inputParameter
hi def link lfoOutputParameter outputParameter


" logic
syn match logicOutputParameter "^\s*a" contained
syn match logicOutputParameter "^\s*and" contained
syn match logicOutputParameter "^\s*c" contained
syn match logicOutputParameter "^\s*cl" contained
syn match logicOutputParameter "^\s*count" contained
syn match logicOutputParameter "^\s*countlow" contained
syn match logicInputParameter "^\s*countvalue" contained
syn match logicInputParameter "^\s*cv" contained
syn match logicInputParameter "^\s*h" contained
syn match logicInputParameter "^\s*highvalue" contained
syn match logicInputParameter "^\s*i1" contained
syn match logicInputParameter "^\s*i2" contained
syn match logicInputParameter "^\s*i3" contained
syn match logicInputParameter "^\s*i4" contained
syn match logicInputParameter "^\s*i5" contained
syn match logicInputParameter "^\s*i6" contained
syn match logicInputParameter "^\s*i7" contained
syn match logicInputParameter "^\s*i8" contained
syn match logicInputParameter "^\s*input" contained
syn match logicInputParameter "^\s*input1" contained
syn match logicInputParameter "^\s*input2" contained
syn match logicInputParameter "^\s*input3" contained
syn match logicInputParameter "^\s*input4" contained
syn match logicInputParameter "^\s*input5" contained
syn match logicInputParameter "^\s*input6" contained
syn match logicInputParameter "^\s*input7" contained
syn match logicInputParameter "^\s*input8" contained
syn match logicInputParameter "^\s*l" contained
syn match logicInputParameter "^\s*lowvalue" contained
syn match logicOutputParameter "^\s*n" contained
syn match logicOutputParameter "^\s*na" contained
syn match logicOutputParameter "^\s*nand" contained
syn match logicOutputParameter "^\s*negated" contained
syn match logicOutputParameter "^\s*no" contained
syn match logicOutputParameter "^\s*nor" contained
syn match logicOutputParameter "^\s*o" contained
syn match logicOutputParameter "^\s*or" contained
syn match logicInputParameter "^\s*th" contained
syn match logicInputParameter "^\s*threshold" contained
syn match logicOutputParameter "^\s*x" contained
syn match logicOutputParameter "^\s*xor" contained
syn match logicHeader /\[logic\]/ contained
syn region logicCircuit start=/\[logic\]/ end=/\[/me=s-1 transparent contains=logicHeader,logicInputParameter,logicOutputParameter,ioregister,number,cable,quotestring,comment
hi def link logicHeader circuitHeader
hi def link logicInputParameter inputParameter
hi def link logicOutputParameter outputParameter


" math
syn match mathOutputParameter "^\s*a" contained
syn match mathOutputParameter "^\s*am" contained
syn match mathOutputParameter "^\s*amount" contained
syn match mathOutputParameter "^\s*average" contained
syn match mathOutputParameter "^\s*c" contained
syn match mathOutputParameter "^\s*ceil" contained
syn match mathOutputParameter "^\s*cosine" contained
syn match mathOutputParameter "^\s*cs" contained
syn match mathOutputParameter "^\s*d" contained
syn match mathOutputParameter "^\s*difference" contained
syn match mathOutputParameter "^\s*f" contained
syn match mathOutputParameter "^\s*floor" contained
syn match mathInputParameter "^\s*i1" contained
syn match mathInputParameter "^\s*i2" contained
syn match mathInputParameter "^\s*input" contained
syn match mathInputParameter "^\s*input1" contained
syn match mathInputParameter "^\s*input2" contained
syn match mathOutputParameter "^\s*l" contained
syn match mathOutputParameter "^\s*l2" contained
syn match mathOutputParameter "^\s*log2" contained
syn match mathOutputParameter "^\s*logarithm" contained
syn match mathOutputParameter "^\s*m" contained
syn match mathOutputParameter "^\s*maximum" contained
syn match mathOutputParameter "^\s*md" contained
syn match mathOutputParameter "^\s*minimum" contained
syn match mathOutputParameter "^\s*modulo" contained
syn match mathOutputParameter "^\s*n" contained
syn match mathOutputParameter "^\s*negation" contained
syn match mathOutputParameter "^\s*p" contained
syn match mathOutputParameter "^\s*power" contained
syn match mathOutputParameter "^\s*product" contained
syn match mathOutputParameter "^\s*pw" contained
syn match mathOutputParameter "^\s*q" contained
syn match mathOutputParameter "^\s*qu" contained
syn match mathOutputParameter "^\s*quotient" contained
syn match mathOutputParameter "^\s*rc" contained
syn match mathOutputParameter "^\s*rd" contained
syn match mathOutputParameter "^\s*reciprocal" contained
syn match mathOutputParameter "^\s*ro" contained
syn match mathOutputParameter "^\s*root" contained
syn match mathOutputParameter "^\s*round" contained
syn match mathOutputParameter "^\s*s" contained
syn match mathOutputParameter "^\s*si" contained
syn match mathOutputParameter "^\s*sine" contained
syn match mathOutputParameter "^\s*square" contained
syn match mathOutputParameter "^\s*sum" contained
syn match mathOutputParameter "^\s*x" contained
syn match mathHeader /\[math\]/ contained
syn region mathCircuit start=/\[math\]/ end=/\[/me=s-1 transparent contains=mathHeader,mathInputParameter,mathOutputParameter,ioregister,number,cable,quotestring,comment
hi def link mathHeader circuitHeader
hi def link mathInputParameter inputParameter
hi def link mathOutputParameter outputParameter


" matrixmixer
syn match matrixmixerInputParameter "^\s*a1" contained
syn match matrixmixerInputParameter "^\s*a2" contained
syn match matrixmixerInputParameter "^\s*a3" contained
syn match matrixmixerInputParameter "^\s*a4" contained
syn match matrixmixerInputParameter "^\s*auxin" contained
syn match matrixmixerInputParameter "^\s*auxin1" contained
syn match matrixmixerInputParameter "^\s*auxin2" contained
syn match matrixmixerInputParameter "^\s*auxin3" contained
syn match matrixmixerInputParameter "^\s*auxin4" contained
syn match matrixmixerInputParameter "^\s*b11" contained
syn match matrixmixerInputParameter "^\s*b12" contained
syn match matrixmixerInputParameter "^\s*b13" contained
syn match matrixmixerInputParameter "^\s*b14" contained
syn match matrixmixerInputParameter "^\s*b21" contained
syn match matrixmixerInputParameter "^\s*b22" contained
syn match matrixmixerInputParameter "^\s*b23" contained
syn match matrixmixerInputParameter "^\s*b24" contained
syn match matrixmixerInputParameter "^\s*b31" contained
syn match matrixmixerInputParameter "^\s*b32" contained
syn match matrixmixerInputParameter "^\s*b33" contained
syn match matrixmixerInputParameter "^\s*b34" contained
syn match matrixmixerInputParameter "^\s*b41" contained
syn match matrixmixerInputParameter "^\s*b42" contained
syn match matrixmixerInputParameter "^\s*b43" contained
syn match matrixmixerInputParameter "^\s*b44" contained
syn match matrixmixerInputParameter "^\s*button1" contained
syn match matrixmixerInputParameter "^\s*button11" contained
syn match matrixmixerInputParameter "^\s*button12" contained
syn match matrixmixerInputParameter "^\s*button13" contained
syn match matrixmixerInputParameter "^\s*button14" contained
syn match matrixmixerInputParameter "^\s*button2" contained
syn match matrixmixerInputParameter "^\s*button21" contained
syn match matrixmixerInputParameter "^\s*button22" contained
syn match matrixmixerInputParameter "^\s*button23" contained
syn match matrixmixerInputParameter "^\s*button24" contained
syn match matrixmixerInputParameter "^\s*button3" contained
syn match matrixmixerInputParameter "^\s*button31" contained
syn match matrixmixerInputParameter "^\s*button32" contained
syn match matrixmixerInputParameter "^\s*button33" contained
syn match matrixmixerInputParameter "^\s*button34" contained
syn match matrixmixerInputParameter "^\s*button4" contained
syn match matrixmixerInputParameter "^\s*button41" contained
syn match matrixmixerInputParameter "^\s*button42" contained
syn match matrixmixerInputParameter "^\s*button43" contained
syn match matrixmixerInputParameter "^\s*button44" contained
syn match matrixmixerInputParameter "^\s*ca" contained
syn match matrixmixerInputParameter "^\s*cl" contained
syn match matrixmixerInputParameter "^\s*clear" contained
syn match matrixmixerInputParameter "^\s*clearall" contained
syn match matrixmixerInputParameter "^\s*dontsave" contained
syn match matrixmixerInputParameter "^\s*dos" contained
syn match matrixmixerInputParameter "^\s*i1" contained
syn match matrixmixerInputParameter "^\s*i2" contained
syn match matrixmixerInputParameter "^\s*i3" contained
syn match matrixmixerInputParameter "^\s*i4" contained
syn match matrixmixerInputParameter "^\s*input" contained
syn match matrixmixerInputParameter "^\s*input1" contained
syn match matrixmixerInputParameter "^\s*input2" contained
syn match matrixmixerInputParameter "^\s*input3" contained
syn match matrixmixerInputParameter "^\s*input4" contained
syn match matrixmixerOutputParameter "^\s*l11" contained
syn match matrixmixerOutputParameter "^\s*l12" contained
syn match matrixmixerOutputParameter "^\s*l13" contained
syn match matrixmixerOutputParameter "^\s*l14" contained
syn match matrixmixerOutputParameter "^\s*l21" contained
syn match matrixmixerOutputParameter "^\s*l22" contained
syn match matrixmixerOutputParameter "^\s*l23" contained
syn match matrixmixerOutputParameter "^\s*l24" contained
syn match matrixmixerOutputParameter "^\s*l31" contained
syn match matrixmixerOutputParameter "^\s*l32" contained
syn match matrixmixerOutputParameter "^\s*l33" contained
syn match matrixmixerOutputParameter "^\s*l34" contained
syn match matrixmixerOutputParameter "^\s*l41" contained
syn match matrixmixerOutputParameter "^\s*l42" contained
syn match matrixmixerOutputParameter "^\s*l43" contained
syn match matrixmixerOutputParameter "^\s*l44" contained
syn match matrixmixerOutputParameter "^\s*led1" contained
syn match matrixmixerOutputParameter "^\s*led11" contained
syn match matrixmixerOutputParameter "^\s*led12" contained
syn match matrixmixerOutputParameter "^\s*led13" contained
syn match matrixmixerOutputParameter "^\s*led14" contained
syn match matrixmixerOutputParameter "^\s*led2" contained
syn match matrixmixerOutputParameter "^\s*led21" contained
syn match matrixmixerOutputParameter "^\s*led22" contained
syn match matrixmixerOutputParameter "^\s*led23" contained
syn match matrixmixerOutputParameter "^\s*led24" contained
syn match matrixmixerOutputParameter "^\s*led3" contained
syn match matrixmixerOutputParameter "^\s*led31" contained
syn match matrixmixerOutputParameter "^\s*led32" contained
syn match matrixmixerOutputParameter "^\s*led33" contained
syn match matrixmixerOutputParameter "^\s*led34" contained
syn match matrixmixerOutputParameter "^\s*led4" contained
syn match matrixmixerOutputParameter "^\s*led41" contained
syn match matrixmixerOutputParameter "^\s*led42" contained
syn match matrixmixerOutputParameter "^\s*led43" contained
syn match matrixmixerOutputParameter "^\s*led44" contained
syn match matrixmixerInputParameter "^\s*loadpreset" contained
syn match matrixmixerInputParameter "^\s*lp" contained
syn match matrixmixerInputParameter "^\s*m" contained
syn match matrixmixerInputParameter "^\s*mixmax" contained
syn match matrixmixerOutputParameter "^\s*o1" contained
syn match matrixmixerOutputParameter "^\s*o2" contained
syn match matrixmixerOutputParameter "^\s*o3" contained
syn match matrixmixerOutputParameter "^\s*o4" contained
syn match matrixmixerOutputParameter "^\s*output" contained
syn match matrixmixerOutputParameter "^\s*output1" contained
syn match matrixmixerOutputParameter "^\s*output2" contained
syn match matrixmixerOutputParameter "^\s*output3" contained
syn match matrixmixerOutputParameter "^\s*output4" contained
syn match matrixmixerInputParameter "^\s*pr" contained
syn match matrixmixerInputParameter "^\s*preset" contained
syn match matrixmixerInputParameter "^\s*s" contained
syn match matrixmixerInputParameter "^\s*sa" contained
syn match matrixmixerInputParameter "^\s*savepreset" contained
syn match matrixmixerInputParameter "^\s*select" contained
syn match matrixmixerInputParameter "^\s*selectat" contained
syn match matrixmixerInputParameter "^\s*sp" contained
syn match matrixmixerInputParameter "^\s*startvalue" contained
syn match matrixmixerInputParameter "^\s*sv" contained
syn match matrixmixerHeader /\[matrixmixer\]/ contained
syn region matrixmixerCircuit start=/\[matrixmixer\]/ end=/\[/me=s-1 transparent contains=matrixmixerHeader,matrixmixerInputParameter,matrixmixerOutputParameter,ioregister,number,cable,quotestring,comment
hi def link matrixmixerHeader circuitHeader
hi def link matrixmixerInputParameter inputParameter
hi def link matrixmixerOutputParameter outputParameter


" midifileplayer
syn match midifileplayerOutputParameter "^\s*ba" contained
syn match midifileplayerOutputParameter "^\s*bank" contained
syn match midifileplayerInputParameter "^\s*bendpitch" contained
syn match midifileplayerInputParameter "^\s*bp" contained
syn match midifileplayerInputParameter "^\s*c" contained
syn match midifileplayerOutputParameter "^\s*cc" contained
syn match midifileplayerOutputParameter "^\s*cc1" contained
syn match midifileplayerOutputParameter "^\s*cc2" contained
syn match midifileplayerOutputParameter "^\s*cc3" contained
syn match midifileplayerOutputParameter "^\s*cc4" contained
syn match midifileplayerInputParameter "^\s*ccnumber" contained
syn match midifileplayerInputParameter "^\s*ccnumber1" contained
syn match midifileplayerInputParameter "^\s*ccnumber2" contained
syn match midifileplayerInputParameter "^\s*ccnumber3" contained
syn match midifileplayerInputParameter "^\s*ccnumber4" contained
syn match midifileplayerOutputParameter "^\s*cctrigger" contained
syn match midifileplayerOutputParameter "^\s*cctrigger1" contained
syn match midifileplayerOutputParameter "^\s*cctrigger2" contained
syn match midifileplayerOutputParameter "^\s*cctrigger3" contained
syn match midifileplayerOutputParameter "^\s*cctrigger4" contained
syn match midifileplayerInputParameter "^\s*ch" contained
syn match midifileplayerInputParameter "^\s*channel" contained
syn match midifileplayerInputParameter "^\s*clock" contained
syn match midifileplayerOutputParameter "^\s*clockout" contained
syn match midifileplayerInputParameter "^\s*cn1" contained
syn match midifileplayerInputParameter "^\s*cn2" contained
syn match midifileplayerInputParameter "^\s*cn3" contained
syn match midifileplayerInputParameter "^\s*cn4" contained
syn match midifileplayerOutputParameter "^\s*co" contained
syn match midifileplayerOutputParameter "^\s*ct1" contained
syn match midifileplayerOutputParameter "^\s*ct2" contained
syn match midifileplayerOutputParameter "^\s*ct3" contained
syn match midifileplayerOutputParameter "^\s*ct4" contained
syn match midifileplayerInputParameter "^\s*e" contained
syn match midifileplayerInputParameter "^\s*end" contained
syn match midifileplayerOutputParameter "^\s*endoftrack" contained
syn match midifileplayerOutputParameter "^\s*er" contained
syn match midifileplayerOutputParameter "^\s*error" contained
syn match midifileplayerOutputParameter "^\s*et" contained
syn match midifileplayerInputParameter "^\s*f" contained
syn match midifileplayerInputParameter "^\s*file" contained
syn match midifileplayerOutputParameter "^\s*g1" contained
syn match midifileplayerOutputParameter "^\s*g2" contained
syn match midifileplayerOutputParameter "^\s*g3" contained
syn match midifileplayerOutputParameter "^\s*g4" contained
syn match midifileplayerOutputParameter "^\s*g5" contained
syn match midifileplayerOutputParameter "^\s*g6" contained
syn match midifileplayerOutputParameter "^\s*g7" contained
syn match midifileplayerOutputParameter "^\s*g8" contained
syn match midifileplayerOutputParameter "^\s*gate" contained
syn match midifileplayerOutputParameter "^\s*gate1" contained
syn match midifileplayerOutputParameter "^\s*gate2" contained
syn match midifileplayerOutputParameter "^\s*gate3" contained
syn match midifileplayerOutputParameter "^\s*gate4" contained
syn match midifileplayerOutputParameter "^\s*gate5" contained
syn match midifileplayerOutputParameter "^\s*gate6" contained
syn match midifileplayerOutputParameter "^\s*gate7" contained
syn match midifileplayerOutputParameter "^\s*gate8" contained
syn match midifileplayerInputParameter "^\s*highestnote" contained
syn match midifileplayerInputParameter "^\s*hn" contained
syn match midifileplayerInputParameter "^\s*holdvelocity" contained
syn match midifileplayerInputParameter "^\s*hv" contained
syn match midifileplayerInputParameter "^\s*ln" contained
syn match midifileplayerInputParameter "^\s*lo" contained
syn match midifileplayerInputParameter "^\s*loop" contained
syn match midifileplayerInputParameter "^\s*lowestnote" contained
syn match midifileplayerOutputParameter "^\s*mc" contained
syn match midifileplayerOutputParameter "^\s*midiclock" contained
syn match midifileplayerOutputParameter "^\s*modwheel" contained
syn match midifileplayerInputParameter "^\s*n1" contained
syn match midifileplayerInputParameter "^\s*n10" contained
syn match midifileplayerInputParameter "^\s*n11" contained
syn match midifileplayerInputParameter "^\s*n12" contained
syn match midifileplayerInputParameter "^\s*n13" contained
syn match midifileplayerInputParameter "^\s*n14" contained
syn match midifileplayerInputParameter "^\s*n15" contained
syn match midifileplayerInputParameter "^\s*n16" contained
syn match midifileplayerInputParameter "^\s*n2" contained
syn match midifileplayerInputParameter "^\s*n3" contained
syn match midifileplayerInputParameter "^\s*n4" contained
syn match midifileplayerInputParameter "^\s*n5" contained
syn match midifileplayerInputParameter "^\s*n6" contained
syn match midifileplayerInputParameter "^\s*n7" contained
syn match midifileplayerInputParameter "^\s*n8" contained
syn match midifileplayerInputParameter "^\s*n9" contained
syn match midifileplayerOutputParameter "^\s*ng1" contained
syn match midifileplayerOutputParameter "^\s*ng10" contained
syn match midifileplayerOutputParameter "^\s*ng11" contained
syn match midifileplayerOutputParameter "^\s*ng12" contained
syn match midifileplayerOutputParameter "^\s*ng13" contained
syn match midifileplayerOutputParameter "^\s*ng14" contained
syn match midifileplayerOutputParameter "^\s*ng15" contained
syn match midifileplayerOutputParameter "^\s*ng16" contained
syn match midifileplayerOutputParameter "^\s*ng2" contained
syn match midifileplayerOutputParameter "^\s*ng3" contained
syn match midifileplayerOutputParameter "^\s*ng4" contained
syn match midifileplayerOutputParameter "^\s*ng5" contained
syn match midifileplayerOutputParameter "^\s*ng6" contained
syn match midifileplayerOutputParameter "^\s*ng7" contained
syn match midifileplayerOutputParameter "^\s*ng8" contained
syn match midifileplayerOutputParameter "^\s*ng9" contained
syn match midifileplayerInputParameter "^\s*ngp" contained
syn match midifileplayerOutputParameter "^\s*ngv1" contained
syn match midifileplayerOutputParameter "^\s*ngv10" contained
syn match midifileplayerOutputParameter "^\s*ngv11" contained
syn match midifileplayerOutputParameter "^\s*ngv12" contained
syn match midifileplayerOutputParameter "^\s*ngv13" contained
syn match midifileplayerOutputParameter "^\s*ngv14" contained
syn match midifileplayerOutputParameter "^\s*ngv15" contained
syn match midifileplayerOutputParameter "^\s*ngv16" contained
syn match midifileplayerOutputParameter "^\s*ngv2" contained
syn match midifileplayerOutputParameter "^\s*ngv3" contained
syn match midifileplayerOutputParameter "^\s*ngv4" contained
syn match midifileplayerOutputParameter "^\s*ngv5" contained
syn match midifileplayerOutputParameter "^\s*ngv6" contained
syn match midifileplayerOutputParameter "^\s*ngv7" contained
syn match midifileplayerOutputParameter "^\s*ngv8" contained
syn match midifileplayerOutputParameter "^\s*ngv9" contained
syn match midifileplayerInputParameter "^\s*note" contained
syn match midifileplayerInputParameter "^\s*note1" contained
syn match midifileplayerInputParameter "^\s*note10" contained
syn match midifileplayerInputParameter "^\s*note11" contained
syn match midifileplayerInputParameter "^\s*note12" contained
syn match midifileplayerInputParameter "^\s*note13" contained
syn match midifileplayerInputParameter "^\s*note14" contained
syn match midifileplayerInputParameter "^\s*note15" contained
syn match midifileplayerInputParameter "^\s*note16" contained
syn match midifileplayerInputParameter "^\s*note2" contained
syn match midifileplayerInputParameter "^\s*note3" contained
syn match midifileplayerInputParameter "^\s*note4" contained
syn match midifileplayerInputParameter "^\s*note5" contained
syn match midifileplayerInputParameter "^\s*note6" contained
syn match midifileplayerInputParameter "^\s*note7" contained
syn match midifileplayerInputParameter "^\s*note8" contained
syn match midifileplayerInputParameter "^\s*note9" contained
syn match midifileplayerInputParameter "^\s*notegap" contained
syn match midifileplayerOutputParameter "^\s*notegate" contained
syn match midifileplayerOutputParameter "^\s*notegate1" contained
syn match midifileplayerOutputParameter "^\s*notegate10" contained
syn match midifileplayerOutputParameter "^\s*notegate11" contained
syn match midifileplayerOutputParameter "^\s*notegate12" contained
syn match midifileplayerOutputParameter "^\s*notegate13" contained
syn match midifileplayerOutputParameter "^\s*notegate14" contained
syn match midifileplayerOutputParameter "^\s*notegate15" contained
syn match midifileplayerOutputParameter "^\s*notegate16" contained
syn match midifileplayerOutputParameter "^\s*notegate2" contained
syn match midifileplayerOutputParameter "^\s*notegate3" contained
syn match midifileplayerOutputParameter "^\s*notegate4" contained
syn match midifileplayerOutputParameter "^\s*notegate5" contained
syn match midifileplayerOutputParameter "^\s*notegate6" contained
syn match midifileplayerOutputParameter "^\s*notegate7" contained
syn match midifileplayerOutputParameter "^\s*notegate8" contained
syn match midifileplayerOutputParameter "^\s*notegate9" contained
syn match midifileplayerOutputParameter "^\s*notegatevelocity" contained
syn match midifileplayerOutputParameter "^\s*notegatevelocity1" contained
syn match midifileplayerOutputParameter "^\s*notegatevelocity10" contained
syn match midifileplayerOutputParameter "^\s*notegatevelocity11" contained
syn match midifileplayerOutputParameter "^\s*notegatevelocity12" contained
syn match midifileplayerOutputParameter "^\s*notegatevelocity13" contained
syn match midifileplayerOutputParameter "^\s*notegatevelocity14" contained
syn match midifileplayerOutputParameter "^\s*notegatevelocity15" contained
syn match midifileplayerOutputParameter "^\s*notegatevelocity16" contained
syn match midifileplayerOutputParameter "^\s*notegatevelocity2" contained
syn match midifileplayerOutputParameter "^\s*notegatevelocity3" contained
syn match midifileplayerOutputParameter "^\s*notegatevelocity4" contained
syn match midifileplayerOutputParameter "^\s*notegatevelocity5" contained
syn match midifileplayerOutputParameter "^\s*notegatevelocity6" contained
syn match midifileplayerOutputParameter "^\s*notegatevelocity7" contained
syn match midifileplayerOutputParameter "^\s*notegatevelocity8" contained
syn match midifileplayerOutputParameter "^\s*notegatevelocity9" contained
syn match midifileplayerOutputParameter "^\s*p1" contained
syn match midifileplayerOutputParameter "^\s*p2" contained
syn match midifileplayerOutputParameter "^\s*p3" contained
syn match midifileplayerOutputParameter "^\s*p4" contained
syn match midifileplayerOutputParameter "^\s*p5" contained
syn match midifileplayerOutputParameter "^\s*p6" contained
syn match midifileplayerOutputParameter "^\s*p7" contained
syn match midifileplayerOutputParameter "^\s*p8" contained
syn match midifileplayerOutputParameter "^\s*pb" contained
syn match midifileplayerInputParameter "^\s*pbr" contained
syn match midifileplayerOutputParameter "^\s*pc" contained
syn match midifileplayerOutputParameter "^\s*pitch" contained
syn match midifileplayerOutputParameter "^\s*pitch1" contained
syn match midifileplayerOutputParameter "^\s*pitch2" contained
syn match midifileplayerOutputParameter "^\s*pitch3" contained
syn match midifileplayerOutputParameter "^\s*pitch4" contained
syn match midifileplayerOutputParameter "^\s*pitch5" contained
syn match midifileplayerOutputParameter "^\s*pitch6" contained
syn match midifileplayerOutputParameter "^\s*pitch7" contained
syn match midifileplayerOutputParameter "^\s*pitch8" contained
syn match midifileplayerOutputParameter "^\s*pitchbend" contained
syn match midifileplayerInputParameter "^\s*pitchbendrange" contained
syn match midifileplayerOutputParameter "^\s*pm" contained
syn match midifileplayerOutputParameter "^\s*po" contained
syn match midifileplayerOutputParameter "^\s*portamento" contained
syn match midifileplayerOutputParameter "^\s*pr1" contained
syn match midifileplayerOutputParameter "^\s*pr2" contained
syn match midifileplayerOutputParameter "^\s*pr3" contained
syn match midifileplayerOutputParameter "^\s*pr4" contained
syn match midifileplayerOutputParameter "^\s*pr5" contained
syn match midifileplayerOutputParameter "^\s*pr6" contained
syn match midifileplayerOutputParameter "^\s*pr7" contained
syn match midifileplayerOutputParameter "^\s*pr8" contained
syn match midifileplayerOutputParameter "^\s*pressure" contained
syn match midifileplayerOutputParameter "^\s*pressure1" contained
syn match midifileplayerOutputParameter "^\s*pressure2" contained
syn match midifileplayerOutputParameter "^\s*pressure3" contained
syn match midifileplayerOutputParameter "^\s*pressure4" contained
syn match midifileplayerOutputParameter "^\s*pressure5" contained
syn match midifileplayerOutputParameter "^\s*pressure6" contained
syn match midifileplayerOutputParameter "^\s*pressure7" contained
syn match midifileplayerOutputParameter "^\s*pressure8" contained
syn match midifileplayerOutputParameter "^\s*program" contained
syn match midifileplayerOutputParameter "^\s*programchange" contained
syn match midifileplayerInputParameter "^\s*r" contained
syn match midifileplayerInputParameter "^\s*reset" contained
syn match midifileplayerInputParameter "^\s*roundrobin" contained
syn match midifileplayerInputParameter "^\s*rr" contained
syn match midifileplayerOutputParameter "^\s*so" contained
syn match midifileplayerOutputParameter "^\s*soft" contained
syn match midifileplayerInputParameter "^\s*sp" contained
syn match midifileplayerInputParameter "^\s*speed" contained
syn match midifileplayerOutputParameter "^\s*t1" contained
syn match midifileplayerOutputParameter "^\s*t2" contained
syn match midifileplayerOutputParameter "^\s*t3" contained
syn match midifileplayerOutputParameter "^\s*t4" contained
syn match midifileplayerOutputParameter "^\s*t5" contained
syn match midifileplayerOutputParameter "^\s*t6" contained
syn match midifileplayerOutputParameter "^\s*t7" contained
syn match midifileplayerOutputParameter "^\s*t8" contained
syn match midifileplayerInputParameter "^\s*tc" contained
syn match midifileplayerInputParameter "^\s*tm" contained
syn match midifileplayerInputParameter "^\s*tp" contained
syn match midifileplayerInputParameter "^\s*tr" contained
syn match midifileplayerInputParameter "^\s*track" contained
syn match midifileplayerInputParameter "^\s*transpose" contained
syn match midifileplayerOutputParameter "^\s*trigger" contained
syn match midifileplayerOutputParameter "^\s*trigger1" contained
syn match midifileplayerOutputParameter "^\s*trigger2" contained
syn match midifileplayerOutputParameter "^\s*trigger3" contained
syn match midifileplayerOutputParameter "^\s*trigger4" contained
syn match midifileplayerOutputParameter "^\s*trigger5" contained
syn match midifileplayerOutputParameter "^\s*trigger6" contained
syn match midifileplayerOutputParameter "^\s*trigger7" contained
syn match midifileplayerOutputParameter "^\s*trigger8" contained
syn match midifileplayerInputParameter "^\s*tuningmode" contained
syn match midifileplayerInputParameter "^\s*tuningpitch" contained
syn match midifileplayerOutputParameter "^\s*v1" contained
syn match midifileplayerOutputParameter "^\s*v2" contained
syn match midifileplayerOutputParameter "^\s*v3" contained
syn match midifileplayerOutputParameter "^\s*v4" contained
syn match midifileplayerOutputParameter "^\s*v5" contained
syn match midifileplayerOutputParameter "^\s*v6" contained
syn match midifileplayerOutputParameter "^\s*v7" contained
syn match midifileplayerOutputParameter "^\s*v8" contained
syn match midifileplayerInputParameter "^\s*va" contained
syn match midifileplayerOutputParameter "^\s*velocity" contained
syn match midifileplayerOutputParameter "^\s*velocity1" contained
syn match midifileplayerOutputParameter "^\s*velocity2" contained
syn match midifileplayerOutputParameter "^\s*velocity3" contained
syn match midifileplayerOutputParameter "^\s*velocity4" contained
syn match midifileplayerOutputParameter "^\s*velocity5" contained
syn match midifileplayerOutputParameter "^\s*velocity6" contained
syn match midifileplayerOutputParameter "^\s*velocity7" contained
syn match midifileplayerOutputParameter "^\s*velocity8" contained
syn match midifileplayerOutputParameter "^\s*vo" contained
syn match midifileplayerInputParameter "^\s*voiceallocation" contained
syn match midifileplayerOutputParameter "^\s*volume" contained
syn match midifileplayerOutputParameter "^\s*w" contained
syn match midifileplayerHeader /\[midifileplayer\]/ contained
syn region midifileplayerCircuit start=/\[midifileplayer\]/ end=/\[/me=s-1 transparent contains=midifileplayerHeader,midifileplayerInputParameter,midifileplayerOutputParameter,ioregister,number,cable,quotestring,comment
hi def link midifileplayerHeader circuitHeader
hi def link midifileplayerInputParameter inputParameter
hi def link midifileplayerOutputParameter outputParameter


" midiin
syn match midiinOutputParameter "^\s*a" contained
syn match midiinOutputParameter "^\s*active" contained
syn match midiinOutputParameter "^\s*ba" contained
syn match midiinOutputParameter "^\s*bank" contained
syn match midiinInputParameter "^\s*bendpitch" contained
syn match midiinInputParameter "^\s*bp" contained
syn match midiinOutputParameter "^\s*c" contained
syn match midiinOutputParameter "^\s*c16" contained
syn match midiinOutputParameter "^\s*c4" contained
syn match midiinOutputParameter "^\s*c8" contained
syn match midiinOutputParameter "^\s*c8t" contained
syn match midiinOutputParameter "^\s*cc" contained
syn match midiinOutputParameter "^\s*cc1" contained
syn match midiinOutputParameter "^\s*cc2" contained
syn match midiinOutputParameter "^\s*cc3" contained
syn match midiinOutputParameter "^\s*cc4" contained
syn match midiinInputParameter "^\s*ccnumber" contained
syn match midiinInputParameter "^\s*ccnumber1" contained
syn match midiinInputParameter "^\s*ccnumber2" contained
syn match midiinInputParameter "^\s*ccnumber3" contained
syn match midiinInputParameter "^\s*ccnumber4" contained
syn match midiinOutputParameter "^\s*cctrigger" contained
syn match midiinOutputParameter "^\s*cctrigger1" contained
syn match midiinOutputParameter "^\s*cctrigger2" contained
syn match midiinOutputParameter "^\s*cctrigger3" contained
syn match midiinOutputParameter "^\s*cctrigger4" contained
syn match midiinInputParameter "^\s*ch" contained
syn match midiinInputParameter "^\s*channel" contained
syn match midiinOutputParameter "^\s*clock" contained
syn match midiinOutputParameter "^\s*clock16" contained
syn match midiinOutputParameter "^\s*clock4" contained
syn match midiinOutputParameter "^\s*clock8" contained
syn match midiinOutputParameter "^\s*clock8t" contained
syn match midiinInputParameter "^\s*cn1" contained
syn match midiinInputParameter "^\s*cn2" contained
syn match midiinInputParameter "^\s*cn3" contained
syn match midiinInputParameter "^\s*cn4" contained
syn match midiinOutputParameter "^\s*co" contained
syn match midiinOutputParameter "^\s*continue" contained
syn match midiinOutputParameter "^\s*ct1" contained
syn match midiinOutputParameter "^\s*ct2" contained
syn match midiinOutputParameter "^\s*ct3" contained
syn match midiinOutputParameter "^\s*ct4" contained
syn match midiinOutputParameter "^\s*g1" contained
syn match midiinOutputParameter "^\s*g2" contained
syn match midiinOutputParameter "^\s*g3" contained
syn match midiinOutputParameter "^\s*g4" contained
syn match midiinOutputParameter "^\s*g5" contained
syn match midiinOutputParameter "^\s*g6" contained
syn match midiinOutputParameter "^\s*g7" contained
syn match midiinOutputParameter "^\s*g8" contained
syn match midiinOutputParameter "^\s*gate" contained
syn match midiinOutputParameter "^\s*gate1" contained
syn match midiinOutputParameter "^\s*gate2" contained
syn match midiinOutputParameter "^\s*gate3" contained
syn match midiinOutputParameter "^\s*gate4" contained
syn match midiinOutputParameter "^\s*gate5" contained
syn match midiinOutputParameter "^\s*gate6" contained
syn match midiinOutputParameter "^\s*gate7" contained
syn match midiinOutputParameter "^\s*gate8" contained
syn match midiinInputParameter "^\s*highestnote" contained
syn match midiinInputParameter "^\s*hn" contained
syn match midiinInputParameter "^\s*holdvelocity" contained
syn match midiinInputParameter "^\s*hv" contained
syn match midiinInputParameter "^\s*initialrunning" contained
syn match midiinInputParameter "^\s*ir" contained
syn match midiinInputParameter "^\s*ln" contained
syn match midiinInputParameter "^\s*lowestnote" contained
syn match midiinOutputParameter "^\s*mc" contained
syn match midiinOutputParameter "^\s*midiclock" contained
syn match midiinOutputParameter "^\s*modwheel" contained
syn match midiinInputParameter "^\s*n1" contained
syn match midiinInputParameter "^\s*n10" contained
syn match midiinInputParameter "^\s*n11" contained
syn match midiinInputParameter "^\s*n12" contained
syn match midiinInputParameter "^\s*n13" contained
syn match midiinInputParameter "^\s*n14" contained
syn match midiinInputParameter "^\s*n15" contained
syn match midiinInputParameter "^\s*n16" contained
syn match midiinInputParameter "^\s*n2" contained
syn match midiinInputParameter "^\s*n3" contained
syn match midiinInputParameter "^\s*n4" contained
syn match midiinInputParameter "^\s*n5" contained
syn match midiinInputParameter "^\s*n6" contained
syn match midiinInputParameter "^\s*n7" contained
syn match midiinInputParameter "^\s*n8" contained
syn match midiinInputParameter "^\s*n9" contained
syn match midiinOutputParameter "^\s*ng1" contained
syn match midiinOutputParameter "^\s*ng10" contained
syn match midiinOutputParameter "^\s*ng11" contained
syn match midiinOutputParameter "^\s*ng12" contained
syn match midiinOutputParameter "^\s*ng13" contained
syn match midiinOutputParameter "^\s*ng14" contained
syn match midiinOutputParameter "^\s*ng15" contained
syn match midiinOutputParameter "^\s*ng16" contained
syn match midiinOutputParameter "^\s*ng2" contained
syn match midiinOutputParameter "^\s*ng3" contained
syn match midiinOutputParameter "^\s*ng4" contained
syn match midiinOutputParameter "^\s*ng5" contained
syn match midiinOutputParameter "^\s*ng6" contained
syn match midiinOutputParameter "^\s*ng7" contained
syn match midiinOutputParameter "^\s*ng8" contained
syn match midiinOutputParameter "^\s*ng9" contained
syn match midiinInputParameter "^\s*ngp" contained
syn match midiinOutputParameter "^\s*ngv1" contained
syn match midiinOutputParameter "^\s*ngv10" contained
syn match midiinOutputParameter "^\s*ngv11" contained
syn match midiinOutputParameter "^\s*ngv12" contained
syn match midiinOutputParameter "^\s*ngv13" contained
syn match midiinOutputParameter "^\s*ngv14" contained
syn match midiinOutputParameter "^\s*ngv15" contained
syn match midiinOutputParameter "^\s*ngv16" contained
syn match midiinOutputParameter "^\s*ngv2" contained
syn match midiinOutputParameter "^\s*ngv3" contained
syn match midiinOutputParameter "^\s*ngv4" contained
syn match midiinOutputParameter "^\s*ngv5" contained
syn match midiinOutputParameter "^\s*ngv6" contained
syn match midiinOutputParameter "^\s*ngv7" contained
syn match midiinOutputParameter "^\s*ngv8" contained
syn match midiinOutputParameter "^\s*ngv9" contained
syn match midiinInputParameter "^\s*note" contained
syn match midiinInputParameter "^\s*note1" contained
syn match midiinInputParameter "^\s*note10" contained
syn match midiinInputParameter "^\s*note11" contained
syn match midiinInputParameter "^\s*note12" contained
syn match midiinInputParameter "^\s*note13" contained
syn match midiinInputParameter "^\s*note14" contained
syn match midiinInputParameter "^\s*note15" contained
syn match midiinInputParameter "^\s*note16" contained
syn match midiinInputParameter "^\s*note2" contained
syn match midiinInputParameter "^\s*note3" contained
syn match midiinInputParameter "^\s*note4" contained
syn match midiinInputParameter "^\s*note5" contained
syn match midiinInputParameter "^\s*note6" contained
syn match midiinInputParameter "^\s*note7" contained
syn match midiinInputParameter "^\s*note8" contained
syn match midiinInputParameter "^\s*note9" contained
syn match midiinInputParameter "^\s*notegap" contained
syn match midiinOutputParameter "^\s*notegate" contained
syn match midiinOutputParameter "^\s*notegate1" contained
syn match midiinOutputParameter "^\s*notegate10" contained
syn match midiinOutputParameter "^\s*notegate11" contained
syn match midiinOutputParameter "^\s*notegate12" contained
syn match midiinOutputParameter "^\s*notegate13" contained
syn match midiinOutputParameter "^\s*notegate14" contained
syn match midiinOutputParameter "^\s*notegate15" contained
syn match midiinOutputParameter "^\s*notegate16" contained
syn match midiinOutputParameter "^\s*notegate2" contained
syn match midiinOutputParameter "^\s*notegate3" contained
syn match midiinOutputParameter "^\s*notegate4" contained
syn match midiinOutputParameter "^\s*notegate5" contained
syn match midiinOutputParameter "^\s*notegate6" contained
syn match midiinOutputParameter "^\s*notegate7" contained
syn match midiinOutputParameter "^\s*notegate8" contained
syn match midiinOutputParameter "^\s*notegate9" contained
syn match midiinOutputParameter "^\s*notegatevelocity" contained
syn match midiinOutputParameter "^\s*notegatevelocity1" contained
syn match midiinOutputParameter "^\s*notegatevelocity10" contained
syn match midiinOutputParameter "^\s*notegatevelocity11" contained
syn match midiinOutputParameter "^\s*notegatevelocity12" contained
syn match midiinOutputParameter "^\s*notegatevelocity13" contained
syn match midiinOutputParameter "^\s*notegatevelocity14" contained
syn match midiinOutputParameter "^\s*notegatevelocity15" contained
syn match midiinOutputParameter "^\s*notegatevelocity16" contained
syn match midiinOutputParameter "^\s*notegatevelocity2" contained
syn match midiinOutputParameter "^\s*notegatevelocity3" contained
syn match midiinOutputParameter "^\s*notegatevelocity4" contained
syn match midiinOutputParameter "^\s*notegatevelocity5" contained
syn match midiinOutputParameter "^\s*notegatevelocity6" contained
syn match midiinOutputParameter "^\s*notegatevelocity7" contained
syn match midiinOutputParameter "^\s*notegatevelocity8" contained
syn match midiinOutputParameter "^\s*notegatevelocity9" contained
syn match midiinOutputParameter "^\s*p1" contained
syn match midiinOutputParameter "^\s*p2" contained
syn match midiinOutputParameter "^\s*p3" contained
syn match midiinOutputParameter "^\s*p4" contained
syn match midiinOutputParameter "^\s*p5" contained
syn match midiinOutputParameter "^\s*p6" contained
syn match midiinOutputParameter "^\s*p7" contained
syn match midiinOutputParameter "^\s*p8" contained
syn match midiinOutputParameter "^\s*pb" contained
syn match midiinInputParameter "^\s*pbr" contained
syn match midiinOutputParameter "^\s*pc" contained
syn match midiinOutputParameter "^\s*pitch" contained
syn match midiinOutputParameter "^\s*pitch1" contained
syn match midiinOutputParameter "^\s*pitch2" contained
syn match midiinOutputParameter "^\s*pitch3" contained
syn match midiinOutputParameter "^\s*pitch4" contained
syn match midiinOutputParameter "^\s*pitch5" contained
syn match midiinOutputParameter "^\s*pitch6" contained
syn match midiinOutputParameter "^\s*pitch7" contained
syn match midiinOutputParameter "^\s*pitch8" contained
syn match midiinOutputParameter "^\s*pitchbend" contained
syn match midiinInputParameter "^\s*pitchbendrange" contained
syn match midiinOutputParameter "^\s*pm" contained
syn match midiinOutputParameter "^\s*po" contained
syn match midiinOutputParameter "^\s*portamento" contained
syn match midiinOutputParameter "^\s*pr1" contained
syn match midiinOutputParameter "^\s*pr2" contained
syn match midiinOutputParameter "^\s*pr3" contained
syn match midiinOutputParameter "^\s*pr4" contained
syn match midiinOutputParameter "^\s*pr5" contained
syn match midiinOutputParameter "^\s*pr6" contained
syn match midiinOutputParameter "^\s*pr7" contained
syn match midiinOutputParameter "^\s*pr8" contained
syn match midiinOutputParameter "^\s*pressure" contained
syn match midiinOutputParameter "^\s*pressure1" contained
syn match midiinOutputParameter "^\s*pressure2" contained
syn match midiinOutputParameter "^\s*pressure3" contained
syn match midiinOutputParameter "^\s*pressure4" contained
syn match midiinOutputParameter "^\s*pressure5" contained
syn match midiinOutputParameter "^\s*pressure6" contained
syn match midiinOutputParameter "^\s*pressure7" contained
syn match midiinOutputParameter "^\s*pressure8" contained
syn match midiinOutputParameter "^\s*program" contained
syn match midiinOutputParameter "^\s*programchange" contained
syn match midiinInputParameter "^\s*roundrobin" contained
syn match midiinInputParameter "^\s*rr" contained
syn match midiinOutputParameter "^\s*ru" contained
syn match midiinOutputParameter "^\s*running" contained
syn match midiinOutputParameter "^\s*so" contained
syn match midiinOutputParameter "^\s*soft" contained
syn match midiinOutputParameter "^\s*sp" contained
syn match midiinInputParameter "^\s*sr" contained
syn match midiinOutputParameter "^\s*st" contained
syn match midiinOutputParameter "^\s*start" contained
syn match midiinOutputParameter "^\s*stop" contained
syn match midiinInputParameter "^\s*systemreset" contained
syn match midiinOutputParameter "^\s*t1" contained
syn match midiinOutputParameter "^\s*t2" contained
syn match midiinOutputParameter "^\s*t3" contained
syn match midiinOutputParameter "^\s*t4" contained
syn match midiinOutputParameter "^\s*t5" contained
syn match midiinOutputParameter "^\s*t6" contained
syn match midiinOutputParameter "^\s*t7" contained
syn match midiinOutputParameter "^\s*t8" contained
syn match midiinInputParameter "^\s*tm" contained
syn match midiinInputParameter "^\s*tp" contained
syn match midiinInputParameter "^\s*tr" contained
syn match midiinInputParameter "^\s*transpose" contained
syn match midiinOutputParameter "^\s*trigger" contained
syn match midiinOutputParameter "^\s*trigger1" contained
syn match midiinOutputParameter "^\s*trigger2" contained
syn match midiinOutputParameter "^\s*trigger3" contained
syn match midiinOutputParameter "^\s*trigger4" contained
syn match midiinOutputParameter "^\s*trigger5" contained
syn match midiinOutputParameter "^\s*trigger6" contained
syn match midiinOutputParameter "^\s*trigger7" contained
syn match midiinOutputParameter "^\s*trigger8" contained
syn match midiinInputParameter "^\s*trs" contained
syn match midiinInputParameter "^\s*tuningmode" contained
syn match midiinInputParameter "^\s*tuningpitch" contained
syn match midiinInputParameter "^\s*usb" contained
syn match midiinOutputParameter "^\s*v1" contained
syn match midiinOutputParameter "^\s*v2" contained
syn match midiinOutputParameter "^\s*v3" contained
syn match midiinOutputParameter "^\s*v4" contained
syn match midiinOutputParameter "^\s*v5" contained
syn match midiinOutputParameter "^\s*v6" contained
syn match midiinOutputParameter "^\s*v7" contained
syn match midiinOutputParameter "^\s*v8" contained
syn match midiinInputParameter "^\s*va" contained
syn match midiinOutputParameter "^\s*velocity" contained
syn match midiinOutputParameter "^\s*velocity1" contained
syn match midiinOutputParameter "^\s*velocity2" contained
syn match midiinOutputParameter "^\s*velocity3" contained
syn match midiinOutputParameter "^\s*velocity4" contained
syn match midiinOutputParameter "^\s*velocity5" contained
syn match midiinOutputParameter "^\s*velocity6" contained
syn match midiinOutputParameter "^\s*velocity7" contained
syn match midiinOutputParameter "^\s*velocity8" contained
syn match midiinOutputParameter "^\s*vo" contained
syn match midiinInputParameter "^\s*voiceallocation" contained
syn match midiinOutputParameter "^\s*volume" contained
syn match midiinOutputParameter "^\s*w" contained
syn match midiinHeader /\[midiin\]/ contained
syn region midiinCircuit start=/\[midiin\]/ end=/\[/me=s-1 transparent contains=midiinHeader,midiinInputParameter,midiinOutputParameter,ioregister,number,cable,quotestring,comment
hi def link midiinHeader circuitHeader
hi def link midiinInputParameter inputParameter
hi def link midiinOutputParameter outputParameter


" midiout
syn match midioutInputParameter "^\s*activesensing" contained
syn match midioutInputParameter "^\s*allnotesoff" contained
syn match midioutInputParameter "^\s*allsoundoff" contained
syn match midioutInputParameter "^\s*ao" contained
syn match midioutInputParameter "^\s*as" contained
syn match midioutInputParameter "^\s*aso" contained
syn match midioutInputParameter "^\s*ba" contained
syn match midioutInputParameter "^\s*bank" contained
syn match midioutInputParameter "^\s*c" contained
syn match midioutInputParameter "^\s*cc" contained
syn match midioutInputParameter "^\s*cc1" contained
syn match midioutInputParameter "^\s*cc2" contained
syn match midioutInputParameter "^\s*cc3" contained
syn match midioutInputParameter "^\s*cc4" contained
syn match midioutInputParameter "^\s*cc5" contained
syn match midioutInputParameter "^\s*cc6" contained
syn match midioutInputParameter "^\s*cc7" contained
syn match midioutInputParameter "^\s*cc8" contained
syn match midioutInputParameter "^\s*ccnumber" contained
syn match midioutInputParameter "^\s*ccnumber1" contained
syn match midioutInputParameter "^\s*ccnumber2" contained
syn match midioutInputParameter "^\s*ccnumber3" contained
syn match midioutInputParameter "^\s*ccnumber4" contained
syn match midioutInputParameter "^\s*ccnumber5" contained
syn match midioutInputParameter "^\s*ccnumber6" contained
syn match midioutInputParameter "^\s*ccnumber7" contained
syn match midioutInputParameter "^\s*ccnumber8" contained
syn match midioutInputParameter "^\s*cctrigger" contained
syn match midioutInputParameter "^\s*cctrigger1" contained
syn match midioutInputParameter "^\s*cctrigger2" contained
syn match midioutInputParameter "^\s*cctrigger3" contained
syn match midioutInputParameter "^\s*cctrigger4" contained
syn match midioutInputParameter "^\s*cctrigger5" contained
syn match midioutInputParameter "^\s*cctrigger6" contained
syn match midioutInputParameter "^\s*cctrigger7" contained
syn match midioutInputParameter "^\s*cctrigger8" contained
syn match midioutInputParameter "^\s*ch" contained
syn match midioutInputParameter "^\s*channel" contained
syn match midioutInputParameter "^\s*channelpressure" contained
syn match midioutInputParameter "^\s*clock" contained
syn match midioutInputParameter "^\s*cn1" contained
syn match midioutInputParameter "^\s*cn2" contained
syn match midioutInputParameter "^\s*cn3" contained
syn match midioutInputParameter "^\s*cn4" contained
syn match midioutInputParameter "^\s*cn5" contained
syn match midioutInputParameter "^\s*cn6" contained
syn match midioutInputParameter "^\s*cn7" contained
syn match midioutInputParameter "^\s*cn8" contained
syn match midioutInputParameter "^\s*cp" contained
syn match midioutInputParameter "^\s*ct1" contained
syn match midioutInputParameter "^\s*ct2" contained
syn match midioutInputParameter "^\s*ct3" contained
syn match midioutInputParameter "^\s*ct4" contained
syn match midioutInputParameter "^\s*ct5" contained
syn match midioutInputParameter "^\s*ct6" contained
syn match midioutInputParameter "^\s*ct7" contained
syn match midioutInputParameter "^\s*ct8" contained
syn match midioutInputParameter "^\s*damper" contained
syn match midioutInputParameter "^\s*dc" contained
syn match midioutInputParameter "^\s*delayinitialccs" contained
syn match midioutInputParameter "^\s*dp" contained
syn match midioutInputParameter "^\s*g1" contained
syn match midioutInputParameter "^\s*g2" contained
syn match midioutInputParameter "^\s*g3" contained
syn match midioutInputParameter "^\s*g4" contained
syn match midioutInputParameter "^\s*g5" contained
syn match midioutInputParameter "^\s*g6" contained
syn match midioutInputParameter "^\s*g7" contained
syn match midioutInputParameter "^\s*g8" contained
syn match midioutInputParameter "^\s*gate" contained
syn match midioutInputParameter "^\s*gate1" contained
syn match midioutInputParameter "^\s*gate2" contained
syn match midioutInputParameter "^\s*gate3" contained
syn match midioutInputParameter "^\s*gate4" contained
syn match midioutInputParameter "^\s*gate5" contained
syn match midioutInputParameter "^\s*gate6" contained
syn match midioutInputParameter "^\s*gate7" contained
syn match midioutInputParameter "^\s*gate8" contained
syn match midioutInputParameter "^\s*highestnote" contained
syn match midioutInputParameter "^\s*hn" contained
syn match midioutInputParameter "^\s*legato" contained
syn match midioutInputParameter "^\s*lg" contained
syn match midioutInputParameter "^\s*ln" contained
syn match midioutInputParameter "^\s*lowestnote" contained
syn match midioutInputParameter "^\s*mc" contained
syn match midioutInputParameter "^\s*midiclock" contained
syn match midioutInputParameter "^\s*modwheel" contained
syn match midioutInputParameter "^\s*n1" contained
syn match midioutInputParameter "^\s*n10" contained
syn match midioutInputParameter "^\s*n11" contained
syn match midioutInputParameter "^\s*n12" contained
syn match midioutInputParameter "^\s*n13" contained
syn match midioutInputParameter "^\s*n14" contained
syn match midioutInputParameter "^\s*n15" contained
syn match midioutInputParameter "^\s*n16" contained
syn match midioutInputParameter "^\s*n2" contained
syn match midioutInputParameter "^\s*n3" contained
syn match midioutInputParameter "^\s*n4" contained
syn match midioutInputParameter "^\s*n5" contained
syn match midioutInputParameter "^\s*n6" contained
syn match midioutInputParameter "^\s*n7" contained
syn match midioutInputParameter "^\s*n8" contained
syn match midioutInputParameter "^\s*n9" contained
syn match midioutInputParameter "^\s*ng1" contained
syn match midioutInputParameter "^\s*ng10" contained
syn match midioutInputParameter "^\s*ng11" contained
syn match midioutInputParameter "^\s*ng12" contained
syn match midioutInputParameter "^\s*ng13" contained
syn match midioutInputParameter "^\s*ng14" contained
syn match midioutInputParameter "^\s*ng15" contained
syn match midioutInputParameter "^\s*ng16" contained
syn match midioutInputParameter "^\s*ng2" contained
syn match midioutInputParameter "^\s*ng3" contained
syn match midioutInputParameter "^\s*ng4" contained
syn match midioutInputParameter "^\s*ng5" contained
syn match midioutInputParameter "^\s*ng6" contained
syn match midioutInputParameter "^\s*ng7" contained
syn match midioutInputParameter "^\s*ng8" contained
syn match midioutInputParameter "^\s*ng9" contained
syn match midioutInputParameter "^\s*ngv1" contained
syn match midioutInputParameter "^\s*ngv10" contained
syn match midioutInputParameter "^\s*ngv11" contained
syn match midioutInputParameter "^\s*ngv12" contained
syn match midioutInputParameter "^\s*ngv13" contained
syn match midioutInputParameter "^\s*ngv14" contained
syn match midioutInputParameter "^\s*ngv15" contained
syn match midioutInputParameter "^\s*ngv16" contained
syn match midioutInputParameter "^\s*ngv2" contained
syn match midioutInputParameter "^\s*ngv3" contained
syn match midioutInputParameter "^\s*ngv4" contained
syn match midioutInputParameter "^\s*ngv5" contained
syn match midioutInputParameter "^\s*ngv6" contained
syn match midioutInputParameter "^\s*ngv7" contained
syn match midioutInputParameter "^\s*ngv8" contained
syn match midioutInputParameter "^\s*ngv9" contained
syn match midioutInputParameter "^\s*note" contained
syn match midioutInputParameter "^\s*note1" contained
syn match midioutInputParameter "^\s*note10" contained
syn match midioutInputParameter "^\s*note11" contained
syn match midioutInputParameter "^\s*note12" contained
syn match midioutInputParameter "^\s*note13" contained
syn match midioutInputParameter "^\s*note14" contained
syn match midioutInputParameter "^\s*note15" contained
syn match midioutInputParameter "^\s*note16" contained
syn match midioutInputParameter "^\s*note2" contained
syn match midioutInputParameter "^\s*note3" contained
syn match midioutInputParameter "^\s*note4" contained
syn match midioutInputParameter "^\s*note5" contained
syn match midioutInputParameter "^\s*note6" contained
syn match midioutInputParameter "^\s*note7" contained
syn match midioutInputParameter "^\s*note8" contained
syn match midioutInputParameter "^\s*note9" contained
syn match midioutInputParameter "^\s*notegate" contained
syn match midioutInputParameter "^\s*notegate1" contained
syn match midioutInputParameter "^\s*notegate10" contained
syn match midioutInputParameter "^\s*notegate11" contained
syn match midioutInputParameter "^\s*notegate12" contained
syn match midioutInputParameter "^\s*notegate13" contained
syn match midioutInputParameter "^\s*notegate14" contained
syn match midioutInputParameter "^\s*notegate15" contained
syn match midioutInputParameter "^\s*notegate16" contained
syn match midioutInputParameter "^\s*notegate2" contained
syn match midioutInputParameter "^\s*notegate3" contained
syn match midioutInputParameter "^\s*notegate4" contained
syn match midioutInputParameter "^\s*notegate5" contained
syn match midioutInputParameter "^\s*notegate6" contained
syn match midioutInputParameter "^\s*notegate7" contained
syn match midioutInputParameter "^\s*notegate8" contained
syn match midioutInputParameter "^\s*notegate9" contained
syn match midioutInputParameter "^\s*notegatevelocity" contained
syn match midioutInputParameter "^\s*notegatevelocity1" contained
syn match midioutInputParameter "^\s*notegatevelocity10" contained
syn match midioutInputParameter "^\s*notegatevelocity11" contained
syn match midioutInputParameter "^\s*notegatevelocity12" contained
syn match midioutInputParameter "^\s*notegatevelocity13" contained
syn match midioutInputParameter "^\s*notegatevelocity14" contained
syn match midioutInputParameter "^\s*notegatevelocity15" contained
syn match midioutInputParameter "^\s*notegatevelocity16" contained
syn match midioutInputParameter "^\s*notegatevelocity2" contained
syn match midioutInputParameter "^\s*notegatevelocity3" contained
syn match midioutInputParameter "^\s*notegatevelocity4" contained
syn match midioutInputParameter "^\s*notegatevelocity5" contained
syn match midioutInputParameter "^\s*notegatevelocity6" contained
syn match midioutInputParameter "^\s*notegatevelocity7" contained
syn match midioutInputParameter "^\s*notegatevelocity8" contained
syn match midioutInputParameter "^\s*notegatevelocity9" contained
syn match midioutInputParameter "^\s*noteoffvelocity" contained
syn match midioutInputParameter "^\s*noteoffvelocity1" contained
syn match midioutInputParameter "^\s*noteoffvelocity2" contained
syn match midioutInputParameter "^\s*noteoffvelocity3" contained
syn match midioutInputParameter "^\s*noteoffvelocity4" contained
syn match midioutInputParameter "^\s*noteoffvelocity5" contained
syn match midioutInputParameter "^\s*noteoffvelocity6" contained
syn match midioutInputParameter "^\s*noteoffvelocity7" contained
syn match midioutInputParameter "^\s*noteoffvelocity8" contained
syn match midioutInputParameter "^\s*nv1" contained
syn match midioutInputParameter "^\s*nv2" contained
syn match midioutInputParameter "^\s*nv3" contained
syn match midioutInputParameter "^\s*nv4" contained
syn match midioutInputParameter "^\s*nv5" contained
syn match midioutInputParameter "^\s*nv6" contained
syn match midioutInputParameter "^\s*nv7" contained
syn match midioutInputParameter "^\s*nv8" contained
syn match midioutInputParameter "^\s*p1" contained
syn match midioutInputParameter "^\s*p2" contained
syn match midioutInputParameter "^\s*p3" contained
syn match midioutInputParameter "^\s*p4" contained
syn match midioutInputParameter "^\s*p5" contained
syn match midioutInputParameter "^\s*p6" contained
syn match midioutInputParameter "^\s*p7" contained
syn match midioutInputParameter "^\s*p8" contained
syn match midioutInputParameter "^\s*pb" contained
syn match midioutInputParameter "^\s*pbr" contained
syn match midioutInputParameter "^\s*pc" contained
syn match midioutInputParameter "^\s*pitch" contained
syn match midioutInputParameter "^\s*pitch1" contained
syn match midioutInputParameter "^\s*pitch2" contained
syn match midioutInputParameter "^\s*pitch3" contained
syn match midioutInputParameter "^\s*pitch4" contained
syn match midioutInputParameter "^\s*pitch5" contained
syn match midioutInputParameter "^\s*pitch6" contained
syn match midioutInputParameter "^\s*pitch7" contained
syn match midioutInputParameter "^\s*pitch8" contained
syn match midioutInputParameter "^\s*pitchbend" contained
syn match midioutInputParameter "^\s*pitchbendrange" contained
syn match midioutInputParameter "^\s*pitchstabilization" contained
syn match midioutInputParameter "^\s*pitchtracking" contained
syn match midioutInputParameter "^\s*pm" contained
syn match midioutInputParameter "^\s*po" contained
syn match midioutInputParameter "^\s*portamento" contained
syn match midioutInputParameter "^\s*pr1" contained
syn match midioutInputParameter "^\s*pr2" contained
syn match midioutInputParameter "^\s*pr3" contained
syn match midioutInputParameter "^\s*pr4" contained
syn match midioutInputParameter "^\s*pr5" contained
syn match midioutInputParameter "^\s*pr6" contained
syn match midioutInputParameter "^\s*pr7" contained
syn match midioutInputParameter "^\s*pr8" contained
syn match midioutInputParameter "^\s*pressure" contained
syn match midioutInputParameter "^\s*pressure1" contained
syn match midioutInputParameter "^\s*pressure2" contained
syn match midioutInputParameter "^\s*pressure3" contained
syn match midioutInputParameter "^\s*pressure4" contained
syn match midioutInputParameter "^\s*pressure5" contained
syn match midioutInputParameter "^\s*pressure6" contained
syn match midioutInputParameter "^\s*pressure7" contained
syn match midioutInputParameter "^\s*pressure8" contained
syn match midioutInputParameter "^\s*program" contained
syn match midioutInputParameter "^\s*programchange" contained
syn match midioutInputParameter "^\s*ps" contained
syn match midioutInputParameter "^\s*pt" contained
syn match midioutInputParameter "^\s*ru" contained
syn match midioutInputParameter "^\s*running" contained
syn match midioutInputParameter "^\s*s" contained
syn match midioutInputParameter "^\s*sa" contained
syn match midioutInputParameter "^\s*select" contained
syn match midioutInputParameter "^\s*selectat" contained
syn match midioutInputParameter "^\s*so" contained
syn match midioutInputParameter "^\s*soft" contained
syn match midioutInputParameter "^\s*sostenuto" contained
syn match midioutInputParameter "^\s*sp" contained
syn match midioutInputParameter "^\s*sr" contained
syn match midioutInputParameter "^\s*st" contained
syn match midioutInputParameter "^\s*start" contained
syn match midioutInputParameter "^\s*stop" contained
syn match midioutInputParameter "^\s*su" contained
syn match midioutInputParameter "^\s*systemreset" contained
syn match midioutInputParameter "^\s*td" contained
syn match midioutInputParameter "^\s*triggerdelay" contained
syn match midioutInputParameter "^\s*trs" contained
syn match midioutInputParameter "^\s*uc" contained
syn match midioutInputParameter "^\s*updateccs" contained
syn match midioutInputParameter "^\s*updaterate" contained
syn match midioutInputParameter "^\s*ur" contained
syn match midioutInputParameter "^\s*usb" contained
syn match midioutInputParameter "^\s*v1" contained
syn match midioutInputParameter "^\s*v2" contained
syn match midioutInputParameter "^\s*v3" contained
syn match midioutInputParameter "^\s*v4" contained
syn match midioutInputParameter "^\s*v5" contained
syn match midioutInputParameter "^\s*v6" contained
syn match midioutInputParameter "^\s*v7" contained
syn match midioutInputParameter "^\s*v8" contained
syn match midioutInputParameter "^\s*velocity" contained
syn match midioutInputParameter "^\s*velocity1" contained
syn match midioutInputParameter "^\s*velocity2" contained
syn match midioutInputParameter "^\s*velocity3" contained
syn match midioutInputParameter "^\s*velocity4" contained
syn match midioutInputParameter "^\s*velocity5" contained
syn match midioutInputParameter "^\s*velocity6" contained
syn match midioutInputParameter "^\s*velocity7" contained
syn match midioutInputParameter "^\s*velocity8" contained
syn match midioutInputParameter "^\s*vo" contained
syn match midioutInputParameter "^\s*volume" contained
syn match midioutInputParameter "^\s*w" contained
syn match midioutHeader /\[midiout\]/ contained
syn region midioutCircuit start=/\[midiout\]/ end=/\[/me=s-1 transparent contains=midioutHeader,midioutInputParameter,midioutOutputParameter,ioregister,number,cable,quotestring,comment
hi def link midioutHeader circuitHeader
hi def link midioutInputParameter inputParameter
hi def link midioutOutputParameter outputParameter


" midithrough
syn match midithroughInputParameter "^\s*fromtrs" contained
syn match midithroughInputParameter "^\s*fromusb" contained
syn match midithroughInputParameter "^\s*ft" contained
syn match midithroughInputParameter "^\s*fu" contained
syn match midithroughInputParameter "^\s*totrs" contained
syn match midithroughInputParameter "^\s*tousb" contained
syn match midithroughInputParameter "^\s*tt" contained
syn match midithroughInputParameter "^\s*tu" contained
syn match midithroughHeader /\[midithrough\]/ contained
syn region midithroughCircuit start=/\[midithrough\]/ end=/\[/me=s-1 transparent contains=midithroughHeader,midithroughInputParameter,midithroughOutputParameter,ioregister,number,cable,quotestring,comment
hi def link midithroughHeader circuitHeader
hi def link midithroughInputParameter inputParameter
hi def link midithroughOutputParameter outputParameter


" minifonion
syn match minifonionInputParameter "^\s*b" contained
syn match minifonionInputParameter "^\s*bypass" contained
syn match minifonionInputParameter "^\s*d" contained
syn match minifonionInputParameter "^\s*degree" contained
syn match minifonionInputParameter "^\s*dg" contained
syn match minifonionInputParameter "^\s*direction" contained
syn match minifonionInputParameter "^\s*harmonicshift" contained
syn match minifonionInputParameter "^\s*has" contained
syn match minifonionInputParameter "^\s*i" contained
syn match minifonionInputParameter "^\s*input" contained
syn match minifonionOutputParameter "^\s*n" contained
syn match minifonionInputParameter "^\s*nos" contained
syn match minifonionOutputParameter "^\s*notechange" contained
syn match minifonionInputParameter "^\s*noteshift" contained
syn match minifonionOutputParameter "^\s*o" contained
syn match minifonionOutputParameter "^\s*output" contained
syn match minifonionInputParameter "^\s*ro" contained
syn match minifonionInputParameter "^\s*root" contained
syn match minifonionInputParameter "^\s*s1" contained
syn match minifonionInputParameter "^\s*s11" contained
syn match minifonionInputParameter "^\s*s13" contained
syn match minifonionInputParameter "^\s*s3" contained
syn match minifonionInputParameter "^\s*s5" contained
syn match minifonionInputParameter "^\s*s7" contained
syn match minifonionInputParameter "^\s*s9" contained
syn match minifonionInputParameter "^\s*select1" contained
syn match minifonionInputParameter "^\s*select11" contained
syn match minifonionInputParameter "^\s*select13" contained
syn match minifonionInputParameter "^\s*select3" contained
syn match minifonionInputParameter "^\s*select5" contained
syn match minifonionInputParameter "^\s*select7" contained
syn match minifonionInputParameter "^\s*select9" contained
syn match minifonionInputParameter "^\s*selectfill1" contained
syn match minifonionInputParameter "^\s*selectfill2" contained
syn match minifonionInputParameter "^\s*selectfill3" contained
syn match minifonionInputParameter "^\s*selectfill4" contained
syn match minifonionInputParameter "^\s*selectfill5" contained
syn match minifonionInputParameter "^\s*selectnoteshift" contained
syn match minifonionInputParameter "^\s*sf1" contained
syn match minifonionInputParameter "^\s*sf2" contained
syn match minifonionInputParameter "^\s*sf3" contained
syn match minifonionInputParameter "^\s*sf4" contained
syn match minifonionInputParameter "^\s*sf5" contained
syn match minifonionInputParameter "^\s*sns" contained
syn match minifonionInputParameter "^\s*t" contained
syn match minifonionInputParameter "^\s*tm" contained
syn match minifonionInputParameter "^\s*tp" contained
syn match minifonionInputParameter "^\s*tr" contained
syn match minifonionInputParameter "^\s*transpose" contained
syn match minifonionInputParameter "^\s*trigger" contained
syn match minifonionInputParameter "^\s*tuningmode" contained
syn match minifonionInputParameter "^\s*tuningpitch" contained
syn match minifonionHeader /\[minifonion\]/ contained
syn region minifonionCircuit start=/\[minifonion\]/ end=/\[/me=s-1 transparent contains=minifonionHeader,minifonionInputParameter,minifonionOutputParameter,ioregister,number,cable,quotestring,comment
hi def link minifonionHeader circuitHeader
hi def link minifonionInputParameter inputParameter
hi def link minifonionOutputParameter outputParameter


" mixer
syn match mixerOutputParameter "^\s*a" contained
syn match mixerOutputParameter "^\s*average" contained
syn match mixerInputParameter "^\s*i1" contained
syn match mixerInputParameter "^\s*i2" contained
syn match mixerInputParameter "^\s*i3" contained
syn match mixerInputParameter "^\s*i4" contained
syn match mixerInputParameter "^\s*i5" contained
syn match mixerInputParameter "^\s*i6" contained
syn match mixerInputParameter "^\s*i7" contained
syn match mixerInputParameter "^\s*i8" contained
syn match mixerInputParameter "^\s*input" contained
syn match mixerInputParameter "^\s*input1" contained
syn match mixerInputParameter "^\s*input2" contained
syn match mixerInputParameter "^\s*input3" contained
syn match mixerInputParameter "^\s*input4" contained
syn match mixerInputParameter "^\s*input5" contained
syn match mixerInputParameter "^\s*input6" contained
syn match mixerInputParameter "^\s*input7" contained
syn match mixerInputParameter "^\s*input8" contained
syn match mixerOutputParameter "^\s*m" contained
syn match mixerOutputParameter "^\s*maximum" contained
syn match mixerOutputParameter "^\s*minimum" contained
syn match mixerOutputParameter "^\s*o" contained
syn match mixerOutputParameter "^\s*output" contained
syn match mixerOutputParameter "^\s*x" contained
syn match mixerHeader /\[mixer\]/ contained
syn region mixerCircuit start=/\[mixer\]/ end=/\[/me=s-1 transparent contains=mixerHeader,mixerInputParameter,mixerOutputParameter,ioregister,number,cable,quotestring,comment
hi def link mixerHeader circuitHeader
hi def link mixerInputParameter inputParameter
hi def link mixerOutputParameter outputParameter


" motoquencer
syn match motoquencerInputParameter "^\s*ac" contained
syn match motoquencerOutputParameter "^\s*acc" contained
syn match motoquencerOutputParameter "^\s*accumulator" contained
syn match motoquencerInputParameter "^\s*accumulatorrange" contained
syn match motoquencerInputParameter "^\s*ar" contained
syn match motoquencerInputParameter "^\s*autoreset" contained
syn match motoquencerInputParameter "^\s*bc" contained
syn match motoquencerInputParameter "^\s*be" contained
syn match motoquencerInputParameter "^\s*bm" contained
syn match motoquencerInputParameter "^\s*bulkedit" contained
syn match motoquencerInputParameter "^\s*buttoncolor" contained
syn match motoquencerInputParameter "^\s*buttonmode" contained
syn match motoquencerInputParameter "^\s*c" contained
syn match motoquencerInputParameter "^\s*ca" contained
syn match motoquencerInputParameter "^\s*cb" contained
syn match motoquencerInputParameter "^\s*ce" contained
syn match motoquencerInputParameter "^\s*cl" contained
syn match motoquencerInputParameter "^\s*clear" contained
syn match motoquencerInputParameter "^\s*clearall" contained
syn match motoquencerInputParameter "^\s*clearrepeats" contained
syn match motoquencerInputParameter "^\s*clearskips" contained
syn match motoquencerInputParameter "^\s*clearstartend" contained
syn match motoquencerInputParameter "^\s*clock" contained
syn match motoquencerInputParameter "^\s*cm" contained
syn match motoquencerInputParameter "^\s*cn" contained
syn match motoquencerInputParameter "^\s*co" contained
syn match motoquencerInputParameter "^\s*composemode" contained
syn match motoquencerInputParameter "^\s*constantlength" contained
syn match motoquencerInputParameter "^\s*copy" contained
syn match motoquencerOutputParameter "^\s*cpg" contained
syn match motoquencerInputParameter "^\s*cr" contained
syn match motoquencerInputParameter "^\s*crp" contained
syn match motoquencerInputParameter "^\s*cs" contained
syn match motoquencerInputParameter "^\s*cse" contained
syn match motoquencerOutputParameter "^\s*cst" contained
syn match motoquencerOutputParameter "^\s*currentpage" contained
syn match motoquencerOutputParameter "^\s*currentstep" contained
syn match motoquencerOutputParameter "^\s*cv" contained
syn match motoquencerInputParameter "^\s*cvbase" contained
syn match motoquencerInputParameter "^\s*cvname" contained
syn match motoquencerInputParameter "^\s*cvnotches" contained
syn match motoquencerInputParameter "^\s*cvrange" contained
syn match motoquencerInputParameter "^\s*cy" contained
syn match motoquencerInputParameter "^\s*d" contained
syn match motoquencerInputParameter "^\s*dc" contained
syn match motoquencerInputParameter "^\s*defaultcv" contained
syn match motoquencerInputParameter "^\s*defaultgate" contained
syn match motoquencerInputParameter "^\s*degree" contained
syn match motoquencerInputParameter "^\s*dfg" contained
syn match motoquencerInputParameter "^\s*dg" contained
syn match motoquencerInputParameter "^\s*direction" contained
syn match motoquencerInputParameter "^\s*display" contained
syn match motoquencerInputParameter "^\s*dontsave" contained
syn match motoquencerInputParameter "^\s*dos" contained
syn match motoquencerInputParameter "^\s*doublerange" contained
syn match motoquencerInputParameter "^\s*dr" contained
syn match motoquencerInputParameter "^\s*dy" contained
syn match motoquencerInputParameter "^\s*endstep" contained
syn match motoquencerOutputParameter "^\s*endstepout" contained
syn match motoquencerInputParameter "^\s*es" contained
syn match motoquencerOutputParameter "^\s*eso" contained
syn match motoquencerInputParameter "^\s*f" contained
syn match motoquencerInputParameter "^\s*fadermode" contained
syn match motoquencerInputParameter "^\s*firstfader" contained
syn match motoquencerInputParameter "^\s*fm" contained
syn match motoquencerInputParameter "^\s*fo" contained
syn match motoquencerInputParameter "^\s*form" contained
syn match motoquencerOutputParameter "^\s*g" contained
syn match motoquencerOutputParameter "^\s*gate" contained
syn match motoquencerInputParameter "^\s*gatelength" contained
syn match motoquencerInputParameter "^\s*gatename" contained
syn match motoquencerInputParameter "^\s*gl" contained
syn match motoquencerInputParameter "^\s*gn" contained
syn match motoquencerInputParameter "^\s*harmonicshift" contained
syn match motoquencerInputParameter "^\s*has" contained
syn match motoquencerInputParameter "^\s*hc" contained
syn match motoquencerInputParameter "^\s*holdcv" contained
syn match motoquencerInputParameter "^\s*invert" contained
syn match motoquencerInputParameter "^\s*iv" contained
syn match motoquencerInputParameter "^\s*kc" contained
syn match motoquencerInputParameter "^\s*keyboardcv" contained
syn match motoquencerInputParameter "^\s*keyboardgate" contained
syn match motoquencerInputParameter "^\s*keyboardmode" contained
syn match motoquencerInputParameter "^\s*kg" contained
syn match motoquencerInputParameter "^\s*km" contained
syn match motoquencerInputParameter "^\s*la" contained
syn match motoquencerInputParameter "^\s*lb" contained
syn match motoquencerInputParameter "^\s*lc" contained
syn match motoquencerInputParameter "^\s*lcv" contained
syn match motoquencerInputParameter "^\s*ld" contained
syn match motoquencerInputParameter "^\s*lf" contained
syn match motoquencerInputParameter "^\s*lg" contained
syn match motoquencerInputParameter "^\s*lga" contained
syn match motoquencerInputParameter "^\s*lgp" contained
syn match motoquencerInputParameter "^\s*li" contained
syn match motoquencerInputParameter "^\s*linktonext" contained
syn match motoquencerInputParameter "^\s*lk" contained
syn match motoquencerInputParameter "^\s*ln" contained
syn match motoquencerInputParameter "^\s*loadpreset" contained
syn match motoquencerInputParameter "^\s*lp" contained
syn match motoquencerInputParameter "^\s*lr" contained
syn match motoquencerInputParameter "^\s*lrc" contained
syn match motoquencerInputParameter "^\s*lrp" contained
syn match motoquencerInputParameter "^\s*lrt" contained
syn match motoquencerInputParameter "^\s*lrv" contained
syn match motoquencerInputParameter "^\s*ls" contained
syn match motoquencerInputParameter "^\s*lsh" contained
syn match motoquencerInputParameter "^\s*lt" contained
syn match motoquencerInputParameter "^\s*luckyamount" contained
syn match motoquencerInputParameter "^\s*luckybuttons" contained
syn match motoquencerInputParameter "^\s*luckychance" contained
syn match motoquencerInputParameter "^\s*luckycvbase" contained
syn match motoquencerInputParameter "^\s*luckycvdrift" contained
syn match motoquencerInputParameter "^\s*luckycvs" contained
syn match motoquencerInputParameter "^\s*luckyfaders" contained
syn match motoquencerInputParameter "^\s*luckygatepattern" contained
syn match motoquencerInputParameter "^\s*luckygateprob" contained
syn match motoquencerInputParameter "^\s*luckygates" contained
syn match motoquencerInputParameter "^\s*luckyinvert" contained
syn match motoquencerInputParameter "^\s*luckyrandomizecv" contained
syn match motoquencerInputParameter "^\s*luckyratchets" contained
syn match motoquencerInputParameter "^\s*luckyrepeats" contained
syn match motoquencerInputParameter "^\s*luckyreverse" contained
syn match motoquencerInputParameter "^\s*luckyscope" contained
syn match motoquencerInputParameter "^\s*luckyshuffle" contained
syn match motoquencerInputParameter "^\s*luckyskips" contained
syn match motoquencerInputParameter "^\s*luckyspread" contained
syn match motoquencerInputParameter "^\s*luckyties" contained
syn match motoquencerInputParameter "^\s*lv" contained
syn match motoquencerInputParameter "^\s*m" contained
syn match motoquencerInputParameter "^\s*metricsaver" contained
syn match motoquencerInputParameter "^\s*ms" contained
syn match motoquencerInputParameter "^\s*mute" contained
syn match motoquencerInputParameter "^\s*n" contained
syn match motoquencerInputParameter "^\s*nos" contained
syn match motoquencerInputParameter "^\s*noteshift" contained
syn match motoquencerInputParameter "^\s*ns" contained
syn match motoquencerInputParameter "^\s*numfaders" contained
syn match motoquencerInputParameter "^\s*numsteps" contained
syn match motoquencerInputParameter "^\s*p" contained
syn match motoquencerInputParameter "^\s*pa" contained
syn match motoquencerInputParameter "^\s*page" contained
syn match motoquencerInputParameter "^\s*paste" contained
syn match motoquencerInputParameter "^\s*pastebuttons" contained
syn match motoquencerInputParameter "^\s*pastefaders" contained
syn match motoquencerInputParameter "^\s*pattern" contained
syn match motoquencerInputParameter "^\s*pb" contained
syn match motoquencerInputParameter "^\s*pf" contained
syn match motoquencerInputParameter "^\s*pingpong" contained
syn match motoquencerInputParameter "^\s*pp" contained
syn match motoquencerInputParameter "^\s*pr" contained
syn match motoquencerInputParameter "^\s*preset" contained
syn match motoquencerInputParameter "^\s*pt" contained
syn match motoquencerInputParameter "^\s*q" contained
syn match motoquencerInputParameter "^\s*quantize" contained
syn match motoquencerInputParameter "^\s*r" contained
syn match motoquencerInputParameter "^\s*ras" contained
syn match motoquencerInputParameter "^\s*ratchetshift" contained
syn match motoquencerInputParameter "^\s*recordmode" contained
syn match motoquencerInputParameter "^\s*recordsilence" contained
syn match motoquencerInputParameter "^\s*repeatshift" contained
syn match motoquencerInputParameter "^\s*reset" contained
syn match motoquencerInputParameter "^\s*rm" contained
syn match motoquencerInputParameter "^\s*ro" contained
syn match motoquencerInputParameter "^\s*root" contained
syn match motoquencerInputParameter "^\s*rs" contained
syn match motoquencerInputParameter "^\s*rsi" contained
syn match motoquencerInputParameter "^\s*ru" contained
syn match motoquencerInputParameter "^\s*run" contained
syn match motoquencerInputParameter "^\s*s" contained
syn match motoquencerInputParameter "^\s*s1" contained
syn match motoquencerInputParameter "^\s*s11" contained
syn match motoquencerInputParameter "^\s*s13" contained
syn match motoquencerInputParameter "^\s*s3" contained
syn match motoquencerInputParameter "^\s*s5" contained
syn match motoquencerInputParameter "^\s*s7" contained
syn match motoquencerInputParameter "^\s*s9" contained
syn match motoquencerInputParameter "^\s*sa" contained
syn match motoquencerInputParameter "^\s*savepreset" contained
syn match motoquencerInputParameter "^\s*sc" contained
syn match motoquencerInputParameter "^\s*select" contained
syn match motoquencerInputParameter "^\s*select1" contained
syn match motoquencerInputParameter "^\s*select11" contained
syn match motoquencerInputParameter "^\s*select13" contained
syn match motoquencerInputParameter "^\s*select3" contained
syn match motoquencerInputParameter "^\s*select5" contained
syn match motoquencerInputParameter "^\s*select7" contained
syn match motoquencerInputParameter "^\s*select9" contained
syn match motoquencerInputParameter "^\s*selectat" contained
syn match motoquencerInputParameter "^\s*selectfill1" contained
syn match motoquencerInputParameter "^\s*selectfill2" contained
syn match motoquencerInputParameter "^\s*selectfill3" contained
syn match motoquencerInputParameter "^\s*selectfill4" contained
syn match motoquencerInputParameter "^\s*selectfill5" contained
syn match motoquencerInputParameter "^\s*selectnoteshift" contained
syn match motoquencerInputParameter "^\s*ses" contained
syn match motoquencerInputParameter "^\s*setendstep" contained
syn match motoquencerInputParameter "^\s*sf1" contained
syn match motoquencerInputParameter "^\s*sf2" contained
syn match motoquencerInputParameter "^\s*sf3" contained
syn match motoquencerInputParameter "^\s*sf4" contained
syn match motoquencerInputParameter "^\s*sf5" contained
syn match motoquencerInputParameter "^\s*sh" contained
syn match motoquencerInputParameter "^\s*shiftsteps" contained
syn match motoquencerInputParameter "^\s*sns" contained
syn match motoquencerInputParameter "^\s*sp" contained
syn match motoquencerOutputParameter "^\s*spa" contained
syn match motoquencerInputParameter "^\s*ss" contained
syn match motoquencerOutputParameter "^\s*sso" contained
syn match motoquencerOutputParameter "^\s*ssq" contained
syn match motoquencerOutputParameter "^\s*startofpart" contained
syn match motoquencerOutputParameter "^\s*startofsequence" contained
syn match motoquencerInputParameter "^\s*startstep" contained
syn match motoquencerOutputParameter "^\s*startstepout" contained
syn match motoquencerInputParameter "^\s*stepcopy" contained
syn match motoquencerInputParameter "^\s*taptempo" contained
syn match motoquencerInputParameter "^\s*tm" contained
syn match motoquencerInputParameter "^\s*tp" contained
syn match motoquencerInputParameter "^\s*tr" contained
syn match motoquencerInputParameter "^\s*transpose" contained
syn match motoquencerInputParameter "^\s*tt" contained
syn match motoquencerInputParameter "^\s*tuningmode" contained
syn match motoquencerInputParameter "^\s*tuningpitch" contained
syn match motoquencerHeader /\[motoquencer\]/ contained
syn region motoquencerCircuit start=/\[motoquencer\]/ end=/\[/me=s-1 transparent contains=motoquencerHeader,motoquencerInputParameter,motoquencerOutputParameter,ioregister,number,cable,quotestring,comment
hi def link motoquencerHeader circuitHeader
hi def link motoquencerInputParameter inputParameter
hi def link motoquencerOutputParameter outputParameter


" motorfader
syn match motorfaderOutputParameter "^\s*b" contained
syn match motorfaderOutputParameter "^\s*button" contained
syn match motorfaderInputParameter "^\s*ca" contained
syn match motorfaderInputParameter "^\s*cl" contained
syn match motorfaderInputParameter "^\s*clear" contained
syn match motorfaderInputParameter "^\s*clearall" contained
syn match motorfaderInputParameter "^\s*display" contained
syn match motorfaderInputParameter "^\s*dontsave" contained
syn match motorfaderInputParameter "^\s*dos" contained
syn match motorfaderInputParameter "^\s*dy" contained
syn match motorfaderInputParameter "^\s*f" contained
syn match motorfaderInputParameter "^\s*fader" contained
syn match motorfaderInputParameter "^\s*header" contained
syn match motorfaderInputParameter "^\s*hr" contained
syn match motorfaderInputParameter "^\s*lc" contained
syn match motorfaderInputParameter "^\s*ledcolor" contained
syn match motorfaderInputParameter "^\s*ledvalue" contained
syn match motorfaderInputParameter "^\s*loadpreset" contained
syn match motorfaderInputParameter "^\s*lp" contained
syn match motorfaderInputParameter "^\s*lv" contained
syn match motorfaderInputParameter "^\s*n" contained
syn match motorfaderInputParameter "^\s*notches" contained
syn match motorfaderOutputParameter "^\s*o" contained
syn match motorfaderInputParameter "^\s*oo" contained
syn match motorfaderInputParameter "^\s*os" contained
syn match motorfaderOutputParameter "^\s*output" contained
syn match motorfaderInputParameter "^\s*outputoffset" contained
syn match motorfaderInputParameter "^\s*outputscale" contained
syn match motorfaderInputParameter "^\s*pr" contained
syn match motorfaderInputParameter "^\s*preset" contained
syn match motorfaderInputParameter "^\s*s" contained
syn match motorfaderInputParameter "^\s*sa" contained
syn match motorfaderInputParameter "^\s*savepreset" contained
syn match motorfaderInputParameter "^\s*select" contained
syn match motorfaderInputParameter "^\s*selectat" contained
syn match motorfaderInputParameter "^\s*sharewithnext" contained
syn match motorfaderInputParameter "^\s*sp" contained
syn match motorfaderInputParameter "^\s*startvalue" contained
syn match motorfaderInputParameter "^\s*sv" contained
syn match motorfaderInputParameter "^\s*sw" contained
syn match motorfaderHeader /\[motorfader\]/ contained
syn region motorfaderCircuit start=/\[motorfader\]/ end=/\[/me=s-1 transparent contains=motorfaderHeader,motorfaderInputParameter,motorfaderOutputParameter,ioregister,number,cable,quotestring,comment
hi def link motorfaderHeader circuitHeader
hi def link motorfaderInputParameter inputParameter
hi def link motorfaderOutputParameter outputParameter


" multicompare
syn match multicompareInputParameter "^\s*c1" contained
syn match multicompareInputParameter "^\s*c10" contained
syn match multicompareInputParameter "^\s*c11" contained
syn match multicompareInputParameter "^\s*c12" contained
syn match multicompareInputParameter "^\s*c13" contained
syn match multicompareInputParameter "^\s*c14" contained
syn match multicompareInputParameter "^\s*c15" contained
syn match multicompareInputParameter "^\s*c16" contained
syn match multicompareInputParameter "^\s*c2" contained
syn match multicompareInputParameter "^\s*c3" contained
syn match multicompareInputParameter "^\s*c4" contained
syn match multicompareInputParameter "^\s*c5" contained
syn match multicompareInputParameter "^\s*c6" contained
syn match multicompareInputParameter "^\s*c7" contained
syn match multicompareInputParameter "^\s*c8" contained
syn match multicompareInputParameter "^\s*c9" contained
syn match multicompareInputParameter "^\s*compare" contained
syn match multicompareInputParameter "^\s*compare1" contained
syn match multicompareInputParameter "^\s*compare10" contained
syn match multicompareInputParameter "^\s*compare11" contained
syn match multicompareInputParameter "^\s*compare12" contained
syn match multicompareInputParameter "^\s*compare13" contained
syn match multicompareInputParameter "^\s*compare14" contained
syn match multicompareInputParameter "^\s*compare15" contained
syn match multicompareInputParameter "^\s*compare16" contained
syn match multicompareInputParameter "^\s*compare2" contained
syn match multicompareInputParameter "^\s*compare3" contained
syn match multicompareInputParameter "^\s*compare4" contained
syn match multicompareInputParameter "^\s*compare5" contained
syn match multicompareInputParameter "^\s*compare6" contained
syn match multicompareInputParameter "^\s*compare7" contained
syn match multicompareInputParameter "^\s*compare8" contained
syn match multicompareInputParameter "^\s*compare9" contained
syn match multicompareInputParameter "^\s*e" contained
syn match multicompareInputParameter "^\s*else" contained
syn match multicompareInputParameter "^\s*i" contained
syn match multicompareInputParameter "^\s*if1" contained
syn match multicompareInputParameter "^\s*if10" contained
syn match multicompareInputParameter "^\s*if11" contained
syn match multicompareInputParameter "^\s*if12" contained
syn match multicompareInputParameter "^\s*if13" contained
syn match multicompareInputParameter "^\s*if14" contained
syn match multicompareInputParameter "^\s*if15" contained
syn match multicompareInputParameter "^\s*if16" contained
syn match multicompareInputParameter "^\s*if2" contained
syn match multicompareInputParameter "^\s*if3" contained
syn match multicompareInputParameter "^\s*if4" contained
syn match multicompareInputParameter "^\s*if5" contained
syn match multicompareInputParameter "^\s*if6" contained
syn match multicompareInputParameter "^\s*if7" contained
syn match multicompareInputParameter "^\s*if8" contained
syn match multicompareInputParameter "^\s*if9" contained
syn match multicompareInputParameter "^\s*ifequal" contained
syn match multicompareInputParameter "^\s*ifequal1" contained
syn match multicompareInputParameter "^\s*ifequal10" contained
syn match multicompareInputParameter "^\s*ifequal11" contained
syn match multicompareInputParameter "^\s*ifequal12" contained
syn match multicompareInputParameter "^\s*ifequal13" contained
syn match multicompareInputParameter "^\s*ifequal14" contained
syn match multicompareInputParameter "^\s*ifequal15" contained
syn match multicompareInputParameter "^\s*ifequal16" contained
syn match multicompareInputParameter "^\s*ifequal2" contained
syn match multicompareInputParameter "^\s*ifequal3" contained
syn match multicompareInputParameter "^\s*ifequal4" contained
syn match multicompareInputParameter "^\s*ifequal5" contained
syn match multicompareInputParameter "^\s*ifequal6" contained
syn match multicompareInputParameter "^\s*ifequal7" contained
syn match multicompareInputParameter "^\s*ifequal8" contained
syn match multicompareInputParameter "^\s*ifequal9" contained
syn match multicompareInputParameter "^\s*input" contained
syn match multicompareOutputParameter "^\s*o" contained
syn match multicompareOutputParameter "^\s*output" contained
syn match multicompareHeader /\[multicompare\]/ contained
syn region multicompareCircuit start=/\[multicompare\]/ end=/\[/me=s-1 transparent contains=multicompareHeader,multicompareInputParameter,multicompareOutputParameter,ioregister,number,cable,quotestring,comment
hi def link multicompareHeader circuitHeader
hi def link multicompareInputParameter inputParameter
hi def link multicompareOutputParameter outputParameter


" notchedpot
syn match notchedpotOutputParameter "^\s*ab" contained
syn match notchedpotOutputParameter "^\s*absbipolar" contained
syn match notchedpotOutputParameter "^\s*b" contained
syn match notchedpotOutputParameter "^\s*bipolar" contained
syn match notchedpotOutputParameter "^\s*l" contained
syn match notchedpotOutputParameter "^\s*lefthalf" contained
syn match notchedpotOutputParameter "^\s*lefthalfinv" contained
syn match notchedpotOutputParameter "^\s*li" contained
syn match notchedpotInputParameter "^\s*no" contained
syn match notchedpotInputParameter "^\s*notch" contained
syn match notchedpotOutputParameter "^\s*o" contained
syn match notchedpotOutputParameter "^\s*output" contained
syn match notchedpotInputParameter "^\s*p" contained
syn match notchedpotInputParameter "^\s*pot" contained
syn match notchedpotOutputParameter "^\s*r" contained
syn match notchedpotOutputParameter "^\s*ri" contained
syn match notchedpotOutputParameter "^\s*righthalf" contained
syn match notchedpotOutputParameter "^\s*righthalfinv" contained
syn match notchedpotHeader /\[notchedpot\]/ contained
syn region notchedpotCircuit start=/\[notchedpot\]/ end=/\[/me=s-1 transparent contains=notchedpotHeader,notchedpotInputParameter,notchedpotOutputParameter,ioregister,number,cable,quotestring,comment
hi def link notchedpotHeader circuitHeader
hi def link notchedpotInputParameter inputParameter
hi def link notchedpotOutputParameter outputParameter


" notebuttons
syn match notebuttonsInputParameter "^\s*b1" contained
syn match notebuttonsInputParameter "^\s*b10" contained
syn match notebuttonsInputParameter "^\s*b11" contained
syn match notebuttonsInputParameter "^\s*b12" contained
syn match notebuttonsInputParameter "^\s*b2" contained
syn match notebuttonsInputParameter "^\s*b3" contained
syn match notebuttonsInputParameter "^\s*b4" contained
syn match notebuttonsInputParameter "^\s*b5" contained
syn match notebuttonsInputParameter "^\s*b6" contained
syn match notebuttonsInputParameter "^\s*b7" contained
syn match notebuttonsInputParameter "^\s*b8" contained
syn match notebuttonsInputParameter "^\s*b9" contained
syn match notebuttonsInputParameter "^\s*button" contained
syn match notebuttonsInputParameter "^\s*button1" contained
syn match notebuttonsInputParameter "^\s*button10" contained
syn match notebuttonsInputParameter "^\s*button11" contained
syn match notebuttonsInputParameter "^\s*button12" contained
syn match notebuttonsInputParameter "^\s*button2" contained
syn match notebuttonsInputParameter "^\s*button3" contained
syn match notebuttonsInputParameter "^\s*button4" contained
syn match notebuttonsInputParameter "^\s*button5" contained
syn match notebuttonsInputParameter "^\s*button6" contained
syn match notebuttonsInputParameter "^\s*button7" contained
syn match notebuttonsInputParameter "^\s*button8" contained
syn match notebuttonsInputParameter "^\s*button9" contained
syn match notebuttonsInputParameter "^\s*c" contained
syn match notebuttonsInputParameter "^\s*ca" contained
syn match notebuttonsInputParameter "^\s*cl" contained
syn match notebuttonsInputParameter "^\s*clear" contained
syn match notebuttonsInputParameter "^\s*clearall" contained
syn match notebuttonsInputParameter "^\s*clock" contained
syn match notebuttonsInputParameter "^\s*display" contained
syn match notebuttonsInputParameter "^\s*dontsave" contained
syn match notebuttonsInputParameter "^\s*dos" contained
syn match notebuttonsInputParameter "^\s*dy" contained
syn match notebuttonsOutputParameter "^\s*g" contained
syn match notebuttonsOutputParameter "^\s*gate" contained
syn match notebuttonsInputParameter "^\s*header" contained
syn match notebuttonsInputParameter "^\s*hr" contained
syn match notebuttonsOutputParameter "^\s*l1" contained
syn match notebuttonsOutputParameter "^\s*l10" contained
syn match notebuttonsOutputParameter "^\s*l11" contained
syn match notebuttonsOutputParameter "^\s*l12" contained
syn match notebuttonsOutputParameter "^\s*l2" contained
syn match notebuttonsOutputParameter "^\s*l3" contained
syn match notebuttonsOutputParameter "^\s*l4" contained
syn match notebuttonsOutputParameter "^\s*l5" contained
syn match notebuttonsOutputParameter "^\s*l6" contained
syn match notebuttonsOutputParameter "^\s*l7" contained
syn match notebuttonsOutputParameter "^\s*l8" contained
syn match notebuttonsOutputParameter "^\s*l9" contained
syn match notebuttonsOutputParameter "^\s*led" contained
syn match notebuttonsOutputParameter "^\s*led1" contained
syn match notebuttonsOutputParameter "^\s*led10" contained
syn match notebuttonsOutputParameter "^\s*led11" contained
syn match notebuttonsOutputParameter "^\s*led12" contained
syn match notebuttonsOutputParameter "^\s*led2" contained
syn match notebuttonsOutputParameter "^\s*led3" contained
syn match notebuttonsOutputParameter "^\s*led4" contained
syn match notebuttonsOutputParameter "^\s*led5" contained
syn match notebuttonsOutputParameter "^\s*led6" contained
syn match notebuttonsOutputParameter "^\s*led7" contained
syn match notebuttonsOutputParameter "^\s*led8" contained
syn match notebuttonsOutputParameter "^\s*led9" contained
syn match notebuttonsInputParameter "^\s*loadpreset" contained
syn match notebuttonsInputParameter "^\s*lp" contained
syn match notebuttonsOutputParameter "^\s*o" contained
syn match notebuttonsOutputParameter "^\s*output" contained
syn match notebuttonsInputParameter "^\s*pr" contained
syn match notebuttonsInputParameter "^\s*preset" contained
syn match notebuttonsInputParameter "^\s*s" contained
syn match notebuttonsInputParameter "^\s*sa" contained
syn match notebuttonsInputParameter "^\s*savepreset" contained
syn match notebuttonsInputParameter "^\s*select" contained
syn match notebuttonsInputParameter "^\s*selectat" contained
syn match notebuttonsOutputParameter "^\s*semitone" contained
syn match notebuttonsInputParameter "^\s*sn" contained
syn match notebuttonsInputParameter "^\s*sp" contained
syn match notebuttonsOutputParameter "^\s*st" contained
syn match notebuttonsInputParameter "^\s*startnote" contained
syn match notebuttonsHeader /\[notebuttons\]/ contained
syn region notebuttonsCircuit start=/\[notebuttons\]/ end=/\[/me=s-1 transparent contains=notebuttonsHeader,notebuttonsInputParameter,notebuttonsOutputParameter,ioregister,number,cable,quotestring,comment
hi def link notebuttonsHeader circuitHeader
hi def link notebuttonsInputParameter inputParameter
hi def link notebuttonsOutputParameter outputParameter


" nudge
syn match nudgeInputParameter "^\s*am" contained
syn match nudgeInputParameter "^\s*amount" contained
syn match nudgeInputParameter "^\s*buttondown" contained
syn match nudgeInputParameter "^\s*buttonup" contained
syn match nudgeOutputParameter "^\s*c" contained
syn match nudgeInputParameter "^\s*ca" contained
syn match nudgeOutputParameter "^\s*changed" contained
syn match nudgeInputParameter "^\s*cl" contained
syn match nudgeInputParameter "^\s*clear" contained
syn match nudgeInputParameter "^\s*clearall" contained
syn match nudgeInputParameter "^\s*d" contained
syn match nudgeInputParameter "^\s*display" contained
syn match nudgeInputParameter "^\s*dontsave" contained
syn match nudgeInputParameter "^\s*dos" contained
syn match nudgeInputParameter "^\s*dy" contained
syn match nudgeInputParameter "^\s*header" contained
syn match nudgeInputParameter "^\s*hr" contained
syn match nudgeOutputParameter "^\s*ld" contained
syn match nudgeOutputParameter "^\s*leddown" contained
syn match nudgeOutputParameter "^\s*ledup" contained
syn match nudgeInputParameter "^\s*loadpreset" contained
syn match nudgeInputParameter "^\s*lp" contained
syn match nudgeOutputParameter "^\s*lu" contained
syn match nudgeInputParameter "^\s*m" contained
syn match nudgeInputParameter "^\s*maximum" contained
syn match nudgeInputParameter "^\s*minimum" contained
syn match nudgeOutputParameter "^\s*o" contained
syn match nudgeInputParameter "^\s*of" contained
syn match nudgeInputParameter "^\s*offset" contained
syn match nudgeOutputParameter "^\s*output" contained
syn match nudgeInputParameter "^\s*pr" contained
syn match nudgeInputParameter "^\s*preset" contained
syn match nudgeInputParameter "^\s*s" contained
syn match nudgeInputParameter "^\s*sa" contained
syn match nudgeInputParameter "^\s*savepreset" contained
syn match nudgeInputParameter "^\s*select" contained
syn match nudgeInputParameter "^\s*selectat" contained
syn match nudgeInputParameter "^\s*sp" contained
syn match nudgeInputParameter "^\s*startvalue" contained
syn match nudgeInputParameter "^\s*sv" contained
syn match nudgeInputParameter "^\s*u" contained
syn match nudgeInputParameter "^\s*w" contained
syn match nudgeInputParameter "^\s*wrap" contained
syn match nudgeInputParameter "^\s*x" contained
syn match nudgeHeader /\[nudge\]/ contained
syn region nudgeCircuit start=/\[nudge\]/ end=/\[/me=s-1 transparent contains=nudgeHeader,nudgeInputParameter,nudgeOutputParameter,ioregister,number,cable,quotestring,comment
hi def link nudgeHeader circuitHeader
hi def link nudgeInputParameter inputParameter
hi def link nudgeOutputParameter outputParameter


" octave
syn match octaveInputParameter "^\s*d" contained
syn match octaveInputParameter "^\s*detune" contained
syn match octaveInputParameter "^\s*f" contained
syn match octaveInputParameter "^\s*fifths" contained
syn match octaveInputParameter "^\s*i" contained
syn match octaveInputParameter "^\s*input" contained
syn match octaveOutputParameter "^\s*o1" contained
syn match octaveOutputParameter "^\s*o2" contained
syn match octaveOutputParameter "^\s*o3" contained
syn match octaveOutputParameter "^\s*output" contained
syn match octaveOutputParameter "^\s*output1" contained
syn match octaveOutputParameter "^\s*output2" contained
syn match octaveOutputParameter "^\s*output3" contained
syn match octaveInputParameter "^\s*s" contained
syn match octaveInputParameter "^\s*spread" contained
syn match octaveHeader /\[octave\]/ contained
syn region octaveCircuit start=/\[octave\]/ end=/\[/me=s-1 transparent contains=octaveHeader,octaveInputParameter,octaveOutputParameter,ioregister,number,cable,quotestring,comment
hi def link octaveHeader circuitHeader
hi def link octaveInputParameter inputParameter
hi def link octaveOutputParameter outputParameter


" once
syn match onceInputParameter "^\s*c" contained
syn match onceInputParameter "^\s*delay" contained
syn match onceInputParameter "^\s*dl" contained
syn match onceInputParameter "^\s*onlycoldstart" contained
syn match onceOutputParameter "^\s*t" contained
syn match onceOutputParameter "^\s*trigger" contained
syn match onceHeader /\[once\]/ contained
syn region onceCircuit start=/\[once\]/ end=/\[/me=s-1 transparent contains=onceHeader,onceInputParameter,onceOutputParameter,ioregister,number,cable,quotestring,comment
hi def link onceHeader circuitHeader
hi def link onceInputParameter inputParameter
hi def link onceOutputParameter outputParameter


" outputcalibrator
syn match outputcalibratorInputParameter "^\s*c" contained
syn match outputcalibratorOutputParameter "^\s*calibration" contained
syn match outputcalibratorInputParameter "^\s*cancel" contained
syn match outputcalibratorOutputParameter "^\s*cl" contained
syn match outputcalibratorOutputParameter "^\s*d" contained
syn match outputcalibratorOutputParameter "^\s*dirty" contained
syn match outputcalibratorInputParameter "^\s*display" contained
syn match outputcalibratorInputParameter "^\s*dy" contained
syn match outputcalibratorInputParameter "^\s*header" contained
syn match outputcalibratorInputParameter "^\s*hr" contained
syn match outputcalibratorInputParameter "^\s*ld" contained
syn match outputcalibratorInputParameter "^\s*loaddefaults" contained
syn match outputcalibratorInputParameter "^\s*nd" contained
syn match outputcalibratorInputParameter "^\s*nu" contained
syn match outputcalibratorInputParameter "^\s*nudgedown" contained
syn match outputcalibratorInputParameter "^\s*nudgeup" contained
syn match outputcalibratorInputParameter "^\s*o" contained
syn match outputcalibratorInputParameter "^\s*output" contained
syn match outputcalibratorInputParameter "^\s*r" contained
syn match outputcalibratorInputParameter "^\s*referencepoint" contained
syn match outputcalibratorInputParameter "^\s*save" contained
syn match outputcalibratorInputParameter "^\s*sv" contained
syn match outputcalibratorOutputParameter "^\s*u" contained
syn match outputcalibratorOutputParameter "^\s*uncalibrated" contained
syn match outputcalibratorHeader /\[outputcalibrator\]/ contained
syn region outputcalibratorCircuit start=/\[outputcalibrator\]/ end=/\[/me=s-1 transparent contains=outputcalibratorHeader,outputcalibratorInputParameter,outputcalibratorOutputParameter,ioregister,number,cable,quotestring,comment
hi def link outputcalibratorHeader circuitHeader
hi def link outputcalibratorInputParameter inputParameter
hi def link outputcalibratorOutputParameter outputParameter


" polytool
syn match polytoolInputParameter "^\s*gateinput" contained
syn match polytoolInputParameter "^\s*gateinput1" contained
syn match polytoolInputParameter "^\s*gateinput10" contained
syn match polytoolInputParameter "^\s*gateinput11" contained
syn match polytoolInputParameter "^\s*gateinput12" contained
syn match polytoolInputParameter "^\s*gateinput13" contained
syn match polytoolInputParameter "^\s*gateinput14" contained
syn match polytoolInputParameter "^\s*gateinput15" contained
syn match polytoolInputParameter "^\s*gateinput16" contained
syn match polytoolInputParameter "^\s*gateinput2" contained
syn match polytoolInputParameter "^\s*gateinput3" contained
syn match polytoolInputParameter "^\s*gateinput4" contained
syn match polytoolInputParameter "^\s*gateinput5" contained
syn match polytoolInputParameter "^\s*gateinput6" contained
syn match polytoolInputParameter "^\s*gateinput7" contained
syn match polytoolInputParameter "^\s*gateinput8" contained
syn match polytoolInputParameter "^\s*gateinput9" contained
syn match polytoolOutputParameter "^\s*gateoutput" contained
syn match polytoolOutputParameter "^\s*gateoutput1" contained
syn match polytoolOutputParameter "^\s*gateoutput10" contained
syn match polytoolOutputParameter "^\s*gateoutput11" contained
syn match polytoolOutputParameter "^\s*gateoutput12" contained
syn match polytoolOutputParameter "^\s*gateoutput13" contained
syn match polytoolOutputParameter "^\s*gateoutput14" contained
syn match polytoolOutputParameter "^\s*gateoutput15" contained
syn match polytoolOutputParameter "^\s*gateoutput16" contained
syn match polytoolOutputParameter "^\s*gateoutput2" contained
syn match polytoolOutputParameter "^\s*gateoutput3" contained
syn match polytoolOutputParameter "^\s*gateoutput4" contained
syn match polytoolOutputParameter "^\s*gateoutput5" contained
syn match polytoolOutputParameter "^\s*gateoutput6" contained
syn match polytoolOutputParameter "^\s*gateoutput7" contained
syn match polytoolOutputParameter "^\s*gateoutput8" contained
syn match polytoolOutputParameter "^\s*gateoutput9" contained
syn match polytoolInputParameter "^\s*gi1" contained
syn match polytoolInputParameter "^\s*gi10" contained
syn match polytoolInputParameter "^\s*gi11" contained
syn match polytoolInputParameter "^\s*gi12" contained
syn match polytoolInputParameter "^\s*gi13" contained
syn match polytoolInputParameter "^\s*gi14" contained
syn match polytoolInputParameter "^\s*gi15" contained
syn match polytoolInputParameter "^\s*gi16" contained
syn match polytoolInputParameter "^\s*gi2" contained
syn match polytoolInputParameter "^\s*gi3" contained
syn match polytoolInputParameter "^\s*gi4" contained
syn match polytoolInputParameter "^\s*gi5" contained
syn match polytoolInputParameter "^\s*gi6" contained
syn match polytoolInputParameter "^\s*gi7" contained
syn match polytoolInputParameter "^\s*gi8" contained
syn match polytoolInputParameter "^\s*gi9" contained
syn match polytoolOutputParameter "^\s*go1" contained
syn match polytoolOutputParameter "^\s*go10" contained
syn match polytoolOutputParameter "^\s*go11" contained
syn match polytoolOutputParameter "^\s*go12" contained
syn match polytoolOutputParameter "^\s*go13" contained
syn match polytoolOutputParameter "^\s*go14" contained
syn match polytoolOutputParameter "^\s*go15" contained
syn match polytoolOutputParameter "^\s*go16" contained
syn match polytoolOutputParameter "^\s*go2" contained
syn match polytoolOutputParameter "^\s*go3" contained
syn match polytoolOutputParameter "^\s*go4" contained
syn match polytoolOutputParameter "^\s*go5" contained
syn match polytoolOutputParameter "^\s*go6" contained
syn match polytoolOutputParameter "^\s*go7" contained
syn match polytoolOutputParameter "^\s*go8" contained
syn match polytoolOutputParameter "^\s*go9" contained
syn match polytoolInputParameter "^\s*pi1" contained
syn match polytoolInputParameter "^\s*pi10" contained
syn match polytoolInputParameter "^\s*pi11" contained
syn match polytoolInputParameter "^\s*pi12" contained
syn match polytoolInputParameter "^\s*pi13" contained
syn match polytoolInputParameter "^\s*pi14" contained
syn match polytoolInputParameter "^\s*pi15" contained
syn match polytoolInputParameter "^\s*pi16" contained
syn match polytoolInputParameter "^\s*pi2" contained
syn match polytoolInputParameter "^\s*pi3" contained
syn match polytoolInputParameter "^\s*pi4" contained
syn match polytoolInputParameter "^\s*pi5" contained
syn match polytoolInputParameter "^\s*pi6" contained
syn match polytoolInputParameter "^\s*pi7" contained
syn match polytoolInputParameter "^\s*pi8" contained
syn match polytoolInputParameter "^\s*pi9" contained
syn match polytoolInputParameter "^\s*pitchinput" contained
syn match polytoolInputParameter "^\s*pitchinput1" contained
syn match polytoolInputParameter "^\s*pitchinput10" contained
syn match polytoolInputParameter "^\s*pitchinput11" contained
syn match polytoolInputParameter "^\s*pitchinput12" contained
syn match polytoolInputParameter "^\s*pitchinput13" contained
syn match polytoolInputParameter "^\s*pitchinput14" contained
syn match polytoolInputParameter "^\s*pitchinput15" contained
syn match polytoolInputParameter "^\s*pitchinput16" contained
syn match polytoolInputParameter "^\s*pitchinput2" contained
syn match polytoolInputParameter "^\s*pitchinput3" contained
syn match polytoolInputParameter "^\s*pitchinput4" contained
syn match polytoolInputParameter "^\s*pitchinput5" contained
syn match polytoolInputParameter "^\s*pitchinput6" contained
syn match polytoolInputParameter "^\s*pitchinput7" contained
syn match polytoolInputParameter "^\s*pitchinput8" contained
syn match polytoolInputParameter "^\s*pitchinput9" contained
syn match polytoolOutputParameter "^\s*pitchoutput" contained
syn match polytoolOutputParameter "^\s*pitchoutput1" contained
syn match polytoolOutputParameter "^\s*pitchoutput10" contained
syn match polytoolOutputParameter "^\s*pitchoutput11" contained
syn match polytoolOutputParameter "^\s*pitchoutput12" contained
syn match polytoolOutputParameter "^\s*pitchoutput13" contained
syn match polytoolOutputParameter "^\s*pitchoutput14" contained
syn match polytoolOutputParameter "^\s*pitchoutput15" contained
syn match polytoolOutputParameter "^\s*pitchoutput16" contained
syn match polytoolOutputParameter "^\s*pitchoutput2" contained
syn match polytoolOutputParameter "^\s*pitchoutput3" contained
syn match polytoolOutputParameter "^\s*pitchoutput4" contained
syn match polytoolOutputParameter "^\s*pitchoutput5" contained
syn match polytoolOutputParameter "^\s*pitchoutput6" contained
syn match polytoolOutputParameter "^\s*pitchoutput7" contained
syn match polytoolOutputParameter "^\s*pitchoutput8" contained
syn match polytoolOutputParameter "^\s*pitchoutput9" contained
syn match polytoolOutputParameter "^\s*po1" contained
syn match polytoolOutputParameter "^\s*po10" contained
syn match polytoolOutputParameter "^\s*po11" contained
syn match polytoolOutputParameter "^\s*po12" contained
syn match polytoolOutputParameter "^\s*po13" contained
syn match polytoolOutputParameter "^\s*po14" contained
syn match polytoolOutputParameter "^\s*po15" contained
syn match polytoolOutputParameter "^\s*po16" contained
syn match polytoolOutputParameter "^\s*po2" contained
syn match polytoolOutputParameter "^\s*po3" contained
syn match polytoolOutputParameter "^\s*po4" contained
syn match polytoolOutputParameter "^\s*po5" contained
syn match polytoolOutputParameter "^\s*po6" contained
syn match polytoolOutputParameter "^\s*po7" contained
syn match polytoolOutputParameter "^\s*po8" contained
syn match polytoolOutputParameter "^\s*po9" contained
syn match polytoolInputParameter "^\s*roundrobin" contained
syn match polytoolInputParameter "^\s*rr" contained
syn match polytoolInputParameter "^\s*va" contained
syn match polytoolInputParameter "^\s*voiceallocation" contained
syn match polytoolHeader /\[polytool\]/ contained
syn region polytoolCircuit start=/\[polytool\]/ end=/\[/me=s-1 transparent contains=polytoolHeader,polytoolInputParameter,polytoolOutputParameter,ioregister,number,cable,quotestring,comment
hi def link polytoolHeader circuitHeader
hi def link polytoolInputParameter inputParameter
hi def link polytoolOutputParameter outputParameter


" pot
syn match potOutputParameter "^\s*ab" contained
syn match potOutputParameter "^\s*absbipolar" contained
syn match potOutputParameter "^\s*b" contained
syn match potOutputParameter "^\s*bipolar" contained
syn match potOutputParameter "^\s*c" contained
syn match potInputParameter "^\s*ca" contained
syn match potInputParameter "^\s*cl" contained
syn match potInputParameter "^\s*clear" contained
syn match potInputParameter "^\s*clearall" contained
syn match potInputParameter "^\s*d" contained
syn match potInputParameter "^\s*discrete" contained
syn match potInputParameter "^\s*display" contained
syn match potInputParameter "^\s*dontsave" contained
syn match potInputParameter "^\s*dos" contained
syn match potInputParameter "^\s*dy" contained
syn match potInputParameter "^\s*g" contained
syn match potInputParameter "^\s*header" contained
syn match potInputParameter "^\s*hr" contained
syn match potOutputParameter "^\s*l" contained
syn match potInputParameter "^\s*ledgauge" contained
syn match potOutputParameter "^\s*lefthalf" contained
syn match potOutputParameter "^\s*lefthalfinv" contained
syn match potOutputParameter "^\s*li" contained
syn match potInputParameter "^\s*loadpreset" contained
syn match potInputParameter "^\s*lp" contained
syn match potInputParameter "^\s*no" contained
syn match potInputParameter "^\s*notch" contained
syn match potOutputParameter "^\s*o" contained
syn match potOutputParameter "^\s*onchange" contained
syn match potInputParameter "^\s*oo" contained
syn match potInputParameter "^\s*os" contained
syn match potOutputParameter "^\s*output" contained
syn match potInputParameter "^\s*outputoffset" contained
syn match potInputParameter "^\s*outputscale" contained
syn match potInputParameter "^\s*p" contained
syn match potInputParameter "^\s*pot" contained
syn match potInputParameter "^\s*pr" contained
syn match potInputParameter "^\s*preset" contained
syn match potOutputParameter "^\s*r" contained
syn match potOutputParameter "^\s*ri" contained
syn match potOutputParameter "^\s*righthalf" contained
syn match potOutputParameter "^\s*righthalfinv" contained
syn match potInputParameter "^\s*s" contained
syn match potInputParameter "^\s*sa" contained
syn match potInputParameter "^\s*savepreset" contained
syn match potInputParameter "^\s*select" contained
syn match potInputParameter "^\s*selectat" contained
syn match potInputParameter "^\s*sl" contained
syn match potInputParameter "^\s*slope" contained
syn match potInputParameter "^\s*sp" contained
syn match potInputParameter "^\s*startvalue" contained
syn match potInputParameter "^\s*sv" contained
syn match potHeader /\[pot\]/ contained
syn region potCircuit start=/\[pot\]/ end=/\[/me=s-1 transparent contains=potHeader,potInputParameter,potOutputParameter,ioregister,number,cable,quotestring,comment
hi def link potHeader circuitHeader
hi def link potInputParameter inputParameter
hi def link potOutputParameter outputParameter


" quantizer
syn match quantizerInputParameter "^\s*b" contained
syn match quantizerInputParameter "^\s*bypass" contained
syn match quantizerOutputParameter "^\s*c" contained
syn match quantizerOutputParameter "^\s*changed" contained
syn match quantizerInputParameter "^\s*d" contained
syn match quantizerInputParameter "^\s*direction" contained
syn match quantizerInputParameter "^\s*h" contained
syn match quantizerInputParameter "^\s*histeresis" contained
syn match quantizerInputParameter "^\s*i" contained
syn match quantizerInputParameter "^\s*input" contained
syn match quantizerOutputParameter "^\s*o" contained
syn match quantizerOutputParameter "^\s*output" contained
syn match quantizerInputParameter "^\s*s" contained
syn match quantizerInputParameter "^\s*steps" contained
syn match quantizerInputParameter "^\s*t" contained
syn match quantizerInputParameter "^\s*trigger" contained
syn match quantizerHeader /\[quantizer\]/ contained
syn region quantizerCircuit start=/\[quantizer\]/ end=/\[/me=s-1 transparent contains=quantizerHeader,quantizerInputParameter,quantizerOutputParameter,ioregister,number,cable,quotestring,comment
hi def link quantizerHeader circuitHeader
hi def link quantizerInputParameter inputParameter
hi def link quantizerOutputParameter outputParameter


" queue
syn match queueInputParameter "^\s*c" contained
syn match queueInputParameter "^\s*clock" contained
syn match queueInputParameter "^\s*i" contained
syn match queueInputParameter "^\s*input" contained
syn match queueOutputParameter "^\s*o1" contained
syn match queueOutputParameter "^\s*o2" contained
syn match queueOutputParameter "^\s*o3" contained
syn match queueOutputParameter "^\s*o4" contained
syn match queueOutputParameter "^\s*o5" contained
syn match queueOutputParameter "^\s*o6" contained
syn match queueOutputParameter "^\s*o7" contained
syn match queueOutputParameter "^\s*o8" contained
syn match queueInputParameter "^\s*op1" contained
syn match queueInputParameter "^\s*op2" contained
syn match queueInputParameter "^\s*op3" contained
syn match queueInputParameter "^\s*op4" contained
syn match queueInputParameter "^\s*op5" contained
syn match queueInputParameter "^\s*op6" contained
syn match queueInputParameter "^\s*op7" contained
syn match queueInputParameter "^\s*op8" contained
syn match queueOutputParameter "^\s*output" contained
syn match queueOutputParameter "^\s*output1" contained
syn match queueOutputParameter "^\s*output2" contained
syn match queueOutputParameter "^\s*output3" contained
syn match queueOutputParameter "^\s*output4" contained
syn match queueOutputParameter "^\s*output5" contained
syn match queueOutputParameter "^\s*output6" contained
syn match queueOutputParameter "^\s*output7" contained
syn match queueOutputParameter "^\s*output8" contained
syn match queueInputParameter "^\s*outputpos" contained
syn match queueInputParameter "^\s*outputpos1" contained
syn match queueInputParameter "^\s*outputpos2" contained
syn match queueInputParameter "^\s*outputpos3" contained
syn match queueInputParameter "^\s*outputpos4" contained
syn match queueInputParameter "^\s*outputpos5" contained
syn match queueInputParameter "^\s*outputpos6" contained
syn match queueInputParameter "^\s*outputpos7" contained
syn match queueInputParameter "^\s*outputpos8" contained
syn match queueHeader /\[queue\]/ contained
syn region queueCircuit start=/\[queue\]/ end=/\[/me=s-1 transparent contains=queueHeader,queueInputParameter,queueOutputParameter,ioregister,number,cable,quotestring,comment
hi def link queueHeader circuitHeader
hi def link queueInputParameter inputParameter
hi def link queueOutputParameter outputParameter


" random
syn match randomInputParameter "^\s*c" contained
syn match randomInputParameter "^\s*clock" contained
syn match randomInputParameter "^\s*m" contained
syn match randomInputParameter "^\s*maximum" contained
syn match randomInputParameter "^\s*minimum" contained
syn match randomOutputParameter "^\s*o" contained
syn match randomOutputParameter "^\s*output" contained
syn match randomInputParameter "^\s*s" contained
syn match randomInputParameter "^\s*steps" contained
syn match randomInputParameter "^\s*x" contained
syn match randomHeader /\[random\]/ contained
syn region randomCircuit start=/\[random\]/ end=/\[/me=s-1 transparent contains=randomHeader,randomInputParameter,randomOutputParameter,ioregister,number,cable,quotestring,comment
hi def link randomHeader circuitHeader
hi def link randomInputParameter inputParameter
hi def link randomOutputParameter outputParameter


" recorder
syn match recorderInputParameter "^\s*b" contained
syn match recorderInputParameter "^\s*bypass" contained
syn match recorderInputParameter "^\s*c" contained
syn match recorderInputParameter "^\s*ci" contained
syn match recorderInputParameter "^\s*clock" contained
syn match recorderOutputParameter "^\s*co" contained
syn match recorderInputParameter "^\s*cvin" contained
syn match recorderOutputParameter "^\s*cvout" contained
syn match recorderInputParameter "^\s*display" contained
syn match recorderInputParameter "^\s*dy" contained
syn match recorderInputParameter "^\s*f" contained
syn match recorderInputParameter "^\s*filenumber" contained
syn match recorderInputParameter "^\s*gatein" contained
syn match recorderInputParameter "^\s*gatein1" contained
syn match recorderInputParameter "^\s*gatein2" contained
syn match recorderInputParameter "^\s*gatein3" contained
syn match recorderInputParameter "^\s*gatein4" contained
syn match recorderInputParameter "^\s*gatein5" contained
syn match recorderInputParameter "^\s*gatein6" contained
syn match recorderInputParameter "^\s*gatein7" contained
syn match recorderInputParameter "^\s*gatein8" contained
syn match recorderOutputParameter "^\s*gateout" contained
syn match recorderOutputParameter "^\s*gateout1" contained
syn match recorderOutputParameter "^\s*gateout2" contained
syn match recorderOutputParameter "^\s*gateout3" contained
syn match recorderOutputParameter "^\s*gateout4" contained
syn match recorderOutputParameter "^\s*gateout5" contained
syn match recorderOutputParameter "^\s*gateout6" contained
syn match recorderOutputParameter "^\s*gateout7" contained
syn match recorderOutputParameter "^\s*gateout8" contained
syn match recorderInputParameter "^\s*gi1" contained
syn match recorderInputParameter "^\s*gi2" contained
syn match recorderInputParameter "^\s*gi3" contained
syn match recorderInputParameter "^\s*gi4" contained
syn match recorderInputParameter "^\s*gi5" contained
syn match recorderInputParameter "^\s*gi6" contained
syn match recorderInputParameter "^\s*gi7" contained
syn match recorderInputParameter "^\s*gi8" contained
syn match recorderOutputParameter "^\s*go1" contained
syn match recorderOutputParameter "^\s*go2" contained
syn match recorderOutputParameter "^\s*go3" contained
syn match recorderOutputParameter "^\s*go4" contained
syn match recorderOutputParameter "^\s*go5" contained
syn match recorderOutputParameter "^\s*go6" contained
syn match recorderOutputParameter "^\s*go7" contained
syn match recorderOutputParameter "^\s*go8" contained
syn match recorderInputParameter "^\s*header" contained
syn match recorderInputParameter "^\s*hr" contained
syn match recorderInputParameter "^\s*ld" contained
syn match recorderInputParameter "^\s*lo" contained
syn match recorderInputParameter "^\s*load" contained
syn match recorderInputParameter "^\s*loop" contained
syn match recorderInputParameter "^\s*m" contained
syn match recorderInputParameter "^\s*mode" contained
syn match recorderInputParameter "^\s*ni" contained
syn match recorderOutputParameter "^\s*no" contained
syn match recorderInputParameter "^\s*numberin" contained
syn match recorderOutputParameter "^\s*numberout" contained
syn match recorderOutputParameter "^\s*ov" contained
syn match recorderOutputParameter "^\s*overflow" contained
syn match recorderInputParameter "^\s*p" contained
syn match recorderInputParameter "^\s*pause" contained
syn match recorderInputParameter "^\s*pb" contained
syn match recorderOutputParameter "^\s*pl" contained
syn match recorderInputParameter "^\s*playbackspeed" contained
syn match recorderInputParameter "^\s*playbutton" contained
syn match recorderOutputParameter "^\s*playled" contained
syn match recorderInputParameter "^\s*ps" contained
syn match recorderInputParameter "^\s*rb" contained
syn match recorderInputParameter "^\s*recordbutton" contained
syn match recorderOutputParameter "^\s*recordled" contained
syn match recorderOutputParameter "^\s*rl" contained
syn match recorderInputParameter "^\s*s" contained
syn match recorderInputParameter "^\s*sa" contained
syn match recorderInputParameter "^\s*sample" contained
syn match recorderInputParameter "^\s*save" contained
syn match recorderInputParameter "^\s*sb" contained
syn match recorderInputParameter "^\s*sc" contained
syn match recorderInputParameter "^\s*scrub" contained
syn match recorderInputParameter "^\s*scrubposition" contained
syn match recorderInputParameter "^\s*select" contained
syn match recorderInputParameter "^\s*selectat" contained
syn match recorderOutputParameter "^\s*sl" contained
syn match recorderInputParameter "^\s*sm" contained
syn match recorderInputParameter "^\s*sp" contained
syn match recorderInputParameter "^\s*stopbutton" contained
syn match recorderOutputParameter "^\s*stopled" contained
syn match recorderInputParameter "^\s*sv" contained
syn match recorderInputParameter "^\s*te" contained
syn match recorderInputParameter "^\s*timewindow" contained
syn match recorderInputParameter "^\s*trimend" contained
syn match recorderInputParameter "^\s*trimstart" contained
syn match recorderInputParameter "^\s*ts" contained
syn match recorderInputParameter "^\s*tw" contained
syn match recorderHeader /\[recorder\]/ contained
syn region recorderCircuit start=/\[recorder\]/ end=/\[/me=s-1 transparent contains=recorderHeader,recorderInputParameter,recorderOutputParameter,ioregister,number,cable,quotestring,comment
hi def link recorderHeader circuitHeader
hi def link recorderInputParameter inputParameter
hi def link recorderOutputParameter outputParameter


" sample
syn match sampleInputParameter "^\s*b" contained
syn match sampleInputParameter "^\s*bypass" contained
syn match sampleInputParameter "^\s*g" contained
syn match sampleInputParameter "^\s*gate" contained
syn match sampleInputParameter "^\s*i" contained
syn match sampleInputParameter "^\s*input" contained
syn match sampleOutputParameter "^\s*o" contained
syn match sampleOutputParameter "^\s*output" contained
syn match sampleInputParameter "^\s*sample" contained
syn match sampleInputParameter "^\s*sm" contained
syn match sampleInputParameter "^\s*timewindow" contained
syn match sampleInputParameter "^\s*tw" contained
syn match sampleHeader /\[sample\]/ contained
syn region sampleCircuit start=/\[sample\]/ end=/\[/me=s-1 transparent contains=sampleHeader,sampleInputParameter,sampleOutputParameter,ioregister,number,cable,quotestring,comment
hi def link sampleHeader circuitHeader
hi def link sampleInputParameter inputParameter
hi def link sampleOutputParameter outputParameter


" select
syn match selectInputParameter "^\s*i" contained
syn match selectInputParameter "^\s*input" contained
syn match selectOutputParameter "^\s*o" contained
syn match selectOutputParameter "^\s*output" contained
syn match selectInputParameter "^\s*s" contained
syn match selectInputParameter "^\s*sa" contained
syn match selectInputParameter "^\s*select" contained
syn match selectInputParameter "^\s*selectat" contained
syn match selectHeader /\[select\]/ contained
syn region selectCircuit start=/\[select\]/ end=/\[/me=s-1 transparent contains=selectHeader,selectInputParameter,selectOutputParameter,ioregister,number,cable,quotestring,comment
hi def link selectHeader circuitHeader
hi def link selectInputParameter inputParameter
hi def link selectOutputParameter outputParameter


" sequencer
syn match sequencerInputParameter "^\s*c" contained
syn match sequencerInputParameter "^\s*chaintonext" contained
syn match sequencerInputParameter "^\s*clock" contained
syn match sequencerInputParameter "^\s*cn" contained
syn match sequencerOutputParameter "^\s*co" contained
syn match sequencerInputParameter "^\s*cv" contained
syn match sequencerInputParameter "^\s*cv1" contained
syn match sequencerInputParameter "^\s*cv2" contained
syn match sequencerInputParameter "^\s*cv3" contained
syn match sequencerInputParameter "^\s*cv4" contained
syn match sequencerInputParameter "^\s*cv5" contained
syn match sequencerInputParameter "^\s*cv6" contained
syn match sequencerInputParameter "^\s*cv7" contained
syn match sequencerInputParameter "^\s*cv8" contained
syn match sequencerOutputParameter "^\s*cvoutput" contained
syn match sequencerInputParameter "^\s*g1" contained
syn match sequencerInputParameter "^\s*g2" contained
syn match sequencerInputParameter "^\s*g3" contained
syn match sequencerInputParameter "^\s*g4" contained
syn match sequencerInputParameter "^\s*g5" contained
syn match sequencerInputParameter "^\s*g6" contained
syn match sequencerInputParameter "^\s*g7" contained
syn match sequencerInputParameter "^\s*g8" contained
syn match sequencerInputParameter "^\s*gate" contained
syn match sequencerInputParameter "^\s*gate1" contained
syn match sequencerInputParameter "^\s*gate2" contained
syn match sequencerInputParameter "^\s*gate3" contained
syn match sequencerInputParameter "^\s*gate4" contained
syn match sequencerInputParameter "^\s*gate5" contained
syn match sequencerInputParameter "^\s*gate6" contained
syn match sequencerInputParameter "^\s*gate7" contained
syn match sequencerInputParameter "^\s*gate8" contained
syn match sequencerInputParameter "^\s*gatelength" contained
syn match sequencerOutputParameter "^\s*gateoutput" contained
syn match sequencerInputParameter "^\s*gl" contained
syn match sequencerOutputParameter "^\s*go" contained
syn match sequencerInputParameter "^\s*os" contained
syn match sequencerInputParameter "^\s*outputscaling" contained
syn match sequencerInputParameter "^\s*p1" contained
syn match sequencerInputParameter "^\s*p2" contained
syn match sequencerInputParameter "^\s*p3" contained
syn match sequencerInputParameter "^\s*p4" contained
syn match sequencerInputParameter "^\s*p5" contained
syn match sequencerInputParameter "^\s*p6" contained
syn match sequencerInputParameter "^\s*p7" contained
syn match sequencerInputParameter "^\s*p8" contained
syn match sequencerInputParameter "^\s*pitch" contained
syn match sequencerInputParameter "^\s*pitch1" contained
syn match sequencerInputParameter "^\s*pitch2" contained
syn match sequencerInputParameter "^\s*pitch3" contained
syn match sequencerInputParameter "^\s*pitch4" contained
syn match sequencerInputParameter "^\s*pitch5" contained
syn match sequencerInputParameter "^\s*pitch6" contained
syn match sequencerInputParameter "^\s*pitch7" contained
syn match sequencerInputParameter "^\s*pitch8" contained
syn match sequencerOutputParameter "^\s*pitchoutput" contained
syn match sequencerOutputParameter "^\s*po" contained
syn match sequencerInputParameter "^\s*r" contained
syn match sequencerInputParameter "^\s*repeat" contained
syn match sequencerInputParameter "^\s*repeat1" contained
syn match sequencerInputParameter "^\s*repeat2" contained
syn match sequencerInputParameter "^\s*repeat3" contained
syn match sequencerInputParameter "^\s*repeat4" contained
syn match sequencerInputParameter "^\s*repeat5" contained
syn match sequencerInputParameter "^\s*repeat6" contained
syn match sequencerInputParameter "^\s*repeat7" contained
syn match sequencerInputParameter "^\s*repeat8" contained
syn match sequencerInputParameter "^\s*reset" contained
syn match sequencerInputParameter "^\s*rp1" contained
syn match sequencerInputParameter "^\s*rp2" contained
syn match sequencerInputParameter "^\s*rp3" contained
syn match sequencerInputParameter "^\s*rp4" contained
syn match sequencerInputParameter "^\s*rp5" contained
syn match sequencerInputParameter "^\s*rp6" contained
syn match sequencerInputParameter "^\s*rp7" contained
syn match sequencerInputParameter "^\s*rp8" contained
syn match sequencerInputParameter "^\s*s" contained
syn match sequencerInputParameter "^\s*sg" contained
syn match sequencerInputParameter "^\s*slew" contained
syn match sequencerInputParameter "^\s*slew1" contained
syn match sequencerInputParameter "^\s*slew2" contained
syn match sequencerInputParameter "^\s*slew3" contained
syn match sequencerInputParameter "^\s*slew4" contained
syn match sequencerInputParameter "^\s*slew5" contained
syn match sequencerInputParameter "^\s*slew6" contained
syn match sequencerInputParameter "^\s*slew7" contained
syn match sequencerInputParameter "^\s*slew8" contained
syn match sequencerInputParameter "^\s*stages" contained
syn match sequencerInputParameter "^\s*steps" contained
syn match sequencerInputParameter "^\s*sw1" contained
syn match sequencerInputParameter "^\s*sw2" contained
syn match sequencerInputParameter "^\s*sw3" contained
syn match sequencerInputParameter "^\s*sw4" contained
syn match sequencerInputParameter "^\s*sw5" contained
syn match sequencerInputParameter "^\s*sw6" contained
syn match sequencerInputParameter "^\s*sw7" contained
syn match sequencerInputParameter "^\s*sw8" contained
syn match sequencerInputParameter "^\s*tr" contained
syn match sequencerInputParameter "^\s*transpose" contained
syn match sequencerHeader /\[sequencer\]/ contained
syn region sequencerCircuit start=/\[sequencer\]/ end=/\[/me=s-1 transparent contains=sequencerHeader,sequencerInputParameter,sequencerOutputParameter,ioregister,number,cable,quotestring,comment
hi def link sequencerHeader circuitHeader
hi def link sequencerInputParameter inputParameter
hi def link sequencerOutputParameter outputParameter


" sinfonionlink
syn match sinfonionlinkOutputParameter "^\s*b" contained
syn match sinfonionlinkOutputParameter "^\s*beat" contained
syn match sinfonionlinkOutputParameter "^\s*c" contained
syn match sinfonionlinkOutputParameter "^\s*ch" contained
syn match sinfonionlinkOutputParameter "^\s*chaoticdetune" contained
syn match sinfonionlinkOutputParameter "^\s*clock" contained
syn match sinfonionlinkOutputParameter "^\s*degree" contained
syn match sinfonionlinkOutputParameter "^\s*dg" contained
syn match sinfonionlinkOutputParameter "^\s*harmonicshift" contained
syn match sinfonionlinkOutputParameter "^\s*has" contained
syn match sinfonionlinkOutputParameter "^\s*linkstate" contained
syn match sinfonionlinkOutputParameter "^\s*ls" contained
syn match sinfonionlinkOutputParameter "^\s*r" contained
syn match sinfonionlinkOutputParameter "^\s*reset" contained
syn match sinfonionlinkOutputParameter "^\s*ro" contained
syn match sinfonionlinkOutputParameter "^\s*root" contained
syn match sinfonionlinkOutputParameter "^\s*s" contained
syn match sinfonionlinkOutputParameter "^\s*step" contained
syn match sinfonionlinkOutputParameter "^\s*tr" contained
syn match sinfonionlinkOutputParameter "^\s*transpose" contained
syn match sinfonionlinkHeader /\[sinfonionlink\]/ contained
syn region sinfonionlinkCircuit start=/\[sinfonionlink\]/ end=/\[/me=s-1 transparent contains=sinfonionlinkHeader,sinfonionlinkInputParameter,sinfonionlinkOutputParameter,ioregister,number,cable,quotestring,comment
hi def link sinfonionlinkHeader circuitHeader
hi def link sinfonionlinkInputParameter inputParameter
hi def link sinfonionlinkOutputParameter outputParameter


" slew
syn match slewOutputParameter "^\s*c" contained
syn match slewInputParameter "^\s*d" contained
syn match slewOutputParameter "^\s*e" contained
syn match slewOutputParameter "^\s*exponential" contained
syn match slewInputParameter "^\s*g" contained
syn match slewInputParameter "^\s*gate" contained
syn match slewInputParameter "^\s*i" contained
syn match slewInputParameter "^\s*input" contained
syn match slewOutputParameter "^\s*l" contained
syn match slewOutputParameter "^\s*linear" contained
syn match slewOutputParameter "^\s*scurve" contained
syn match slewInputParameter "^\s*slew" contained
syn match slewInputParameter "^\s*slewdown" contained
syn match slewInputParameter "^\s*slewup" contained
syn match slewInputParameter "^\s*sw" contained
syn match slewInputParameter "^\s*u" contained
syn match slewHeader /\[slew\]/ contained
syn region slewCircuit start=/\[slew\]/ end=/\[/me=s-1 transparent contains=slewHeader,slewInputParameter,slewOutputParameter,ioregister,number,cable,quotestring,comment
hi def link slewHeader circuitHeader
hi def link slewInputParameter inputParameter
hi def link slewOutputParameter outputParameter


" spring
syn match springInputParameter "^\s*f" contained
syn match springInputParameter "^\s*fi" contained
syn match springInputParameter "^\s*flowresistance" contained
syn match springInputParameter "^\s*fr" contained
syn match springInputParameter "^\s*friction" contained
syn match springInputParameter "^\s*g" contained
syn match springInputParameter "^\s*gravity" contained
syn match springInputParameter "^\s*m" contained
syn match springInputParameter "^\s*mass" contained
syn match springOutputParameter "^\s*p" contained
syn match springOutputParameter "^\s*position" contained
syn match springInputParameter "^\s*r" contained
syn match springInputParameter "^\s*reset" contained
syn match springInputParameter "^\s*sf" contained
syn match springInputParameter "^\s*sh" contained
syn match springInputParameter "^\s*shove" contained
syn match springInputParameter "^\s*shoveforce" contained
syn match springInputParameter "^\s*sp" contained
syn match springInputParameter "^\s*speed" contained
syn match springInputParameter "^\s*spo" contained
syn match springInputParameter "^\s*springforce" contained
syn match springInputParameter "^\s*startposition" contained
syn match springInputParameter "^\s*startvelocity" contained
syn match springInputParameter "^\s*sv" contained
syn match springOutputParameter "^\s*v" contained
syn match springOutputParameter "^\s*velocity" contained
syn match springHeader /\[spring\]/ contained
syn region springCircuit start=/\[spring\]/ end=/\[/me=s-1 transparent contains=springHeader,springInputParameter,springOutputParameter,ioregister,number,cable,quotestring,comment
hi def link springHeader circuitHeader
hi def link springInputParameter inputParameter
hi def link springOutputParameter outputParameter


" superjust
syn match superjustInputParameter "^\s*b" contained
syn match superjustInputParameter "^\s*bypass" contained
syn match superjustInputParameter "^\s*i1" contained
syn match superjustInputParameter "^\s*i2" contained
syn match superjustInputParameter "^\s*i3" contained
syn match superjustInputParameter "^\s*i4" contained
syn match superjustInputParameter "^\s*i5" contained
syn match superjustInputParameter "^\s*i6" contained
syn match superjustInputParameter "^\s*i7" contained
syn match superjustInputParameter "^\s*i8" contained
syn match superjustInputParameter "^\s*input" contained
syn match superjustInputParameter "^\s*input1" contained
syn match superjustInputParameter "^\s*input2" contained
syn match superjustInputParameter "^\s*input3" contained
syn match superjustInputParameter "^\s*input4" contained
syn match superjustInputParameter "^\s*input5" contained
syn match superjustInputParameter "^\s*input6" contained
syn match superjustInputParameter "^\s*input7" contained
syn match superjustInputParameter "^\s*input8" contained
syn match superjustOutputParameter "^\s*o1" contained
syn match superjustOutputParameter "^\s*o2" contained
syn match superjustOutputParameter "^\s*o3" contained
syn match superjustOutputParameter "^\s*o4" contained
syn match superjustOutputParameter "^\s*o5" contained
syn match superjustOutputParameter "^\s*o6" contained
syn match superjustOutputParameter "^\s*o7" contained
syn match superjustOutputParameter "^\s*o8" contained
syn match superjustOutputParameter "^\s*output" contained
syn match superjustOutputParameter "^\s*output1" contained
syn match superjustOutputParameter "^\s*output2" contained
syn match superjustOutputParameter "^\s*output3" contained
syn match superjustOutputParameter "^\s*output4" contained
syn match superjustOutputParameter "^\s*output5" contained
syn match superjustOutputParameter "^\s*output6" contained
syn match superjustOutputParameter "^\s*output7" contained
syn match superjustOutputParameter "^\s*output8" contained
syn match superjustInputParameter "^\s*tm" contained
syn match superjustInputParameter "^\s*tp" contained
syn match superjustInputParameter "^\s*tr" contained
syn match superjustInputParameter "^\s*transpose" contained
syn match superjustInputParameter "^\s*tuningmode" contained
syn match superjustInputParameter "^\s*tuningpitch" contained
syn match superjustHeader /\[superjust\]/ contained
syn region superjustCircuit start=/\[superjust\]/ end=/\[/me=s-1 transparent contains=superjustHeader,superjustInputParameter,superjustOutputParameter,ioregister,number,cable,quotestring,comment
hi def link superjustHeader circuitHeader
hi def link superjustInputParameter inputParameter
hi def link superjustOutputParameter outputParameter


" switch
syn match switchInputParameter "^\s*b" contained
syn match switchInputParameter "^\s*backward" contained
syn match switchInputParameter "^\s*f" contained
syn match switchInputParameter "^\s*forward" contained
syn match switchInputParameter "^\s*i1" contained
syn match switchInputParameter "^\s*i10" contained
syn match switchInputParameter "^\s*i11" contained
syn match switchInputParameter "^\s*i12" contained
syn match switchInputParameter "^\s*i13" contained
syn match switchInputParameter "^\s*i14" contained
syn match switchInputParameter "^\s*i15" contained
syn match switchInputParameter "^\s*i16" contained
syn match switchInputParameter "^\s*i2" contained
syn match switchInputParameter "^\s*i3" contained
syn match switchInputParameter "^\s*i4" contained
syn match switchInputParameter "^\s*i5" contained
syn match switchInputParameter "^\s*i6" contained
syn match switchInputParameter "^\s*i7" contained
syn match switchInputParameter "^\s*i8" contained
syn match switchInputParameter "^\s*i9" contained
syn match switchInputParameter "^\s*input" contained
syn match switchInputParameter "^\s*input1" contained
syn match switchInputParameter "^\s*input10" contained
syn match switchInputParameter "^\s*input11" contained
syn match switchInputParameter "^\s*input12" contained
syn match switchInputParameter "^\s*input13" contained
syn match switchInputParameter "^\s*input14" contained
syn match switchInputParameter "^\s*input15" contained
syn match switchInputParameter "^\s*input16" contained
syn match switchInputParameter "^\s*input2" contained
syn match switchInputParameter "^\s*input3" contained
syn match switchInputParameter "^\s*input4" contained
syn match switchInputParameter "^\s*input5" contained
syn match switchInputParameter "^\s*input6" contained
syn match switchInputParameter "^\s*input7" contained
syn match switchInputParameter "^\s*input8" contained
syn match switchInputParameter "^\s*input9" contained
syn match switchOutputParameter "^\s*o1" contained
syn match switchOutputParameter "^\s*o10" contained
syn match switchOutputParameter "^\s*o11" contained
syn match switchOutputParameter "^\s*o12" contained
syn match switchOutputParameter "^\s*o13" contained
syn match switchOutputParameter "^\s*o14" contained
syn match switchOutputParameter "^\s*o15" contained
syn match switchOutputParameter "^\s*o16" contained
syn match switchOutputParameter "^\s*o2" contained
syn match switchOutputParameter "^\s*o3" contained
syn match switchOutputParameter "^\s*o4" contained
syn match switchOutputParameter "^\s*o5" contained
syn match switchOutputParameter "^\s*o6" contained
syn match switchOutputParameter "^\s*o7" contained
syn match switchOutputParameter "^\s*o8" contained
syn match switchOutputParameter "^\s*o9" contained
syn match switchInputParameter "^\s*of" contained
syn match switchInputParameter "^\s*offset" contained
syn match switchOutputParameter "^\s*output" contained
syn match switchOutputParameter "^\s*output1" contained
syn match switchOutputParameter "^\s*output10" contained
syn match switchOutputParameter "^\s*output11" contained
syn match switchOutputParameter "^\s*output12" contained
syn match switchOutputParameter "^\s*output13" contained
syn match switchOutputParameter "^\s*output14" contained
syn match switchOutputParameter "^\s*output15" contained
syn match switchOutputParameter "^\s*output16" contained
syn match switchOutputParameter "^\s*output2" contained
syn match switchOutputParameter "^\s*output3" contained
syn match switchOutputParameter "^\s*output4" contained
syn match switchOutputParameter "^\s*output5" contained
syn match switchOutputParameter "^\s*output6" contained
syn match switchOutputParameter "^\s*output7" contained
syn match switchOutputParameter "^\s*output8" contained
syn match switchOutputParameter "^\s*output9" contained
syn match switchInputParameter "^\s*r" contained
syn match switchInputParameter "^\s*reset" contained
syn match switchInputParameter "^\s*s" contained
syn match switchInputParameter "^\s*shuffle" contained
syn match switchInputParameter "^\s*so" contained
syn match switchInputParameter "^\s*sort" contained
syn match switchHeader /\[switch\]/ contained
syn region switchCircuit start=/\[switch\]/ end=/\[/me=s-1 transparent contains=switchHeader,switchInputParameter,switchOutputParameter,ioregister,number,cable,quotestring,comment
hi def link switchHeader circuitHeader
hi def link switchInputParameter inputParameter
hi def link switchOutputParameter outputParameter


" switchedpot
syn match switchedpotInputParameter "^\s*b" contained
syn match switchedpotInputParameter "^\s*bipolar" contained
syn match switchedpotOutputParameter "^\s*o1" contained
syn match switchedpotOutputParameter "^\s*o2" contained
syn match switchedpotOutputParameter "^\s*o3" contained
syn match switchedpotOutputParameter "^\s*o4" contained
syn match switchedpotOutputParameter "^\s*o5" contained
syn match switchedpotOutputParameter "^\s*o6" contained
syn match switchedpotOutputParameter "^\s*o7" contained
syn match switchedpotOutputParameter "^\s*o8" contained
syn match switchedpotOutputParameter "^\s*output" contained
syn match switchedpotOutputParameter "^\s*output1" contained
syn match switchedpotOutputParameter "^\s*output2" contained
syn match switchedpotOutputParameter "^\s*output3" contained
syn match switchedpotOutputParameter "^\s*output4" contained
syn match switchedpotOutputParameter "^\s*output5" contained
syn match switchedpotOutputParameter "^\s*output6" contained
syn match switchedpotOutputParameter "^\s*output7" contained
syn match switchedpotOutputParameter "^\s*output8" contained
syn match switchedpotInputParameter "^\s*p" contained
syn match switchedpotInputParameter "^\s*pot" contained
syn match switchedpotInputParameter "^\s*s1" contained
syn match switchedpotInputParameter "^\s*s2" contained
syn match switchedpotInputParameter "^\s*s3" contained
syn match switchedpotInputParameter "^\s*s4" contained
syn match switchedpotInputParameter "^\s*s5" contained
syn match switchedpotInputParameter "^\s*s6" contained
syn match switchedpotInputParameter "^\s*s7" contained
syn match switchedpotInputParameter "^\s*s8" contained
syn match switchedpotInputParameter "^\s*switch" contained
syn match switchedpotInputParameter "^\s*switch1" contained
syn match switchedpotInputParameter "^\s*switch2" contained
syn match switchedpotInputParameter "^\s*switch3" contained
syn match switchedpotInputParameter "^\s*switch4" contained
syn match switchedpotInputParameter "^\s*switch5" contained
syn match switchedpotInputParameter "^\s*switch6" contained
syn match switchedpotInputParameter "^\s*switch7" contained
syn match switchedpotInputParameter "^\s*switch8" contained
syn match switchedpotHeader /\[switchedpot\]/ contained
syn region switchedpotCircuit start=/\[switchedpot\]/ end=/\[/me=s-1 transparent contains=switchedpotHeader,switchedpotInputParameter,switchedpotOutputParameter,ioregister,number,cable,quotestring,comment
hi def link switchedpotHeader circuitHeader
hi def link switchedpotInputParameter inputParameter
hi def link switchedpotOutputParameter outputParameter


" timing
syn match timingInputParameter "^\s*c" contained
syn match timingInputParameter "^\s*clock" contained
syn match timingOutputParameter "^\s*o" contained
syn match timingOutputParameter "^\s*output" contained
syn match timingInputParameter "^\s*r" contained
syn match timingInputParameter "^\s*reset" contained
syn match timingInputParameter "^\s*t1" contained
syn match timingInputParameter "^\s*t2" contained
syn match timingInputParameter "^\s*t3" contained
syn match timingInputParameter "^\s*t4" contained
syn match timingInputParameter "^\s*t5" contained
syn match timingInputParameter "^\s*t6" contained
syn match timingInputParameter "^\s*t7" contained
syn match timingInputParameter "^\s*t8" contained
syn match timingInputParameter "^\s*timing" contained
syn match timingInputParameter "^\s*timing1" contained
syn match timingInputParameter "^\s*timing2" contained
syn match timingInputParameter "^\s*timing3" contained
syn match timingInputParameter "^\s*timing4" contained
syn match timingInputParameter "^\s*timing5" contained
syn match timingInputParameter "^\s*timing6" contained
syn match timingInputParameter "^\s*timing7" contained
syn match timingInputParameter "^\s*timing8" contained
syn match timingHeader /\[timing\]/ contained
syn region timingCircuit start=/\[timing\]/ end=/\[/me=s-1 transparent contains=timingHeader,timingInputParameter,timingOutputParameter,ioregister,number,cable,quotestring,comment
hi def link timingHeader circuitHeader
hi def link timingInputParameter inputParameter
hi def link timingOutputParameter outputParameter


" togglebutton
syn match togglebuttonInputParameter "^\s*b" contained
syn match togglebuttonInputParameter "^\s*button" contained
syn match togglebuttonInputParameter "^\s*dm" contained
syn match togglebuttonInputParameter "^\s*doubleclickmode" contained
syn match togglebuttonInputParameter "^\s*fv" contained
syn match togglebuttonOutputParameter "^\s*inverted" contained
syn match togglebuttonOutputParameter "^\s*iv" contained
syn match togglebuttonOutputParameter "^\s*l" contained
syn match togglebuttonOutputParameter "^\s*led" contained
syn match togglebuttonOutputParameter "^\s*n" contained
syn match togglebuttonOutputParameter "^\s*negated" contained
syn match togglebuttonOutputParameter "^\s*o" contained
syn match togglebuttonInputParameter "^\s*offvalue" contained
syn match togglebuttonInputParameter "^\s*onvalue" contained
syn match togglebuttonOutputParameter "^\s*output" contained
syn match togglebuttonInputParameter "^\s*ov" contained
syn match togglebuttonInputParameter "^\s*r" contained
syn match togglebuttonInputParameter "^\s*reset" contained
syn match togglebuttonInputParameter "^\s*startvalue" contained
syn match togglebuttonInputParameter "^\s*sv" contained
syn match togglebuttonHeader /\[togglebutton\]/ contained
syn region togglebuttonCircuit start=/\[togglebutton\]/ end=/\[/me=s-1 transparent contains=togglebuttonHeader,togglebuttonInputParameter,togglebuttonOutputParameter,ioregister,number,cable,quotestring,comment
hi def link togglebuttonHeader circuitHeader
hi def link togglebuttonInputParameter inputParameter
hi def link togglebuttonOutputParameter outputParameter


" transient
syn match transientInputParameter "^\s*c" contained
syn match transientInputParameter "^\s*clock" contained
syn match transientInputParameter "^\s*d" contained
syn match transientInputParameter "^\s*duration" contained
syn match transientInputParameter "^\s*e" contained
syn match transientInputParameter "^\s*end" contained
syn match transientOutputParameter "^\s*endoftransient" contained
syn match transientOutputParameter "^\s*et" contained
syn match transientInputParameter "^\s*f" contained
syn match transientInputParameter "^\s*freeze" contained
syn match transientInputParameter "^\s*lo" contained
syn match transientInputParameter "^\s*loop" contained
syn match transientOutputParameter "^\s*o" contained
syn match transientOutputParameter "^\s*output" contained
syn match transientOutputParameter "^\s*p" contained
syn match transientOutputParameter "^\s*phase" contained
syn match transientInputParameter "^\s*pingpong" contained
syn match transientInputParameter "^\s*pp" contained
syn match transientInputParameter "^\s*r" contained
syn match transientInputParameter "^\s*reset" contained
syn match transientInputParameter "^\s*st" contained
syn match transientInputParameter "^\s*start" contained
syn match transientHeader /\[transient\]/ contained
syn region transientCircuit start=/\[transient\]/ end=/\[/me=s-1 transparent contains=transientHeader,transientInputParameter,transientOutputParameter,ioregister,number,cable,quotestring,comment
hi def link transientHeader circuitHeader
hi def link transientInputParameter inputParameter
hi def link transientOutputParameter outputParameter


" triggerdelay
syn match triggerdelayInputParameter "^\s*c" contained
syn match triggerdelayInputParameter "^\s*clock" contained
syn match triggerdelayInputParameter "^\s*delay" contained
syn match triggerdelayInputParameter "^\s*dl" contained
syn match triggerdelayInputParameter "^\s*gatelength" contained
syn match triggerdelayInputParameter "^\s*gl" contained
syn match triggerdelayInputParameter "^\s*i" contained
syn match triggerdelayInputParameter "^\s*input" contained
syn match triggerdelayInputParameter "^\s*m" contained
syn match triggerdelayInputParameter "^\s*mute" contained
syn match triggerdelayOutputParameter "^\s*o" contained
syn match triggerdelayOutputParameter "^\s*output" contained
syn match triggerdelayOutputParameter "^\s*ov" contained
syn match triggerdelayOutputParameter "^\s*overflow" contained
syn match triggerdelayInputParameter "^\s*repeats" contained
syn match triggerdelayInputParameter "^\s*rp" contained
syn match triggerdelayHeader /\[triggerdelay\]/ contained
syn region triggerdelayCircuit start=/\[triggerdelay\]/ end=/\[/me=s-1 transparent contains=triggerdelayHeader,triggerdelayInputParameter,triggerdelayOutputParameter,ioregister,number,cable,quotestring,comment
hi def link triggerdelayHeader circuitHeader
hi def link triggerdelayInputParameter inputParameter
hi def link triggerdelayOutputParameter outputParameter


" unusedfaders
syn match unusedfadersInputParameter "^\s*f" contained
syn match unusedfadersInputParameter "^\s*firstfader" contained
syn match unusedfadersInputParameter "^\s*n" contained
syn match unusedfadersInputParameter "^\s*numfaders" contained
syn match unusedfadersInputParameter "^\s*s" contained
syn match unusedfadersInputParameter "^\s*sa" contained
syn match unusedfadersInputParameter "^\s*select" contained
syn match unusedfadersInputParameter "^\s*selectat" contained
syn match unusedfadersHeader /\[unusedfaders\]/ contained
syn region unusedfadersCircuit start=/\[unusedfaders\]/ end=/\[/me=s-1 transparent contains=unusedfadersHeader,unusedfadersInputParameter,unusedfadersOutputParameter,ioregister,number,cable,quotestring,comment
hi def link unusedfadersHeader circuitHeader
hi def link unusedfadersInputParameter inputParameter
hi def link unusedfadersOutputParameter outputParameter


" vcotuner
syn match vcotunerInputParameter "^\s*b" contained
syn match vcotunerInputParameter "^\s*basepitch" contained
syn match vcotunerOutputParameter "^\s*c" contained
syn match vcotunerOutputParameter "^\s*cents" contained
syn match vcotunerInputParameter "^\s*concertpitch" contained
syn match vcotunerInputParameter "^\s*cp" contained
syn match vcotunerInputParameter "^\s*display" contained
syn match vcotunerInputParameter "^\s*dy" contained
syn match vcotunerInputParameter "^\s*header" contained
syn match vcotunerInputParameter "^\s*hr" contained
syn match vcotunerOutputParameter "^\s*hz" contained
syn match vcotunerOutputParameter "^\s*intune" contained
syn match vcotunerOutputParameter "^\s*it" contained
syn match vcotunerOutputParameter "^\s*ledflat" contained
syn match vcotunerOutputParameter "^\s*ledintune" contained
syn match vcotunerOutputParameter "^\s*ledsharp" contained
syn match vcotunerOutputParameter "^\s*lf" contained
syn match vcotunerOutputParameter "^\s*ls" contained
syn match vcotunerOutputParameter "^\s*lt" contained
syn match vcotunerOutputParameter "^\s*p" contained
syn match vcotunerInputParameter "^\s*pc" contained
syn match vcotunerOutputParameter "^\s*pitch" contained
syn match vcotunerInputParameter "^\s*precision" contained
syn match vcotunerOutputParameter "^\s*referencepitch" contained
syn match vcotunerOutputParameter "^\s*rp" contained
syn match vcotunerInputParameter "^\s*s" contained
syn match vcotunerInputParameter "^\s*sa" contained
syn match vcotunerInputParameter "^\s*select" contained
syn match vcotunerInputParameter "^\s*selectat" contained
syn match vcotunerInputParameter "^\s*sm" contained
syn match vcotunerInputParameter "^\s*smooth" contained
syn match vcotunerOutputParameter "^\s*t" contained
syn match vcotunerInputParameter "^\s*tn" contained
syn match vcotunerOutputParameter "^\s*tuning" contained
syn match vcotunerInputParameter "^\s*tuningnote" contained
syn match vcotunerOutputParameter "^\s*vcofound" contained
syn match vcotunerOutputParameter "^\s*vf" contained
syn match vcotunerHeader /\[vcotuner\]/ contained
syn region vcotunerCircuit start=/\[vcotuner\]/ end=/\[/me=s-1 transparent contains=vcotunerHeader,vcotunerInputParameter,vcotunerOutputParameter,ioregister,number,cable,quotestring,comment
hi def link vcotunerHeader circuitHeader
hi def link vcotunerInputParameter inputParameter
hi def link vcotunerOutputParameter outputParameter


" watch
syn match watchOutputParameter "^\s*c" contained
syn match watchOutputParameter "^\s*cd" contained
syn match watchOutputParameter "^\s*changed" contained
syn match watchOutputParameter "^\s*changeddown" contained
syn match watchOutputParameter "^\s*changedup" contained
syn match watchOutputParameter "^\s*cu" contained
syn match watchOutputParameter "^\s*e" contained
syn match watchOutputParameter "^\s*ed" contained
syn match watchOutputParameter "^\s*edge" contained
syn match watchOutputParameter "^\s*edgedown" contained
syn match watchInputParameter "^\s*edgesize" contained
syn match watchOutputParameter "^\s*edgeup" contained
syn match watchInputParameter "^\s*es" contained
syn match watchOutputParameter "^\s*eu" contained
syn match watchInputParameter "^\s*h" contained
syn match watchInputParameter "^\s*histeresis" contained
syn match watchInputParameter "^\s*i" contained
syn match watchInputParameter "^\s*input" contained
syn match watchOutputParameter "^\s*m" contained
syn match watchOutputParameter "^\s*md" contained
syn match watchOutputParameter "^\s*moving" contained
syn match watchOutputParameter "^\s*movingdown" contained
syn match watchOutputParameter "^\s*movingup" contained
syn match watchOutputParameter "^\s*mu" contained
syn match watchInputParameter "^\s*r" contained
syn match watchInputParameter "^\s*response" contained
syn match watchOutputParameter "^\s*s" contained
syn match watchOutputParameter "^\s*sd" contained
syn match watchOutputParameter "^\s*sl" contained
syn match watchOutputParameter "^\s*slope" contained
syn match watchInputParameter "^\s*ss" contained
syn match watchOutputParameter "^\s*step" contained
syn match watchOutputParameter "^\s*stepdown" contained
syn match watchInputParameter "^\s*stepsize" contained
syn match watchOutputParameter "^\s*stepup" contained
syn match watchOutputParameter "^\s*su" contained
syn match watchInputParameter "^\s*taptempo" contained
syn match watchInputParameter "^\s*th" contained
syn match watchInputParameter "^\s*threshold" contained
syn match watchInputParameter "^\s*tt" contained
syn match watchHeader /\[watch\]/ contained
syn region watchCircuit start=/\[watch\]/ end=/\[/me=s-1 transparent contains=watchHeader,watchInputParameter,watchOutputParameter,ioregister,number,cable,quotestring,comment
hi def link watchHeader circuitHeader
hi def link watchInputParameter inputParameter
hi def link watchOutputParameter outputParameter
